<?php
class ControllerReportAdvProductProfit extends Controller { 
	public function index() {  
		// Insert DB columns
		$query = $this->db->query("DESC " . DB_PREFIX . "product cost_additional");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `cost_additional` decimal(15,4) NOT NULL DEFAULT '0.0000' AFTER `price`;");
			}

		$query = $this->db->query("DESC " . DB_PREFIX . "product cost_percentage");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `cost_percentage` decimal(15,2) NOT NULL DEFAULT '0.00' AFTER `price`;");
			}

		$query = $this->db->query("DESC " . DB_PREFIX . "product cost_amount");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `cost_amount` decimal(15,4) NOT NULL DEFAULT '0.0000' AFTER `price`;");
			}
			
		$query = $this->db->query("DESC " . DB_PREFIX . "product cost");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `cost` decimal(15,4) NOT NULL DEFAULT '0.0000' AFTER `price`;");
			}

		$query = $this->db->query("DESC " . DB_PREFIX . "product_option_value cost_prefix");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product_option_value` ADD `cost_prefix` varchar(1) COLLATE utf8_bin NOT NULL AFTER `price`;");
			}	
			
		$query = $this->db->query("DESC " . DB_PREFIX . "product_option_value cost");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "product_option_value` ADD `cost` decimal(15,4) NOT NULL DEFAULT '0.0000' AFTER `price`;");
			}	
			
		$query = $this->db->query("DESC " . DB_PREFIX . "order_product cost");
			if (!$query->num_rows) {
				$this->db->query("ALTER TABLE `" . DB_PREFIX . "order_product` ADD `cost` decimal(15,4) NOT NULL DEFAULT '0.0000';");
			}

		$this->load->language('report/adv_product_profit');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('report/adv_product_profit');
		
		if (isset($this->request->post['filter_date_start'])) {
			$filter_date_start = $this->request->post['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->post['filter_date_end'])) {
			$filter_date_end = $this->request->post['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		$this->data['ranges'] = array();
		
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_custom'),
			'value' => 'custom',
		);			
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_week'),
			'value' => 'week',
		);		
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_month'),
			'value' => 'month',
		);					
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_quarter'),
			'value' => 'quarter',
		);
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_year'),
			'value' => 'year',
		);
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_current_week'),
			'value' => 'current_week',
		);
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_current_month'),
			'value' => 'current_month',
		);	
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_current_quarter'),
			'value' => 'current_quarter',
		);			
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_current_year'),
			'value' => 'current_year',
		);			
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_last_week'),
			'value' => 'last_week',
		);
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_last_month'),
			'value' => 'last_month',
		);	
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_last_quarter'),
			'value' => 'last_quarter',
		);			
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_last_year'),
			'value' => 'last_year',
		);			
		$this->data['ranges'][] = array(
			'text'  => $this->language->get('stat_all_time'),
			'value' => 'all_time',
		);

		if (isset($this->request->post['filter_range'])) {
			$filter_range = $this->request->post['filter_range'];
		} else {
			$filter_range = 'current_year'; //show Current Year in Statistics Range by default
		}

		$this->data['report'] = array();
		
		$this->data['report'][] = array(
			'text'  => $this->language->get('text_products'),
			'value' => 'products',
		);			
		$this->data['report'][] = array(
			'text'  => $this->language->get('text_manufacturers'),
			'value' => 'manufacturers',
		);		
		$this->data['report'][] = array(
			'text'  => $this->language->get('text_categories'),
			'value' => 'categories',
		);	
		
		if (isset($this->request->post['filter_report'])) {
			$filter_report = $this->request->post['filter_report'];
		} else {
			$filter_report = 'products'; //show Products in Report By default
		}	
		
		if (isset($this->request->post['filter_ogrouping'])) {
			$filter_ogrouping = $this->request->post['filter_ogrouping'];		
		} else {
			$filter_ogrouping = NULL;
		}	
		
		$this->data['groups'] = array();

		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_no_group'),
			'value' => 'no_group',
		);
		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_year'),
			'value' => 'year',
		);
		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_quarter'),
			'value' => 'quarter',
		);
		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_month'),
			'value' => 'month',
		);
		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_week'),
			'value' => 'week',
		);
		$this->data['groups'][] = array(
			'text'  => $this->language->get('text_day'),
			'value' => 'day',
		);
		
		if (isset($this->request->post['filter_group'])) {
			$filter_group = $this->request->post['filter_group'];
		} else {
			$filter_group = 'no_group'; //show No Grouping in Group By default
		}		

		if (isset($this->request->post['filter_sort'])) {
			$filter_sort = $this->request->post['filter_sort'];
		} else {
			$filter_sort = 'quantity';
		}	

		if (isset($this->request->post['filter_details'])) {
			$filter_details = $this->request->post['filter_details'];
		} else {
			$filter_details = 0;
		}

		if (isset($this->request->post['filter_limit'])) {
			$filter_limit = $this->request->post['filter_limit'];
		} else {
			$filter_limit = 25;
		}

		$this->data['order_statuses'] = $this->model_report_adv_product_profit->getOrderStatuses(); 
		if (isset($this->request->post['filter_order_status_id']) && is_array($this->request->post['filter_order_status_id'])) {
			$filter_order_status_id = array_flip($this->request->post['filter_order_status_id']);
		} else {
			$filter_order_status_id = '';
		}

		$this->data['stores'] = $this->model_report_adv_product_profit->getOrderStores();
		if (isset($this->request->post['filter_store_id']) && is_array($this->request->post['filter_store_id'])) {
			$filter_store_id = array_flip($this->request->post['filter_store_id']);
		} else {
			$filter_store_id = '';			
		}

		$this->data['currencies'] = $this->model_report_adv_product_profit->getOrderCurrencies();
		if (isset($this->request->post['filter_currency']) && is_array($this->request->post['filter_currency'])) {
			$filter_currency = array_flip($this->request->post['filter_currency']);
		} else {
			$filter_currency = '';		
		}

		$this->data['taxes'] = $this->model_report_adv_product_profit->getOrderTaxes();
		if (isset($this->request->post['filter_taxes']) && is_array($this->request->post['filter_taxes'])) {
			$filter_taxes = array_flip($this->request->post['filter_taxes']);
		} else {
			$filter_taxes = '';		
		}

		$this->data['customer_groups'] = $this->model_report_adv_product_profit->getOrderCustomerGroups();
		if (isset($this->request->post['filter_customer_group_id']) && is_array($this->request->post['filter_customer_group_id'])) {
			$filter_customer_group_id = array_flip($this->request->post['filter_customer_group_id']);
		} else {
			$filter_customer_group_id = '';
		}

		if (isset($this->request->post['filter_company'])) {
			$filter_company = $this->request->post['filter_company'];
		} else {
			$filter_company = '';
		}
		
		if (isset($this->request->post['filter_customer_id'])) {
			$filter_customer_id = $this->request->post['filter_customer_id'];
		} else {
			$filter_customer_id = '';
		}

		if (isset($this->request->post['filter_email'])) {
			$filter_email = $this->request->post['filter_email'];
		} else {
			$filter_email = '';
		}

		$this->data['categories'] = $this->model_report_adv_product_profit->getProductsCategories(0);	
		if (isset($this->request->post['filter_category']) && is_array($this->request->post['filter_category'])) {
			$filter_category = array_flip($this->request->post['filter_category']);
		} else {
			$filter_category = '';
		}
		
		$this->data['manufacturers'] = $this->model_report_adv_product_profit->getProductsManufacturers(); 
		if (isset($this->request->post['filter_manufacturer']) && is_array($this->request->post['filter_manufacturer'])) {
			$filter_manufacturer = array_flip($this->request->post['filter_manufacturer']);
		} else {
			$filter_manufacturer = '';
		}

		if (isset($this->request->post['filter_sku'])) {
			$filter_sku = $this->request->post['filter_sku'];
		} else {
			$filter_sku = '';
		}

		if (isset($this->request->post['filter_product_id'])) {
			$filter_product_id = $this->request->post['filter_product_id'];
		} else {
			$filter_product_id = '';
		}
		
		if (isset($this->request->post['filter_model'])) {
			$filter_model = $this->request->post['filter_model'];
		} else {
			$filter_model = '';
		}
		
		$this->data['product_options'] = $this->model_report_adv_product_profit->getProductOptions();
		if (isset($this->request->post['filter_option']) && is_array($this->request->post['filter_option'])) {
			$filter_option = array_flip($this->request->post['filter_option']);
		} else {
			$filter_option = '';
		}

		$this->data['attributes'] = $this->model_report_adv_product_profit->getProductAttributes();
		if (isset($this->request->post['filter_attribute']) && is_array($this->request->post['filter_attribute'])) {
			$filter_attribute = array_flip($this->request->post['filter_attribute']);
		} else {
			$filter_attribute = '';
		}
		
		$this->data['locations'] = $this->model_report_adv_product_profit->getProductLocation();			
		if (isset($this->request->post['filter_location']) && is_array($this->request->post['filter_location'])) {
			$filter_location = array_flip($this->request->post['filter_location']);
		} else {
			$filter_location = '';		
		}

		$this->data['affiliates'] = $this->model_report_adv_product_profit->getOrderAffiliate();
		if (isset($this->request->post['filter_affiliate']) && is_array($this->request->post['filter_affiliate'])) {
			$filter_affiliate = array_flip($this->request->post['filter_affiliate']);
		} else {
			$filter_affiliate = '';
		}
		
		$this->data['statuses'] = $this->model_report_adv_product_profit->getProductStatuses();
		if (isset($this->request->post['filter_status']) && is_array($this->request->post['filter_status'])) {
			$filter_status = array_flip($this->request->post['filter_status']);
		} else {
			$filter_status = '';
		}
		
   		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('report/adv_product_profit', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);		

		$this->load->model('report/adv_product_profit');
		
		$this->data['products'] = array();
		
		$data = array(
			'filter_date_start'	     	=> $filter_date_start, 
			'filter_date_end'	     	=> $filter_date_end, 
			'filter_range'           	=> $filter_range,
			'filter_report'           	=> $filter_report,			
			'filter_ogrouping'   	 	=> $filter_ogrouping,			
			'filter_group'           	=> $filter_group,
			'filter_sort'  				=> $filter_sort,	
			'filter_details'  			=> $filter_details,	
			'filter_limit'  			=> $filter_limit,			
			'filter_order_status_id' 	=> $filter_order_status_id,
			'filter_store_id' 	 	 	=> $filter_store_id,
			'filter_currency' 	 	 	=> $filter_currency,
			'filter_taxes' 	 	 	 	=> $filter_taxes,				
			'filter_customer_group_id'	=> $filter_customer_group_id, 
			'filter_company' 	 		=> $filter_company,
			'filter_customer_id' 	 	=> $filter_customer_id,			
			'filter_email' 	 			=> $filter_email,
			'filter_category'    	 	=> $filter_category,
			'filter_manufacturer'    	=> $filter_manufacturer,			
			'filter_sku' 	 			=> $filter_sku,
			'filter_product_id' 	 	=> $filter_product_id,
			'filter_model' 	 			=> $filter_model,					
			'filter_option' 	 	 	=> $filter_option,
			'filter_attribute' 	 	 	=> $filter_attribute,			
			'filter_location'  			=> $filter_location,
			'filter_affiliate'  		=> $filter_affiliate,
			'filter_status'   		 	=> $filter_status
		);
				
		$results = $this->model_report_adv_product_profit->getPurchased($data);

		$this->load->model('tool/image');
		
		foreach ($results as $result) {
			if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}
			
			$this->load->model('catalog/product');
			$category = $this->model_catalog_product->getProductCategories($result['product_id']);
			$manufacturer = $this->model_report_adv_product_profit->getProductManufacturers($result['manufacturer_id']);	

			if ($result['prod_profit']) {
				$profit_margin_percent = ($result['prod_costs']+$result['prod_profit']) > 0 ? round(100 * ($result['prod_profit']) / ($result['prod_costs']+$result['prod_profit']), 2) . '%' : '0%';
				$profit_margin_total_percent = ($result['costs_total']+$result['profit_total']) > 0 ? round(100 * ($result['profit_total']) / ($result['costs_total']+$result['profit_total']), 2) . '%' : '0%';	
			} else {
				$profit_margin_percent = '100%';
				$profit_margin_total_percent = '100%';
			}

			if (!is_null($result['sold_quantity'])) {
				$sold_percent = round(100 * ($result['sold_quantity'] / $result['sold_quantity_total']), 2) . '%';
				$sold_percent_total = '100%';		
			} else {
				$sold_percent = 0;
				$sold_percent_total = 0;
			}
			
			$this->data['products'][] = array(
				'year'		       					=> $result['year'],
				'quarter'		       				=> 'Q' . $result['quarter'],				
				'month'		       					=> $result['month'],											  
				'date_start' 						=> date($this->language->get('date_format_short'), strtotime($result['date_start'])),
				'date_end'   						=> date($this->language->get('date_format_short'), strtotime($result['date_end'])),	
				'product_id' 						=> $result['product_id'],						
				'order_product_id'     				=> $result['order_product_id'],	
				'image'      						=> $image,
				'sku'    							=> $result['sku'],
				'name'     							=> $result['name'],	
				'ooname'    						=> $result['ooname'],
				'oovalue'    						=> $result['oovalue'],						
				'model'    							=> $result['model'],
				'category'  						=> $category,
				'manufacturer'  					=> $manufacturer,
				'status'     						=> $result['status'],
				'sold_quantity' 					=> $result['sold_quantity'],
				'sold_percent' 						=> $sold_percent,						
				'total'    							=> $this->currency->format($result['total'], $this->config->get('config_currency')),			
				'tax'    							=> $this->currency->format($result['tax'], $this->config->get('config_currency')),						
				'prod_costs'      					=> $this->currency->format('-' . ($result['prod_costs']), $this->config->get('config_currency')),			
				'prod_profit'     					=> $this->currency->format($result['prod_profit'], $this->config->get('config_currency')),				
				'profit_margin_percent' 			=> $profit_margin_percent,
				'order_prod_ord_id'     			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_ord_id'] : '',
				'order_prod_ord_idc'     			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_ord_idc'] : '',
				'order_prod_order_date'    			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_order_date'] : '',
				'order_prod_inv_no'     			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_inv_no'] : '',
				'order_prod_name'   				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_name'] : '',
				'order_prod_email'   				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_email'] : '',
				'order_prod_group'   				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_group'] : '',
				'order_prod_shipping_method' 		=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_shipping_method'] : '',
				'order_prod_payment_method'  		=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? strip_tags($result['order_prod_payment_method'], '<br>') : '',
				'order_prod_status'  				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_status'] : '',
				'order_prod_store'      			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_store'] : '',	
				'order_prod_currency' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_currency'] : '',
				'order_prod_price' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_price'] : '',
				'order_prod_quantity' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_quantity'] : '',
				'order_prod_total'  				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_total'] : '',
				'order_prod_tax'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_tax'] : '',
				'order_prod_costs'  				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_costs'] : '',
				'order_prod_profit'   				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_profit'] : '',
				'order_prod_profit_margin_percent' 	=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 1 ? $result['order_prod_profit_margin_percent'] : '',
				'product_ord_id'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_ord_id'] : '',
				'product_ord_idc'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_ord_idc'] : '',
				'product_order_date'    			=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_order_date'] : '',
				'product_inv_no'     				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_inv_no'] : '',
				'product_pid'  						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_pid'] : '',
				'product_pidc'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_pidc'] : '',
				'product_sku'  						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_sku'] : '',
				'product_name'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_name'] : '',
				'product_option'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_option'] : '',
				'product_model'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_model'] : '',
				'product_manu'  					=> isset($this->request->post['filter_report']) && $this->request->post['filter_report'] == 'categories' && isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_manu'] : '',
				'product_currency'  				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_currency'] : '',
				'product_price'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_price'] : '',
				'product_quantity'  				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_quantity'] : '',
				'product_total'  					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_total'] : '',
				'product_tax'  						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_tax'] : '',
				'product_costs'   					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_costs'] : '',
				'product_profit'   					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_profit'] : '',
				'product_profit_margin_percent' 	=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 3 ? $result['product_profit_margin_percent'] : '',
				'customer_ord_id' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_ord_id'] : '',
				'customer_order_date' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_order_date'] : '',
				'customer_inv_no' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_inv_no'] : '',
				'customer_cust_id' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_cust_id'] : '',
				'customer_cust_idc' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_cust_idc'] : '',
				'billing_name' 						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_name'] : '',
				'billing_company' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_company'] : '',
				'billing_address_1' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_address_1'] : '',
				'billing_address_2' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_address_2'] : '',
				'billing_city' 						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_city'] : '',
				'billing_zone' 						=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_zone'] : '',
				'billing_postcode' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_postcode'] : '',
				'billing_country' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['billing_country'] : '',
				'customer_telephone' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['customer_telephone'] : '',
				'shipping_name' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_name'] : '',
				'shipping_company' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_company'] : '',
				'shipping_address_1' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_address_1'] : '',
				'shipping_address_2' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_address_2'] : '',
				'shipping_city' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_city'] : '',
				'shipping_zone' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_zone'] : '',
				'shipping_postcode' 				=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_postcode'] : '',
				'shipping_country' 					=> isset($this->request->post['filter_details']) && $this->request->post['filter_details'] == 2 ? $result['shipping_country'] : '',
				'sold_quantity_total' 				=> $result['sold_quantity_total'],
				'sold_percent_total' 				=> $sold_percent_total,					
				'tax_total' 						=> $this->currency->format($result['tax_total'], $this->config->get('config_currency')),
				'value_total' 						=> $this->currency->format($result['value_total'], $this->config->get('config_currency')),
				'costs_total' 						=> $this->currency->format('-' . ($result['costs_total']), $this->config->get('config_currency')),
				'profit_total' 						=> $this->currency->format($result['profit_total'], $this->config->get('config_currency')),
				'profit_margin_total_percent' 		=> $profit_margin_total_percent,
				'href' 								=> $this->url->link('catalog/product/update', 'token=' . $this->session->data['token'] . '&product_id=' . $result['product_id'], 'SSL')
			);
		}

		$this->data['sales'] = array();
		
		$sales_results = $this->model_report_adv_product_profit->getPurchasedSale($data);
		
		foreach ($sales_results as $sales_result) {
			
			$this->data['sales'][] = array(
				'gyear'		       					=> $sales_result['gyear'],
				'gyear_quarter'		       			=> 'Q' . $sales_result['gquarter']. ' ' . $sales_result['gyear'],
				'gyear_month'		       			=> substr($sales_result['gmonth'],0,3) . ' ' . $sales_result['gyear'],
				'gorders'    						=> $sales_result['gorders'],
				'gcustomers'    					=> $sales_result['gcustomers'],
				'gproducts'    						=> $sales_result['gproducts'],
				'gsales'    						=> $sales_result['gsales'],				
				'gcosts'      						=> $sales_result['gcosts'],
				'gprofit'      						=> $sales_result['gprofit']
			);
		}

		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_no_details'] = $this->language->get('text_no_details');
		$this->data['text_order_list'] = $this->language->get('text_order_list');
		$this->data['text_product_list'] = $this->language->get('text_product_list');
		$this->data['text_order_list'] = $this->language->get('text_order_list');		
		$this->data['text_customer_list'] = $this->language->get('text_customer_list');		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_no_results'] = $this->language->get('text_no_results');		
		$this->data['text_all_status'] = $this->language->get('text_all_status');		
		$this->data['text_all_stores'] = $this->language->get('text_all_stores');
		$this->data['text_all_currencies'] = $this->language->get('text_all_currencies');
		$this->data['text_all_taxes'] = $this->language->get('text_all_taxes');	
		$this->data['text_all_groups'] = $this->language->get('text_all_groups');	
		$this->data['text_all_categories'] = $this->language->get('text_all_categories');
		$this->data['text_all_manufacturers'] = $this->language->get('text_all_manufacturers');
		$this->data['text_all_options'] = $this->language->get('text_all_options');
		$this->data['text_all_attributes'] = $this->language->get('text_all_attributes');	
		$this->data['text_all_locations'] = $this->language->get('text_all_locations');	
		$this->data['text_all_affiliates'] = $this->language->get('text_all_affiliates');
		$this->data['text_none_selected'] = $this->language->get('text_none_selected');
		$this->data['text_selected'] = $this->language->get('text_selected');		
		$this->data['text_detail'] = $this->language->get('text_detail');
		$this->data['text_export_prod_no_details'] = $this->language->get('text_export_prod_no_details');
		$this->data['text_export_prod_order_list'] = $this->language->get('text_export_prod_order_list');
		$this->data['text_export_prod_customer_list'] = $this->language->get('text_export_prod_customer_list');	
		$this->data['text_export_manu_no_details'] = $this->language->get('text_export_manu_no_details');
		$this->data['text_export_manu_product_list'] = $this->language->get('text_export_manu_product_list');
		$this->data['text_export_cat_no_details'] = $this->language->get('text_export_cat_no_details');
		$this->data['text_export_cat_product_list'] = $this->language->get('text_export_cat_product_list');		
		$this->data['text_filter_total'] = $this->language->get('text_filter_total');
		$this->data['text_profit_help'] = $this->language->get('text_profit_help');	
		$this->data['text_filtering_options'] = $this->language->get('text_filtering_options');
		$this->data['text_mv_columns'] = $this->language->get('text_mv_columns');		
		$this->data['text_ol_columns'] = $this->language->get('text_ol_columns');
		$this->data['text_pl_columns'] = $this->language->get('text_pl_columns');			
		$this->data['text_cl_columns'] = $this->language->get('text_cl_columns');
		$this->data['text_pagin_page'] = $this->language->get('text_pagin_page');
		$this->data['text_pagin_of'] = $this->language->get('text_pagin_of');
		$this->data['text_pagin_results'] = $this->language->get('text_pagin_results');		

		$this->data['column_date'] = $this->language->get('column_date');
		$this->data['column_date_start'] = $this->language->get('column_date_start');
		$this->data['column_date_end'] = $this->language->get('column_date_end');
		$this->data['column_image'] = $this->language->get('column_image');
		$this->data['column_sku'] = $this->language->get('column_sku');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_model'] = $this->language->get('column_model');	
		$this->data['column_category'] = $this->language->get('column_category');		
		$this->data['column_manufacturer'] = $this->language->get('column_manufacturer');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_quantity'] = $this->language->get('column_quantity');		
		$this->data['column_sold_quantity'] = $this->language->get('column_sold_quantity');
		$this->data['column_sold_percent'] = $this->language->get('column_sold_percent');			
		$this->data['column_total'] = $this->language->get('column_total');	
		$this->data['column_tax'] = $this->language->get('column_tax');			
		$this->data['column_prod_costs'] = $this->language->get('column_prod_costs');
		$this->data['column_prod_profit'] = $this->language->get('column_prod_profit');
		$this->data['column_profit_margin'] = $this->language->get('column_profit_margin');		
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_order_prod_date_added'] = $this->language->get('column_order_prod_date_added');
		$this->data['column_order_prod_order_id'] = $this->language->get('column_order_prod_order_id');
		$this->data['column_order_prod_inv_date'] = $this->language->get('column_order_prod_inv_date');
		$this->data['column_order_prod_inv_no'] = $this->language->get('column_order_prod_inv_no');
		$this->data['column_order_prod_customer'] = $this->language->get('column_order_prod_customer');		
		$this->data['column_order_prod_email'] = $this->language->get('column_order_prod_email');		
		$this->data['column_order_prod_customer_group'] = $this->language->get('column_order_prod_customer_group');		
		$this->data['column_order_prod_shipping_method'] = $this->language->get('column_order_prod_shipping_method');
		$this->data['column_order_prod_payment_method'] = $this->language->get('column_order_prod_payment_method');		
		$this->data['column_order_prod_status'] = $this->language->get('column_order_prod_status');
		$this->data['column_order_prod_store'] = $this->language->get('column_order_prod_store');
		$this->data['column_order_prod_currency'] = $this->language->get('column_order_prod_currency');
		$this->data['column_order_prod_price'] = $this->language->get('column_order_prod_price');		
		$this->data['column_order_prod_quantity'] = $this->language->get('column_order_prod_quantity');			
		$this->data['column_order_prod_total'] = $this->language->get('column_order_prod_total');
		$this->data['column_order_prod_tax'] = $this->language->get('column_order_prod_tax');	
		$this->data['column_order_prod_costs'] = $this->language->get('column_order_prod_costs');			
		$this->data['column_order_prod_profit'] = $this->language->get('column_order_prod_profit');
		$this->data['column_prod_order_id'] = $this->language->get('column_prod_order_id');		
		$this->data['column_prod_date_added'] = $this->language->get('column_prod_date_added');	
		$this->data['column_prod_inv_no'] = $this->language->get('column_prod_inv_no');			
		$this->data['column_prod_id'] = $this->language->get('column_prod_id');
		$this->data['column_prod_sku'] = $this->language->get('column_prod_sku');		
		$this->data['column_prod_model'] = $this->language->get('column_prod_model');		
		$this->data['column_prod_name'] = $this->language->get('column_prod_name');	
		$this->data['column_prod_option'] = $this->language->get('column_prod_option');			
		$this->data['column_prod_manu'] = $this->language->get('column_prod_manu');
		$this->data['column_prod_currency'] = $this->language->get('column_prod_currency');
		$this->data['column_prod_price'] = $this->language->get('column_prod_price');
		$this->data['column_prod_quantity'] = $this->language->get('column_prod_quantity');
		$this->data['column_prod_total'] = $this->language->get('column_prod_total');
		$this->data['column_prod_tax'] = $this->language->get('column_prod_tax');
		$this->data['column_prod_costs'] = $this->language->get('column_prod_costs');
		$this->data['column_prod_profit'] = $this->language->get('column_prod_profit');			
		$this->data['column_customer_order_id'] = $this->language->get('column_customer_order_id');
		$this->data['column_customer_date_added'] = $this->language->get('column_customer_date_added');
		$this->data['column_customer_inv_no'] = $this->language->get('column_customer_inv_no');
		$this->data['column_customer_cust_id'] = $this->language->get('column_customer_cust_id');
		$this->data['column_billing_name'] = $this->language->get('column_billing_name');
		$this->data['column_billing_company'] = $this->language->get('column_billing_company');
		$this->data['column_billing_address_1'] = $this->language->get('column_billing_address_1');
		$this->data['column_billing_address_2'] = $this->language->get('column_billing_address_2');
		$this->data['column_billing_city'] = $this->language->get('column_billing_city');
		$this->data['column_billing_zone'] = $this->language->get('column_billing_zone');
		$this->data['column_billing_postcode'] = $this->language->get('column_billing_postcode');		
		$this->data['column_billing_country'] = $this->language->get('column_billing_country');
		$this->data['column_customer_telephone'] = $this->language->get('column_customer_telephone');
		$this->data['column_shipping_name'] = $this->language->get('column_shipping_name');
		$this->data['column_shipping_company'] = $this->language->get('column_shipping_company');
		$this->data['column_shipping_address_1'] = $this->language->get('column_shipping_address_1');
		$this->data['column_shipping_address_2'] = $this->language->get('column_shipping_address_2');
		$this->data['column_shipping_city'] = $this->language->get('column_shipping_city');
		$this->data['column_shipping_zone'] = $this->language->get('column_shipping_zone');
		$this->data['column_shipping_postcode'] = $this->language->get('column_shipping_postcode');		
		$this->data['column_shipping_country'] = $this->language->get('column_shipping_country');		
				
		$this->data['entry_date_start'] = $this->language->get('entry_date_start');
		$this->data['entry_date_end'] = $this->language->get('entry_date_end');
		$this->data['entry_range'] = $this->language->get('entry_range'); 
		$this->data['entry_report'] = $this->language->get('entry_report'); 		
		$this->data['entry_option_grouping'] = $this->language->get('entry_option_grouping');		
		$this->data['entry_group'] = $this->language->get('entry_group');
		$this->data['entry_sort_by'] = $this->language->get('entry_sort_by');
		$this->data['entry_show_details'] = $this->language->get('entry_show_details');	
		$this->data['entry_limit'] = $this->language->get('entry_limit');		
		$this->data['entry_status'] = $this->language->get('entry_status');		
		$this->data['entry_store'] = $this->language->get('entry_store');
		$this->data['entry_currency'] = $this->language->get('entry_currency');	
		$this->data['entry_tax'] = $this->language->get('entry_tax');			
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group'); 
		$this->data['entry_company'] = $this->language->get('entry_company');
		$this->data['entry_customer'] = $this->language->get('entry_customer');		
		$this->data['entry_email'] = $this->language->get('entry_email'); 
		$this->data['entry_category'] = $this->language->get('entry_category'); 
		$this->data['entry_manufacturer'] = $this->language->get('entry_manufacturer'); 		
		$this->data['entry_sku'] = $this->language->get('entry_sku');
		$this->data['entry_product'] = $this->language->get('entry_product');
		$this->data['entry_model'] = $this->language->get('entry_model');		
		$this->data['entry_option'] = $this->language->get('entry_option');
		$this->data['entry_attributes'] = $this->language->get('entry_attributes');		
		$this->data['entry_location'] = $this->language->get('entry_location');	
		$this->data['entry_affiliate'] = $this->language->get('entry_affiliate');
		$this->data['entry_prod_status'] = $this->language->get('entry_prod_status');

		$this->data['column_year'] = $this->language->get('column_year');		
		$this->data['column_quarter'] = $this->language->get('column_quarter');
		$this->data['column_month'] = $this->language->get('column_month');
    	$this->data['column_orders'] = $this->language->get('column_orders');
    	$this->data['column_customers'] = $this->language->get('column_customers');		
		$this->data['column_products'] = $this->language->get('column_products');			
		
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['button_chart'] = $this->language->get('button_chart');				
		$this->data['button_export'] = $this->language->get('button_export');
		$this->data['button_settings'] = $this->language->get('button_settings');	

		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['heading_version'] = $this->language->get('heading_version');	
		
		$this->data['token'] = $this->session->data['token'];

		$this->data['filter_date_start'] = $filter_date_start;
		$this->data['filter_date_end'] = $filter_date_end;
		$this->data['filter_range'] = $filter_range;
		$this->data['filter_report'] = $filter_report;			
		$this->data['filter_ogrouping'] = $filter_ogrouping;		
		$this->data['filter_group'] = $filter_group;
		$this->data['filter_sort'] = $filter_sort;	
		$this->data['filter_details'] = $filter_details;
		$this->data['filter_limit'] = $filter_limit;		
		$this->data['filter_order_status_id'] = $filter_order_status_id; 
		$this->data['filter_store_id'] = $filter_store_id; 
		$this->data['filter_currency'] = $filter_currency; 
		$this->data['filter_taxes'] = $filter_taxes;			
		$this->data['filter_customer_group_id'] = $filter_customer_group_id;
		$this->data['filter_company'] = $filter_company; 
		$this->data['filter_customer_id'] = $filter_customer_id; 		
		$this->data['filter_email'] = $filter_email; 
		$this->data['filter_manufacturer'] = $filter_manufacturer; 
		$this->data['filter_category'] = $filter_category; 		
		$this->data['filter_sku'] = $filter_sku; 
		$this->data['filter_product_id'] = $filter_product_id; 
		$this->data['filter_model'] = $filter_model; 		
		$this->data['filter_option'] = $filter_option; 
		$this->data['filter_attribute'] = $filter_attribute; 		
		$this->data['filter_location'] = $filter_location;
		$this->data['filter_affiliate'] = $filter_affiliate; 
		$this->data['filter_status'] = $filter_status;	
		
		$this->template = 'report/adv_product_profit.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
		
    	if (isset($this->request->post['export']) && $this->request->post['export'] == 1) { // export_xls_prod
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_prod.inc.php");
			
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 2) { // export_xls_prod_order_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_prod_order_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 3) { // export_xls_prod_customer_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_prod_customer_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 4) { // export_xls_manu
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_manu.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 5) { // export_xls_manu_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_manu_product_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 6) { // export_xls_cat
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_cat.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 7) { // export_xls_cat_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_xls_cat_product_list.inc.php");
				
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 8) { // export_html_prod
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_prod.inc.php");
			
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 9) { // export_html_prod_order_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_prod_order_list.inc.php");
											
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 10) { // export_html_prod_customer_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_prod_customer_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 11) { // export_html_manu
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_manu.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 12) { // export_html_manu_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_manu_product_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 13) { // export_html_cat
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_cat.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 14) { // export_html_cat_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_html_cat_product_list.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 15) { // export_pdf_prod
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_prod.inc.php");
		
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 16) { // export_pdf_prod_order_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_prod_order_list.inc.php");
						
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 17) { // export_pdf_prod_customer_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_prod_customer_list.inc.php");
			
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 18) { // export_pdf_manu
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_manu.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 19) { // export_pdf_manu_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_manu_product_list.inc.php");
			
		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 20) { // export_pdf_cat
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_cat.inc.php");

		} elseif (isset($this->request->post['export']) && $this->request->post['export'] == 21) { // export_pdf_cat_product_list
			$this->load->model('report/adv_product_profit_export');
    		$results = $this->model_report_adv_product_profit_export->getProductProfitExport($data);
			require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
			include(DIR_APPLICATION."controller/report/adv_reports/ppp_export_pdf_cat_product_list.inc.php");			
		}			
	}
	
	public function customer_autocomplete() {
		$json = array();

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->request->get['filter_customer_id']) || isset($this->request->get['filter_email']) || isset($this->request->get['filter_company'])) {
			$this->load->model('report/adv_product_profit');
					
		if (isset($this->request->get['filter_company'])) {
			$filter_company = $this->request->get['filter_company'];
		} else {
			$filter_company = '';
		}
		
		if (isset($this->request->get['filter_customer_id'])) {
			$filter_customer_id = $this->request->get['filter_customer_id'];
		} else {
			$filter_customer_id = '';
		}

		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = '';
		}	
		
		$data = array(		
			'filter_company' 	 		=> $filter_company,
			'filter_customer_id' 	 	=> $filter_customer_id,			
			'filter_email' 	 			=> $filter_email			
		);
						
		$results = $this->model_report_adv_product_profit->getCustomerAutocomplete($data);
			
			foreach ($results as $result) {
				$json[] = array(
					'customer_id'     		=> $result['customer_id'],
					'cust_company'     		=> html_entity_decode($result['cust_company'], ENT_QUOTES, 'UTF-8'),					
					'cust_name'     		=> html_entity_decode($result['cust_name'], ENT_QUOTES, 'UTF-8'),
					'cust_email'     		=> $result['cust_email']					
				);
			}
		}
		
		$this->response->setOutput(json_encode($json));
	}	
	
	public function product_autocomplete() {
		$json = array();

		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->request->get['filter_sku']) || isset($this->request->get['filter_product_id']) || isset($this->request->get['filter_model'])) {
			$this->load->model('report/adv_product_profit');
					
		if (isset($this->request->get['filter_sku'])) {
			$filter_sku = $this->request->get['filter_sku'];
		} else {
			$filter_sku = '';
		}

		if (isset($this->request->get['filter_product_id'])) {
			$filter_product_id = $this->request->get['filter_product_id'];
		} else {
			$filter_product_id = '';
		}
		
		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = '';
		}
		
		$data = array(				
			'filter_sku' 	 			=> $filter_sku,
			'filter_product_id' 	 	=> $filter_product_id,
			'filter_model' 	 			=> $filter_model			
		);
						
		$results = $this->model_report_adv_product_profit->getProductAutocomplete($data);
			
			foreach ($results as $result) {
				$json[] = array(
					'product_id'     		=> $result['product_id'],
					'prod_sku'     			=> html_entity_decode($result['prod_sku'], ENT_QUOTES, 'UTF-8'),					
					'prod_name'     		=> html_entity_decode($result['prod_name'], ENT_QUOTES, 'UTF-8'),
					'prod_model'     		=> html_entity_decode($result['prod_model'], ENT_QUOTES, 'UTF-8')
				);
			}
		}
		
		$this->response->setOutput(json_encode($json));
	}		
}
?>