<?php
//==============================================================================
// MailChimp Integration v154.3
//
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
//==============================================================================

class ModelModuleMailchimpIntegration extends Model {
	private $type = 'module';
	private $name = 'mailchimp_integration';

	public function send($data, $customer_id = 0) {
		$v14x = (!defined('VERSION') || VERSION < 1.5);
		$v150 = (defined('VERSION') && strpos(VERSION, '1.5.0') === 0);
		$settings = ($v14x || $v150) ? unserialize($this->config->get($this->name . '_data')) : $this->config->get($this->name . '_data');

		if (empty($settings['status']) || empty($settings['apikey']) || empty($settings['listid'])) return;

		$current_email = $data['email'] = (isset($data['email'])) ? $data['email'] : '';
		if ($customer_id) {
			$customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
			$current_email = $customer->row['email'];
		}

		if (!empty($data['newsletter'])) {
			$merge_array = array('EMAIL' => $data['email']);
			if ($settings['fname']) {
				$merge_array[$settings['fname']] = (isset($data['firstname'])) ? $data['firstname'] : '';
			}
			if ($settings['lname']) {
				$merge_array[$settings['lname']] = (isset($data['lastname'])) ? $data['lastname'] : '';
			}
			if ($settings['address'] && !empty($data['address'])) {
				foreach ($data['address'] as $address) {
					if (empty($address['default'])) continue;
					if (isset($address['country_id'])) {
						$this->load->model('localisation/country');
						$country = $this->model_localisation_country->getCountry($address['country_id']);
						$address['iso_code_2'] = $country['iso_code_2'];
					}
					if (isset($address['zone_id'])) {
						$this->load->model('localisation/zone');
						$zone = $this->model_localisation_zone->getZone($address['zone_id']);
						$address['zone'] = html_entity_decode($zone['name'], ENT_QUOTES, 'UTF-8');
					}
					$merge_array[$settings['address']] = array(
						'addr1'		=> $address['address_1'],
						'addr2'		=> $address['address_2'],
						'city'		=> $address['city'],
						'state'		=> $address['zone'],
						'zip'		=> $address['postcode'],
						'country'	=> $address['iso_code_2']
					);
				}
			}
			if ($settings['phone']) {
				$phone = preg_replace('/[^0-9]/', '', (isset($data['telephone'])) ? $data['telephone'] : '0000000000');
				$merge_array[$settings['phone']] = substr($phone,0,3).'-'.substr($phone,3,3).'-'.substr($phone,6);
			}
			$curl_data = array(
				'method'			=> 'listSubscribe',
				'apikey'			=> $settings['apikey'],
				'id'				=> $settings['listid'],
				'email_address'		=> $current_email,
				'merge_vars'		=> $merge_array,
				'double_optin'		=> false,
				'update_existing'	=> true
			);
		} else {
			$curl_data = array(
				'method'			=> 'listUnsubscribe',
				'apikey'			=> $settings['apikey'],
				'id'				=> $settings['listid'],
				'email_address'		=> $current_email
			);
		}

		$response = $this->curlRequest($curl_data);
		if (!empty($response['error']) && $settings['logerrors']) {
			$this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
		}
		return empty($response['error']);
	}

	public function sync($settings) {
		if (empty($settings['status']) || empty($settings['apikey']) || empty($settings['listid'])) return;
		$output = "Completed!\n\n";

		$customers = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer");
		$opencart_emails = array();
		foreach ($customers->rows as $customer) {
			$opencart_emails[] = $customer['email'];
		}

		// MailChimp to OpenCart
		if ($settings['autocreate']) {
			$curl_data = array(
				'method'	=> 'listMembers',
				'apikey'	=> $settings['apikey'],
				'id'		=> $settings['listid'],
				'limit'		=> 15000
			);
			$response = $this->curlRequest($curl_data);
			if (!empty($response['error'])) {
				if ($settings['logerrors']) $this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
				return $response['error'];
			}

			$mailchimp_emails = array();
			foreach ($response['data'] as $member) {
				$mailchimp_emails[] = $member['email'];
			}
			$diff_emails = array_diff($mailchimp_emails, $opencart_emails);

			$created = 0;
			for ($i = 0; $i < count($diff_emails); $i += 50) {
				$curl_data = array(
					'method'			=> 'listMemberInfo',
					'apikey'			=> $settings['apikey'],
					'id'				=> $settings['listid'],
					'email_address'		=> array_slice($diff_emails, $i, 50)
				);

				$response = $this->curlRequest($curl_data);
				if (!empty($response['error'])) {
					if ($settings['logerrors']) $this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
					return $response['error'];
				}

				foreach ($response['data'] as $data) {
					$data_fname = (!empty($data['merges'][$settings['fname']])) ? $data['merges'][$settings['fname']] : '';
					$data_lname = (!empty($data['merges'][$settings['lname']])) ? $data['merges'][$settings['lname']] : '';
					$data_phone = (!empty($data['merges'][$settings['phone']])) ? $data['merges'][$settings['phone']] : '';
					$data_address = (!empty($data['merges'][$settings['address']])) ? $data['merges'][$settings['address']] : '';
					$data_address['country'] = (!empty($data_address['country'])) ? $data_address['country'] : 0;
					$data_address['state'] = (!empty($data_address['state'])) ? $data_address['state'] : 0;

					$sql = "INSERT INTO " . DB_PREFIX . "customer SET";
					$sql .= " status = '0',";
					$sql .= " approved = '1',";
					$sql .= " newsletter = '1',";
					$sql .= " customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "',";
					$sql .= " email = '" . $this->db->escape($data['email']) . "',";
					$sql .= " firstname = '" . $this->db->escape($data_fname) . "',";
					$sql .= " lastname = '" . $this->db->escape($data_lname) . "',";
					$sql .= " telephone = '" . $this->db->escape($data_phone) . "',";
					$sql .= " ip = '" . $this->db->escape($data['ip_opt']) . "',";
					$sql .= " password = '" . $this->db->escape(md5(rand())) . "',";
					$sql .= " date_added = NOW()";
					$this->db->query($sql);

					$customer_id = $this->db->getLastId();
					$country = $this->db->query("SELECT * FROM " . DB_PREFIX . "country WHERE iso_code_2 = '" . $this->db->escape($data_address['country']) . "'");
					$zone = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE (`name` = '" . $this->db->escape($data_address['state']) . "' OR `code` = '" . $this->db->escape($data_address['state']) . "') AND country_id = '" . $this->db->escape($country->row['country_id']) . "'");

					$sql = "INSERT INTO " . DB_PREFIX . "address SET";
					$sql .= " customer_id = '" . (int)$customer_id . "',";
					$sql .= " firstname = '" . $this->db->escape($data_fname) . "',";
					$sql .= " lastname = '" . $this->db->escape($data_lname) . "',";
					$sql .= " address_1 = '" . $this->db->escape($data_address['addr1']) . "',";
					$sql .= " address_2 = '" . $this->db->escape($data_address['addr2']) . "',";
					$sql .= " city = '" . $this->db->escape($data_address['city']) . "',";
					$sql .= " zone_id = '" . (empty($zone) ? 0 : $this->db->escape($zone->row['zone_id'])) . "',";
					$sql .= " postcode = '" . $this->db->escape($data_address['zip']) . "',";
					$sql .= " country_id = '" . (empty($country) ? 0 : $this->db->escape($country->row['country_id'])) . "'";
					$this->db->query($sql);

					$address_id = $this->db->getLastId();
					$this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int)$address_id . "' WHERE customer_id = '" . (int)$customer_id . "'");

					if ($settings['logerrors']) {
						$this->log->write(strtoupper($this->name) . ' CUSTOMER CREATED: ' . $data_fname . ' ' . $data_lname . ' (' . $data['email'] . ')');
					}
					$created++;
				}
			}
			$output .= $created . " customer(s) created in OpenCart\n";
		}

		// OpenCart to MailChimp
		$batch = array();
		foreach ($customers->rows as $customer) {
			if (!$customer['newsletter']) continue;
			$data = array('EMAIL' => $customer['email']);
			if ($settings['fname']) {
				$data[$settings['fname']] = $customer['firstname'];
			}
			if ($settings['lname']) {
				$data[$settings['lname']] = $customer['lastname'];
			}
			if ($settings['address']) {
				$address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = '" . (int)$customer['address_id'] . "'");
				if ($address_query->num_rows) {
					$address = $address_query->row;
					if ($address['country_id']) {
						$this->load->model('localisation/country');
						$country = $this->model_localisation_country->getCountry($address['country_id']);
						$address['iso_code_2'] = $country['iso_code_2'];
					}
					if ($address['zone_id']) {
						$this->load->model('localisation/zone');
						$zone = $this->model_localisation_zone->getZone($address['zone_id']);
						$address['zone'] = html_entity_decode($zone['name'], ENT_QUOTES, 'UTF-8');
					}
					$data[$settings['address']] = array(
						'addr1'		=> $address['address_1'],
						'addr2'		=> $address['address_2'],
						'city'		=> $address['city'],
						'state'		=> (isset($address['zone'])) ? $address['zone'] : '',
						'zip'		=> $address['postcode'],
						'country'	=> (isset($address['iso_code_2'])) ? $address['iso_code_2'] : ''
					);
				}
			}
			if ($settings['phone']) {
				$phone = preg_replace('/[^0-9]/', '', $customer['telephone']);
				$data[$settings['phone']] = substr($phone,0,3).'-'.substr($phone,3,3).'-'.substr($phone,6);
			}
			$batch[] = $data;
		}
		if (!empty($batch)) {
			$curl_data = array(
				'method'			=> 'listBatchSubscribe',
				'apikey'			=> $settings['apikey'],
				'id'				=> $settings['listid'],
				'batch'				=> $batch,
				'double_optin'		=> false,
				'update_existing'	=> true
			);

			$response = $this->curlRequest($curl_data);
			if (!empty($response['error'])) {
				if ($settings['logerrors']) $this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
				return $response['error'];
			}
		} else {
			$response = array(
				'add_count'		=> 0,
				'update_count'	=> 0,
				'error_count'	=> 0
			);
		}

		$output .= $response['add_count'] . " customer(s) added to MailChimp\n";
		$output .= $response['update_count'] . " customer(s) updated in MailChimp\n";
		$output .= $response['error_count'] . " customer(s) failed sending to MailChimp\n\n";
		if (!empty($response['errors'])) {
			$output .= "Error(s):\n";
			foreach ($response['errors'] as $error) {
				$output .= $error['message'] . "\n";
			}
		}
		return $output;
	}

	public function addWebhook($settings) {
		if (empty($settings['status']) || empty($settings['apikey']) || empty($settings['listid']) || empty($settings['urlcode']) || empty($settings['webhooks'])) return;

		$catalog_url = ($this->config->get('config_ssl') || $this->config->get('config_use_ssl')) ? str_replace('http:', 'https:', HTTP_CATALOG) : HTTP_CATALOG;
		$url = $catalog_url . 'index.php?route=' . $this->type . '/' . $this->name . '/webhook&code=' . $settings['urlcode'];

		$curl_data = array(
			'method'	=> 'listWebhooks',
			'apikey'	=> $settings['apikey'],
			'id'		=> $settings['listid']
		);
		$response = $this->curlRequest($curl_data);

		$mc_webhooks = array();
		foreach ($response as $mc_webhook) {
			$mc_webhooks[] = $mc_webhook['url'];
		}

		if (!in_array($url, $mc_webhooks)) {
			$curl_data = array(
				'method'	=> 'listWebhookAdd',
				'apikey'	=> $settings['apikey'],
				'id'		=> $settings['listid'],
				'url'		=> $url,
				'actions'	=> array(
					'subscribe'		=> !empty($settings['webhooks']['subscribe']),
					'unsubscribe'	=> !empty($settings['webhooks']['unsubscribe']),
					'profile'		=> !empty($settings['webhooks']['profile']),
					'upemail'		=> !empty($settings['webhooks']['profile']),
					'cleaned'		=> !empty($settings['webhooks']['cleaned']),
					'campaign'		=> false
				)
			);
			$response = $this->curlRequest($curl_data);
		}
	}

	private function curlRequest($data = array()) {
		$data_center = explode('-', $data['apikey']);
		$url = 'https://' . (isset($data_center[1]) ? $data_center[1] : 'us1') . '.api.mailchimp.com/1.3/?output=json&method=' . $data['method'];

		$curl = curl_init($url);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
		curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data, '', '&'));
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		$response = json_decode(curl_exec($curl), true);

		if (curl_error($curl)) {
			$response = array('code' => 'CURL', 'error' => curl_errno($curl) . ': ' . curl_error($curl));
		} elseif (empty($response)) {
			$response = array('code' => 'CURL', 'error' => 'Empty gateway response');
		} elseif (!empty($response->error)) {
			$response = array('code' => $response->code, 'error' => $response->error);
		}
		curl_close($curl);

		return $response;
	}
}
?>