<?php  
class ControllerModuleReminders extends Controller
{
    public function index()
    {
        $data = array();
		
		$expiring = 0;
		$expired = 0;
    	$followed = 0;
    	$reminded = 0;
    	$delayed = 0;
    	$noticed = 0;

		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();
    	
        $data['order_status_id'] = $this->config->get('expiring_status_to');
        $data['status_from'] = $this->config->get('expiring_status_from');
        $data['change'] = $this->config->get('expiring_change');
        $data['notify'] = $this->config->get('expiring_notify');
        $data['days'] = $this->config->get('expiring_days');
        $data['expire'] = $this->config->get('expired_days');

		foreach ($languages as $language) {
        	$data['comment_'.$language['language_id']] = $this->config->get('expiring_comment_'.$language['language_id']);			
        	$data['subject_'.$language['language_id']] = $this->config->get('expiring_subject_'.$language['language_id']);
        	$data['message_'.$language['language_id']] = $this->config->get('expiring_message_'.$language['language_id']);
        }

        if ($data['days'] && $data['status_from'] && $data['order_status_id']) {
            $this->load->model('module/reminders');
            $orders = $this->model_module_reminders->getExpiringOrders($data);

			if (!empty($orders)) {
            	foreach ($orders as $order) {
                	$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
            	}
            }
            
            $expiring = count($orders);
        }

		$data = array();

        $data['order_status_id'] = $this->config->get('expired_status_to');
        $data['status_from'] = $this->config->get('expired_status_from');
        $data['change'] = '1';
        $data['notify'] = $this->config->get('expired_notify');
        $data['days'] = $this->config->get('expired_days');

		foreach ($languages as $language) {
        	$data['comment_'.$language['language_id']] = $this->config->get('expired_comment_'.$language['language_id']);			
        	$data['subject_'.$language['language_id']] = $this->config->get('expired_subject_'.$language['language_id']);
        	$data['message_'.$language['language_id']] = $this->config->get('expired_message_'.$language['language_id']);
        }

        if ($data['days'] && $data['status_from'] && $data['order_status_id']) {
            $this->load->model('module/reminders');
            $orders = $this->model_module_reminders->getExpiredOrders($data);

			if (!empty($orders)) {
            	foreach ($orders as $order) {
                	$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
            	}
            }
            
            $expired = count($orders);
        }

		$data = array();

        $data['order_status_id'] = $this->config->get('remind_status');
        $data['notify'] = $this->config->get('remind_notify');
        $data['days'] = $this->config->get('remind_days');

		foreach ($languages as $language) {
        	$data['subject_'.$language['language_id']] = $this->config->get('remind_subject_'.$language['language_id']);
        	$data['message_'.$language['language_id']] = $this->config->get('remind_message_'.$language['language_id']);
        }

        if ($data['days'] && $data['order_status_id']) {
            $this->load->model('module/reminders');
            $orders = $this->model_module_reminders->getOrdersToRemind($data);
			
			if (!empty($orders)) {
            	foreach ($orders as $order) {
                	$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
            	}
            }
            
			$reminded = count($orders);
        }

		$data = array();
		
        $data['order_status_id'] = $this->config->get('follow_status');
        $data['notify'] = $this->config->get('follow_notify');
        $data['days'] = $this->config->get('follow_days');

		foreach ($languages as $language) {
        	$data['subject_'.$language['language_id']] = $this->config->get('follow_subject_'.$language['language_id']);
        	$data['message_'.$language['language_id']] = $this->config->get('follow_message_'.$language['language_id']);
        }

        if ($data['days'] && $data['order_status_id']) {
            $this->load->model('module/reminders');
            $orders = $this->model_module_reminders->getOrdersToFollow($data);

			if (!empty($orders)) {
            	foreach ($orders as $order) {
                	$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
            	}
            }
            
            $followed = count($orders);
        }
        
        $data = array(); 
               
        $data['order_status_id'] = $this->config->get('delayed_status_to');
        $data['change'] = $this->config->get('delayed_change');
        $data['notify'] = $this->config->get('delayed_notify');
        $data['days'] = $this->config->get('delayed_days');
        $data['status_from'] = $this->config->get('delayed_status_from');

		foreach ($languages as $language) {
        	$data['comment_'.$language['language_id']] = $this->config->get('delayed_comment_'.$language['language_id']);			
        	$data['subject_'.$language['language_id']] = $this->config->get('delayed_subject_'.$language['language_id']);
        	$data['message_'.$language['language_id']] = $this->config->get('delayed_message_'.$language['language_id']);
        }

        if ($data['days'] && $data['status_from'] && $data['order_status_id']) {
            $this->load->model('module/reminders');
            $orders = $this->model_module_reminders->getDelayedOrders($data);
			
			if (!empty($orders)) {
            	foreach ($orders as $order) {
                	$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
            	}
            }
            
            $delayed = count($orders);
        }        
        
        for ($i = 1; $i <= $this->config->get('reminders_custom'); $i++)
        {
        	$data = array(); 
               
        	$data['order_status_id'] = $this->config->get('notice_status_to_'.$i);
        	$data['recurring'] = $this->config->get('notice_recurring_'.$i);
        	$data['change'] = $this->config->get('notice_change_'.$i);
        	$data['notify'] = $this->config->get('notice_notify_'.$i);
        	$data['days'] = $this->config->get('notice_days_'.$i);
        	$data['status_from'] = $this->config->get('notice_status_from_'.$i);

			foreach ($languages as $language) {
        		$data['comment_'.$language['language_id']] = $this->config->get('notice_comment_'.$i.'_'.$language['language_id']);			
        		$data['subject_'.$language['language_id']] = $this->config->get('notice_subject_'.$i.'_'.$language['language_id']);
        		$data['message_'.$language['language_id']] = $this->config->get('notice_message_'.$i.'_'.$language['language_id']);
        	}

        	if ($data['days'] && $data['status_from'] && $data['order_status_id']) {
            	$this->load->model('module/reminders');
            	$orders = $this->model_module_reminders->getOrdersToNotice($data);
				
				if (!empty($orders)) {
					foreach ($orders as $order) {
                		$this->model_module_reminders->addOrderHistory($order['order_id'], $data);
                	}
            	}
            
            	$noticed = count($orders);
            }
        }        

		echo "Orders expiring: ".$expiring."<br>";
		echo "Orders expired: ".$expired."<br>";
    	echo "Orders followed: ".$followed."<br>";
    	echo "Orders reminded: ".$reminded."<br>";
    	echo "Orders delayed: ".$delayed."<br>";
    	echo "Orders noticed: ".$noticed."<br>";
    	
    	exit;
    }
}
?>
