<?php
//==============================================================================
// MailChimp Integration v154.3
//
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
//==============================================================================

class ModelModuleMailchimpIntegration extends Model {
	private $type = 'module';
	private $name = 'mailchimp_integration';

	public function send($data, $customer_id = 0) {
		$v14x = (!defined('VERSION') || VERSION < 1.5);
		$v150 = (defined('VERSION') && strpos(VERSION, '1.5.0') === 0);
		$settings = ($v14x || $v150) ? unserialize($this->config->get($this->name . '_data')) : $this->config->get($this->name . '_data');

		if (empty($settings['status']) || empty($settings['apikey']) || empty($settings['listid'])) return;

		$current_email = $data['email'] = (isset($data['email'])) ? $data['email'] : $this->customer->getEmail();
		if ($customer_id) {
			$customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
			$current_email = $customer->row['email'];
		}

		if (!empty($data['newsletter'])) {
			$merge_array = array('EMAIL' => $data['email']);
			if ($settings['fname']) {
				$merge_array[$settings['fname']] = (isset($data['firstname'])) ? $data['firstname'] : $this->customer->getFirstName();
			}
			if ($settings['lname']) {
				$merge_array[$settings['lname']] = (isset($data['lastname'])) ? $data['lastname'] : $this->customer->getLastName();
			}
			if ($settings['address']) {
				if (!isset($data['address_1']) || !isset($data['address_2']) || !isset($data['city']) || !isset($data['postcode'])) {
					$this->load->model('account/address');
					$address = $this->model_account_address->getAddress($this->customer->getAddressId());
				}
				if (isset($data['country_id'])) {
					$this->load->model('localisation/country');
					$country = $this->model_localisation_country->getCountry($data['country_id']);
					$data['iso_code_2'] = $country['iso_code_2'];
				}
				if (isset($data['zone_id'])) {
					$this->load->model('localisation/zone');
					$zone = $this->model_localisation_zone->getZone($data['zone_id']);
					$data['zone'] = html_entity_decode($zone['name'], ENT_QUOTES, 'UTF-8');
				}
				$merge_array[$settings['address']] = array(
					'addr1'		=> (isset($data['address_1']))		? $data['address_1']	: $address['address_1'],
					'addr2'		=> (isset($data['address_2']))		? $data['address_2']	: $address['address_2'],
					'city'		=> (isset($data['city']))			? $data['city']			: $address['city'],
					'state'		=> (isset($data['zone']))			? $data['zone']			: $address['zone'],
					'zip'		=> (isset($data['postcode']))		? $data['postcode']		: $address['postcode'],
					'country'	=> (isset($data['iso_code_2']))		? $data['iso_code_2']	: $address['iso_code_2']
				);
			}
			if ($settings['phone']) {
				$phone = preg_replace('/[^0-9]/', '', (isset($data['telephone'])) ? $data['telephone'] : $this->customer->getTelephone());
				$merge_array[$settings['phone']] = substr($phone,0,3).'-'.substr($phone,3,3).'-'.substr($phone,6);
			}

			// Check for required merge tags that are not set
			$curl_data = array(
				'method'	=> 'listMergeVars',
				'apikey'	=> $settings['apikey'],
				'id'		=> $settings['listid']
			);
			$response = $this->curlRequest($curl_data);
			if (!empty($response['error'])) {
				if ($settings['logerrors']) $this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
				return empty($response['error']);
			}
			foreach ($response as $mergetag) {
				if (!$mergetag['req'] || !empty($merge_array[$mergetag['tag']])) {
					continue;
				} elseif ($mergetag['field_type'] == 'zip') {
					$merge_array[$mergetag['tag']] = '00000';
				} else {
					$merge_array[$mergetag['tag']] = '(none)';
				}
			}

			$curl_data = array(
				'method'			=> 'listSubscribe',
				'apikey'			=> $settings['apikey'],
				'id'				=> $settings['listid'],
				'email_address'		=> $current_email,
				'merge_vars'		=> $merge_array,
				'update_existing'	=> true
			);
		} else {
			$curl_data = array(
				'method'			=> 'listUnsubscribe',
				'apikey'			=> $settings['apikey'],
				'id'				=> $settings['listid'],
				'email_address'		=> $current_email
			);
		}

		$response = $this->curlRequest($curl_data);
		if (!empty($response['error']) && $settings['logerrors']) {
			$this->log->write(strtoupper($this->name) . ' ' . $response['code'] . ' ERROR: ' . $response['error']);
		}
		return empty($response['error']);
	}

	private function curlRequest($data = array()) {
		$data_center = explode('-', $data['apikey']);
		$url = 'https://' . (isset($data_center[1]) ? $data_center[1] : 'us1') . '.api.mailchimp.com/1.3/?output=json&method=' . $data['method'];

		$curl = curl_init($url);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
		curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data, '', '&'));
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		$response = json_decode(curl_exec($curl), true);

		if (curl_error($curl)) {
			$response = array('code' => 'CURL', 'error' => curl_errno($curl) . ': ' . curl_error($curl));
		} elseif (empty($response)) {
			$response = array('code' => 'CURL', 'error' => 'Empty gateway response');
		} elseif (!empty($response->error)) {
			$response = array('code' => $response->code, 'error' => $response->error);
		}
		curl_close($curl);

		return $response;
	}
}
?>