<?php echo $header; ?>

<!-- /CONTENT SLOT -->
<div id="account-page" class="content-slot">
	<div class="bt-container">

		<!-- /Notification -->
		<div id="notification"></div>

		<div class="bt-row">

			<!-- /Left Sidebar -->
			<div id="left-sidebar">
				<?php echo $column_left; ?>
			</div>

<!-- /Content -->
<div id="content">

	<?php if ($success) { ?>
	<div class="success"><?php echo $success; ?><i class="icon-cancel-circled close"></div>
<?php } ?>

	<div class="bt-row">
		<!-- /Breadcrumb -->
		<div id="breadcrumb">
			<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
			<?php } ?>
		</div>
	</div>

	<!-- /Page Header -->
	<div id="page-header">
		<div id="page-title">
				<h1><?php echo $heading_title; ?></h1>
			</div>
	</div>

	<?php if ($products) { ?>
		<div >
			<table class="table-list">
				<thead>
					<tr>
						<td class="image"><?php echo $column_image; ?></td>
						<td class="name"><?php echo $column_name; ?></td>
						<td class="model"><?php echo $column_model; ?></td>
						<td class="stock"><?php echo $column_stock; ?></td>
						<td class="price"><?php echo $column_price; ?></td>
						<td class="action"><?php echo $column_action; ?></td>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($products as $product) { ?>

						<tr id="table-row<?php echo $product['product_id']; ?>">
							<td class="image">
								<?php if ($product['thumb']) { ?>
									<a href="<?php echo $product['href']; ?>"><img src="<?php echo $product['thumb']; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" /></a>
								<?php } ?>
							</td>
							<td class="name"><a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?></a></td>
							<td class="model"><?php echo $product['model']; ?></td>
							<td class="stock"><?php echo $product['stock']; ?></td>
							<td class="price">
								<?php if ($product['price']) { ?>
									<span class="price">
										<?php if (!$product['special']) { ?>
											<?php echo $product['price']; ?>
										<?php } else { ?>
											<s><?php echo $product['price']; ?></s> <b><?php echo $product['special']; ?></b>
										<?php } ?>
									</span>
								<?php } ?>
							</td>
							<td class="action">
								<a onclick="addToCart('<?php echo $product['product_id']; ?>');"><i class="icon-bag"></i></a>
								<a href="<?php echo $product['remove']; ?>"><i class="icon-cancel-circled"></i></a></td>
						</tr>

				<?php } ?>
				</tbody>
			</table>
		</div>

		<div class="buttons">
			<a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a>
		</div>
	<?php } else { ?>
		<?php echo $text_empty; ?>
		<div class="buttons">
			<a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a>
		</div>
	<?php } ?>

	<?php echo $content_bottom; ?>

</div><!-- /End #content -->

		</div><!-- /.bt-row -->
	</div><!-- /.bt-container -->
</div><!-- /#content-slot -->

<?php echo $footer; ?>