<?php echo $header; ?>

<!-- /Content -->
<div id="content">

	<!-- /Breadcrumb -->
	<div id="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
			<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
		<?php } ?>
	</div>
	
	<!-- /Page Header -->
	<div id="page-header">
		<h1>
			<?php echo $heading_title; ?>
			<?php if ($weight) { ?>
				&nbsp;(<?php echo $weight; ?>)
			<?php } ?>
		</h1>	
	</div>

<div id="cart-table">
	<div class="bt-row">

		<div class="cart-info">
			<?php if ($attention) { ?>
				<div class="attention"><?php echo $attention; ?></div>
			<?php } ?>
			<?php if ($success) { ?>
				<div class="success"><?php echo $success; ?></div>
			<?php } ?>
			<?php if ($error_warning) { ?>
				<div class="warning"><?php echo $error_warning; ?></div>
			<?php } ?>	

			<form id="basket" action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">	
				<table>
					<thead>
						<tr>
							<td class="image"><?php echo $column_image; ?></td>
							<td class="name"><?php echo $column_name; ?></td>
							<td class="model"><?php echo $column_model; ?></td>
							<td class="quantity"><?php echo $column_quantity; ?></td>
							<td class="price"><?php echo $column_price; ?></td>
							<td class="total"><?php echo $column_total; ?></td>
						</tr>
					</thead>
					<tbody>
						<?php foreach ($products as $product) { ?>
							<tr>
								<td class="image">
									<?php if ($product['thumb']) { ?>
									<a href="<?php echo $product['href']; ?>"><img src="<?php echo $product['thumb']; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" /></a>
									<?php } ?>
								</td>
								<td class="name"><a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?></a>
									<?php if (!$product['stock']) { ?>
										<span class="stock">***</span>
									<?php } ?>
									<div>
										<?php foreach ($product['option'] as $option) { ?>
											<small><i class="icon-ok"></i> <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
										<?php } ?>
									</div>
									<?php if ($product['reward']) { ?>
										<small><i class="icon-certificate"></i> <?php echo $product['reward']; ?></small>
									<?php } ?>
								</td>
								<td class="model"><?php echo $product['model']; ?></td>
								<td class="quantity"><input type="text" name="quantity[<?php echo $product['key']; ?>]" value="<?php echo $product['quantity']; ?>" size="1" />
									&nbsp;
									
									
									<a onclick="$('#basket').submit();"><i class="icon-refresh"></i></a>
									<a href="<?php echo $product['remove']; ?>"><i class="icon-cancel-circled"></i></a></td>
								<td class="price"><?php echo $product['price']; ?></td>
								<td class="total"><?php echo $product['total']; ?></td>
							</tr>
						<?php } ?>
						<?php foreach ($vouchers as $vouchers) { ?>
							<tr>
								<td class="image"></td>
								<td class="name"><?php echo $vouchers['description']; ?></td>
								<td class="model"></td>
								<td class="quantity"><input type="text" name="" value="1" size="1" disabled="disabled" />
									&nbsp;<a href="<?php echo $vouchers['remove']; ?>"><img src="catalog/view/theme/default/image/remove.png" alt="<?php echo $button_remove; ?>" title="<?php echo $button_remove; ?>" /></a></td>
								<td class="price"><?php echo $vouchers['amount']; ?></td>
								<td class="total"><?php echo $vouchers['amount']; ?></td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
			</form>
			
			<div class="bt-row">
				<div id="big-cart-total">
					<table id="total">
						<?php foreach ($totals as $total) { ?>
							<tr>
								<td><b><?php echo $total['title']; ?>:</b></td>
								<td><?php echo $total['text']; ?></td>
							</tr>
						<?php } ?>
					</table>
				</div>
			</div>
			
			<div class="buttons">
				<a href="<?php echo $continue; ?>" class="btn"><?php echo $button_shopping; ?></a> <a href="<?php echo $checkout; ?>" class="btn btn-primary"><?php echo $button_checkout; ?></a>
			</div>
		</div><!-- /End .cart-info -->	
		
		
		<div class="cart-sidebar">
		
			<!-- /Cart Total -->
			<div class="cart-total">
				<table id="total">
					<?php foreach ($totals as $total) { ?>
						<tr>
							<td><b><?php echo $total['title']; ?>:</b></td>
							<td><?php echo $total['text']; ?></td>
						</tr>
					<?php } ?>
				</table>
				
				<div class="total-button">
					<a href="<?php echo $continue; ?>" class="btn "><?php echo $button_shopping; ?></a> <a href="<?php echo $checkout; ?>" class="btn btn-primary"><?php echo $button_checkout; ?></a>
				</div>
			</div>
			
			<?php if ($coupon_status || $voucher_status || $reward_status || $shipping_status) { ?>
				<div class="content">
					<h5><?php echo $text_next; ?></h5>
					<p><?php echo $text_next_choice; ?></p>		
							
					<?php if ($coupon_status) { ?>
						<label for="use_coupon" class="radio">
							<?php if ($next == 'coupon') { ?>
								<input type="radio" name="next" value="coupon" id="use_coupon" checked="checked" />
							<?php } else { ?>
								<input type="radio" name="next" value="coupon" id="use_coupon" />
							<?php } ?>
							<?php echo $text_use_coupon; ?>
						</label>
					<?php } ?>
		
					<?php if ($voucher_status) { ?>
						<label for="use_voucher" class="radio">
							<?php if ($next == 'voucher') { ?>
								<input type="radio" name="next" value="voucher" id="use_voucher" checked="checked" />
							<?php } else { ?>
								<input type="radio" name="next" value="voucher" id="use_voucher" />
							<?php } ?>
							<?php echo $text_use_voucher; ?>
						</label>
					<?php } ?>
					
					<?php if ($reward_status) { ?>
						<label for="use_reward" class="radio">
							<?php if ($next == 'reward') { ?>
								<input type="radio" name="next" value="reward" id="use_reward" checked="checked" />
							<?php } else { ?>
								<input type="radio" name="next" value="reward" id="use_reward" />
							<?php } ?>
							<?php echo $text_use_reward; ?>
						</label>
					<?php } ?>
					
					<?php if ($shipping_status) { ?>
						<label for="shipping_estimate" class="radio">
							<?php if ($next == 'shipping') { ?>
								<input type="radio" name="next" value="shipping" id="shipping_estimate" checked="checked" />
							<?php } else { ?>
								<input type="radio" name="next" value="shipping" id="shipping_estimate" />
							<?php } ?>
							<?php echo $text_shipping_estimate; ?>
						</label>		
					<?php } ?>				
				</div>
			
				<div class="cart-module">
					
					<div id="coupon" class="content" style="display: <?php echo ($next == 'coupon' ? 'block' : 'none'); ?>;">
						<h5><i class="icon-cut"></i> Coupon Code</h5>
						<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">
							<?php echo $entry_coupon; ?>&nbsp;
							<div class="input-append">
								<input class="span5" type="text" name="coupon" value="<?php echo $coupon; ?>" />
								<input type="hidden" name="next" value="coupon" />
								&nbsp;
								<input type="submit" value="<?php echo $button_coupon; ?>" class="btn btn-warning" />
							</div>
						</form>
					</div>
					
					<div id="voucher" class="content" style="display: <?php echo ($next == 'voucher' ? 'block' : 'none'); ?>;">
						<h5><i class="icon-gift"></i> Gift Voucher</h5>
						<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">
							<?php echo $entry_voucher; ?>&nbsp;
							
							<div class="input-append">
								<input class="span5" type="text" name="voucher" value="<?php echo $voucher; ?>" />
								<input type="hidden" name="next" value="voucher" />
							&nbsp;
								<input type="submit" value="<?php echo $button_voucher; ?>" class="btn btn-warning" />
							</div>
						</form>
						</div>
						
					<div id="reward" class="content" style="display: <?php echo ($next == 'reward' ? 'block' : 'none'); ?>;">
						<h5><i class="icon-certificate"></i> Point Reward</h5>
						<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">
							<?php echo $entry_reward; ?>&nbsp;
							<input type="text" name="reward" value="<?php echo $reward; ?>" />
							<input type="hidden" name="next" value="reward" />
							&nbsp;
							<input type="submit" value="<?php echo $button_reward; ?>" class="btn btn-warning" />
						</form>
					</div>
					
					<div id="shipping" class="content" style="display: <?php echo ($next == 'shipping' ? 'block' : 'none'); ?>;">
						<h5><i class="icon-truck"></i> Shipping & Taxes Estimator</h5>
						<p><?php echo $text_shipping_detail; ?></p>
						
						<span class="required">*</span> <?php echo $entry_country; ?><br />
						<select name="country_id">
							<option value=""><?php echo $text_select; ?></option>
							<?php foreach ($countries as $country) { ?>
								<?php if ($country['country_id'] == $country_id) { ?>
									<option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
								<?php } else { ?>
									<option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
								<?php } ?>
							<?php } ?>
						</select><br />
						
						<span class="required">*</span> <?php echo $entry_zone; ?><br />
						<select name="zone_id"></select><br />
						
						<span id="postcode-required" class="required">*</span> <?php echo $entry_postcode; ?><br />
						<input class="span2" type="text" name="postcode" value="<?php echo $postcode; ?>" /><br />
						
						<input type="button" value="<?php echo $button_quote; ?>" id="button-quote" class="btn btn-warning" />
						
					</div>
				</div>
			<?php } ?>					
			
		</div><!-- /End .cart-sidebar -->
	
	
	</div><!-- /End .bt-row -->
	
	

	<?php echo $content_bottom; ?>
	
</div><!-- /End #cart-table -->
	
</div><!-- /End #content -->

<!-- /Side Bar -->
<div id="side-bar">
	<?php echo $column_right; ?>	
</div>



<script type="text/javascript"><!--
$('input[name=\'next\']').bind('change', function() {
	$('.cart-module > div').hide();
	
	$('#' + this.value).show();
});
//--></script>
<?php if ($shipping_status) { ?>
<script type="text/javascript"><!--
$('#button-quote').live('click', function() {
	$.ajax({
		url: 'index.php?route=checkout/cart/quote',
		type: 'post',
		data: 'country_id=' + $('select[name=\'country_id\']').val() + '&zone_id=' + $('select[name=\'zone_id\']').val() + '&postcode=' + encodeURIComponent($('input[name=\'postcode\']').val()),
		dataType: 'json',		
		beforeSend: function() {
			$('#button-quote').attr('disabled', true);
			$('#button-quote').after('<span class="wait">&nbsp;<img src="catalog/view/theme/default/image/loading.gif" alt="" /></span>');
		},
		complete: function() {
			$('#button-quote').attr('disabled', false);
			$('.wait').remove();
		},		
		success: function(json) {
			$('.success, .warning, .attention, .error').remove();			
						
			if (json['error']) {
				if (json['error']['warning']) {
					$('#notification').html('<div class="warning" style="display: none;">' + json['error']['warning'] + '<i class="icon-cancel-circled close"></div>');
					
					$('.warning').fadeIn('slow');
					
					$('html, body').animate({ scrollTop: 0 }, 'slow'); 
				}	
							
				if (json['error']['country']) {
					$('select[name=\'country_id\']').after('<span class="error">' + json['error']['country'] + '</span>');
				}	
				
				if (json['error']['zone']) {
					$('select[name=\'zone_id\']').after('<span class="error">' + json['error']['zone'] + '</span>');
				}
				
				if (json['error']['postcode']) {
					$('input[name=\'postcode\']').after('<span class="error">' + json['error']['postcode'] + '</span>');
				}					
			}
			
			if (json['shipping_method']) {
				html  = '<h2><?php echo $text_shipping_method; ?></h2>';
				html += '<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data">';
				html += '  <table class="radio">';
				
				for (i in json['shipping_method']) {
					html += '<tr>';
					html += '  <td colspan="3"><b>' + json['shipping_method'][i]['title'] + '</b></td>';
					html += '</tr>';
				
					if (!json['shipping_method'][i]['error']) {
						for (j in json['shipping_method'][i]['quote']) {
							html += '<tr class="highlight">';
							
							if (json['shipping_method'][i]['quote'][j]['code'] == '<?php echo $shipping_method; ?>') {
								html += '<td><input type="radio" name="shipping_method" value="' + json['shipping_method'][i]['quote'][j]['code'] + '" id="' + json['shipping_method'][i]['quote'][j]['code'] + '" checked="checked" /></td>';
							} else {
								html += '<td><input type="radio" name="shipping_method" value="' + json['shipping_method'][i]['quote'][j]['code'] + '" id="' + json['shipping_method'][i]['quote'][j]['code'] + '" /></td>';
							}
								
							html += '  <td><label for="' + json['shipping_method'][i]['quote'][j]['code'] + '">' + json['shipping_method'][i]['quote'][j]['title'] + '</label></td>';
							html += '  <td style="text-align: right;"><label for="' + json['shipping_method'][i]['quote'][j]['code'] + '">' + json['shipping_method'][i]['quote'][j]['text'] + '</label></td>';
							html += '</tr>';
						}		
					} else {
						html += '<tr>';
						html += '  <td colspan="3"><div class="error">' + json['shipping_method'][i]['error'] + '</div></td>';
						html += '</tr>';						
					}
				}
				
				html += '  </table>';
				html += '  <br />';
				html += '  <input type="hidden" name="next" value="shipping" />';
				
				<?php if ($shipping_method) { ?>
				html += '  <input type="submit" value="<?php echo $button_shipping; ?>" id="button-shipping" class="button" />';	
				<?php } else { ?>
				html += '  <input type="submit" value="<?php echo $button_shipping; ?>" id="button-shipping" class="button" disabled="disabled" />';	
				<?php } ?>
							
				html += '</form>';
				
				$.colorbox({
					overlayClose: true,
					opacity: 0.5,
					width: '600px',
					height: '400px',
					href: false,
					html: html
				});
				
				$('input[name=\'shipping_method\']').bind('change', function() {
					$('#button-shipping').attr('disabled', false);
				});
			}
		}
	});
});
//--></script> 
<script type="text/javascript"><!--
$('select[name=\'country_id\']').bind('change', function() {
	$.ajax({
		url: 'index.php?route=checkout/cart/country&country_id=' + this.value,
		dataType: 'json',
		beforeSend: function() {
			$('select[name=\'country_id\']').after('<span class="wait">&nbsp;<img src="catalog/view/theme/default/image/loading.gif" alt="" /></span>');
		},
		complete: function() {
			$('.wait').remove();
		},			
		success: function(json) {
			if (json['postcode_required'] == '1') {
				$('#postcode-required').show();
			} else {
				$('#postcode-required').hide();
			}
			
			html = '<option value=""><?php echo $text_select; ?></option>';
			
			if (json['zone'] != '') {
				for (i = 0; i < json['zone'].length; i++) {
        			html += '<option value="' + json['zone'][i]['zone_id'] + '"';
	    			
					if (json['zone'][i]['zone_id'] == '<?php echo $zone_id; ?>') {
	      				html += ' selected="selected"';
	    			}
	
	    			html += '>' + json['zone'][i]['name'] + '</option>';
				}
			} else {
				html += '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
			}
			
			$('select[name=\'zone_id\']').html(html);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('select[name=\'country_id\']').trigger('change');
//--></script>
<?php } ?>
<?php echo $footer; ?>