<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, user-scalable=no">
<base href="<?php echo $base; ?>" />
<title><?php echo $title; ?></title>

<?php if ($description) { ?><meta name="description" content="<?php echo $description; ?>" /><?php } ?>
<?php if ($keywords) { ?><meta name="keywords" content="<?php echo $keywords; ?>" /><?php } ?>

<meta property="og:title" content="<?php echo $title; ?>" />

<meta property="og:type" content="website" />
<meta property="fb:admins" content="100006533707003"/>
<?php if ($og_descr) { ?>
<meta property="og:description" content="<?php echo $og_descr; ?>" />
<?php } else { ?>
<meta property="og:description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($og_image) { ?>
<meta property="og:image" content="<?php echo $og_image; ?>" />
<?php } else { ?>
<meta property="og:image" content="<?php echo $logo; ?>" />
<?php } ?>

<?php 
$pageURL = "http" . ((!empty($_SERVER['HTTPS'])) ? "s" : "") . "://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];

;?>
<meta property="og:url" content="<?php echo $pageURL; ?>" />

<?php if ($icon) { ?><link rel="shortcut icon" type="image/png" href="<?php echo $icon; ?>" /><?php } ?>
<?php foreach ($links as $link) { ?><link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" /><?php } ?>

<link rel="stylesheet" type="text/css" media="all" href="<?php echo $base; ?>catalog/view/theme/heavy/stylesheet/stylesheet.css" />


<link href='http://fonts.googleapis.com/css?family=Source+Sans+Pro:400,600,700|Raleway:300,600' rel='stylesheet' type='text/css'>



<link href="https://plus.google.com/<?php echo html_entity_decode($this->config->get('config_googleplus'), ENT_QUOTES, 'UTF-8') ;?>" rel="author" />

<script type="text/javascript" src="catalog/view/theme/heavy/js/common.bt.js"></script>

<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>

<style>
	body {
		background-image: url("<?php echo $themes_bg_img ;?>"); 
		background-position: <?php echo $themes_bg_position_x ;?> <?php echo $themes_bg_position_y ;?>;
		background-repeat: <?php echo $themes_bg_repeat ;?>;
		background-color: <?php echo $themes_bg_color ;?>;
	}
	<?php if ($themes_content_bg_color == 1) { ?>
		.content-slot .bt-container,
		#frontpage-slideshow .bt-container {
			background-color: white;
		}
		#footer-slot {
			background-color: transparent;
			border-top: none;
			margin-top: 30px;
		}
		.content-slot .bt-container {
			-webkit-border-radius: 5px 5px 5px 5px;
			-moz-border-radius: 5px 5px 5px 5px;
			-khtml-border-radius: 5px 5px 5px 5px;
			border-radius: 5px 5px 5px 5px;
			box-shadow: 0 0 6px rgba(0,0,0,.25);
		}
		#home.content-slot>.bt-container {
			margin-top: 15px;
		}
		#frontpage-slideshow .bt-container {
			padding: 15px;
			-webkit-border-radius: 5px 5px 5px 5px;
			-moz-border-radius: 5px 5px 5px 5px;
			-khtml-border-radius: 5px 5px 5px 5px;
			border-radius: 5px 5px 5px 5px;
			box-shadow: 0 0 6px rgba(0,0,0,.25);
		}
		#top-nav {
			margin-bottom: 15px;
		}
		#top-nav .bt-container {
			background-image: linear-gradient(to bottom, #e12022, #bf1a1b);
			-webkit-border-radius: 5px 5px 5px 5px;
			-moz-border-radius: 5px px 5px 5px;
			-khtml-border-radius: 5px px 5px 5px;
			border-radius: 5px px 5px 5px;
		}
	<?php } ?>
	<?php echo $this->config->get('config_override_css'); ;?>
</style>

	</head>
<body class="<?php echo $body_class; ?>">
<?php echo $google_analytics; ?>

<div id="mobile-header-slot">
	<div class="bt-container">
		<div id="mobile-store-logo">
			
			<?php if($logo_mobile) {;?>
				<a href="<?php echo $home; ?>"><img src="<?php echo $logo_mobile; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a>
			<?php } else { ;?>
				<a href=""><?php echo $name; ?></a>
			<?php } ;?>
		</div>		
		<div id="mobile-search-box">
			<i class="icon-search"></i>
		</div>
		<div id="mobile-shopping-cart">
			<i class="icon-basket"></i>
		</div>
		<div id="mobile-main-menu">
			<i class="icon-menu"></i>
		</div>
	</div>
</div>

<div id="header-slot">
	<div class="top">
		<div class="bt-container">
			<div class="bt-row">
				<div class="left">
					<div id="contact">
						
						<ul><?php if($phone){ ;?>
								<li><i class="icon-phone"></i> <?php echo $phone ;?></li> 
							<?php } ;?>
							<?php if($blackberry){ ;?>
								<li><strong>BB</strong> <?php echo $blackberry ;?></li> 
							<?php } ;?>
							<li><i class="icon-mail"></i> <?php echo $email ;?></li>
						</ul>
					</div>
				</div>
				<div class="right">
					<div id="shopping-cart">
						<span><i class="icon-basket"></i> <?php echo $text_cart ;?></span>
						<div class="inner">
							<?php echo $cart; ?><a id="iphone-checkout" href="<?php echo $checkout; ?>">View Cart</a>
						</div>
					</div>
					<div id="sub-menu">
						<ul>
							<li class="logged-user">
								<?php if (!$logged) { ?>
									<?php echo $text_welcome; ?>
								<?php } else { ?>
									<?php echo $text_logged; ?>
								<?php } ?>
							</li>
							<?php if ($logged) { ?>
								<li><a href="<?php echo $account; ?>"><?php echo $text_account; ?></a></li>
							<?php } ?>
							<li>
								<a href="<?php echo $checkout; ?>"><?php echo $text_checkout; ?></a>
							</li>
						</ul>
					</div>
					<?php if ($currency) { ?>
						<div id="currency">
							<?php echo $currency; ?>
						</div>
					<?php } ?>
					<?php if ($language) { ?>
						<div id="language">
							<?php echo $language; ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="bt-container">
		
		<div class="middle">
			<div class="bt-row">
				<div id="store-logo">
					<?php list($width, $height) = getimagesize($logo); ;?>
					<a href="<?php echo $home; ?>"><img height="<?php echo $height ;?>" width="<?php echo $width ;?>" src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a>
				</div>
				<div id="search-box">
					<div class="input-append">
						<?php if ($filter_name) { ?>
							<input id="appendedInputButton" size="106" type="text" name="filter_name" value="<?php echo $filter_name; ?>" />
						<?php } else { ?>
							<input id="appendedInputButton" size="10" type="text" name="filter_name" value="<?php echo $text_search; ?>" onclick="this.value = '';" onkeydown="this.style.color = '#000000';" />
						<?php } ?><a class="button-search add-on"><img src="/catalog/view/theme/heavy/image/icon-search.png" alt="icon-search" width="11" height="11" /></a>
					</div>
				</div>
			</div>
		</div>
		
	</div>
	
</div>
<div id="top-nav">
	<div class="bt-container">
		<div id="main-menu">
			<ul>
				<?php if($config_display_home == 1) {;?>
					<li><a href="<?php echo $home; ?>"><span><?php echo $text_home; ?></span></a></li>
				<?php } ;?>
				<?php if($config_display_new_arrivals == 1) {;?>
				<li><a href="<?php echo $new_arrivals; ?>"><span><?php echo $text_new_arrivals; ?></span></a></li>
				<?php } ;?>
				<?php if($config_display_brand == 1) {;?>
					<li><a href="<?php echo $manufacturer; ?>"><?php echo $text_manufacturer; ?></a></li>
				<?php } ;?>
				<?php foreach ($categories as $category) { ?>
		
					<?php if ($category['category_id']==$category_id) { ?>
						<li class="active"><a href="<?php echo $category['href']; ?>"><span><?php echo $category['name']; ?></span></a>
					<?php } else { ?>
						<li><a href="<?php echo $category['href']; ?>"><span><?php echo $category['name']; ?></span></a>
					<?php } ?>
		
						<?php if ($category['children']) { ?>
							<div class="sub-menu">
								<?php if (($category['column'])==1) { ?>
									<div class="no-column">
										<?php for ($i = 0; $i < count($category['children']);) { ?>
											<ul>
												<?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
												<?php for (; $i < $j; $i++) { ?>
													<?php if (isset($category['children'][$i])) { ?>
														<li><a href="<?php echo $category['children'][$i]['href']; ?>"><span><?php echo $category['children'][$i]['name']; ?></span></a></li>
													<?php } ?>
												<?php } ?>
											</ul>
										<?php } ?>
									</div>
								<?php } else { ?>
		
									<?php
										$width = $category['column'] * 120;
										$left = ($category['column'] * 60);
									?>
									<div class="column">
										<ul style="width:<?php echo $width ;?>px">
									<?php for ($i = 0; $i < count($category['children']);) { ?>
										<li>
											<?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
											<ol>
											<?php for (; $i < $j; $i++) { ?>
		
												<?php if (isset($category['children'][$i])) { ?>
													<li><a href="<?php echo $category['children'][$i]['href']; ?>"><span><?php echo $category['children'][$i]['name']; ?></span></a></li>
												<?php } ?>
		
											<?php } ?>
											</ol>
										</li>
									<?php } ?>
										</ul>
									</div>
								<?php } ?>
							</div>
		
						<?php } ?>
					</li>
				<?php } ?>
				<?php if($specials){?><li id="sale"><a href="<?php echo $sale; ?>"><span><?php echo $text_sale; ?></span></a></li><?php } ?>
				
			</ul>
		</div>
	</div>
</div>