<?php

class ControllerModuleReminders extends Controller
{
    private $error = array(); 
	 
    public function index()
    {   
        $this->language->load('module/reminders');

        $this->document->setTitle($this->language->get('heading_title'));
		
        $this->load->model('setting/setting');
				
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate())
        {
            $this->model_setting_setting->editSetting('reminders', $this->request->post);		
			
			if($this->request->post['reminders_apply'])
			{
				$this->redirect($this->url->link('module/reminders', 'success=1&token='.$this->session->data['token'], 'SSL'));
			}
			else
			{
				$this->redirect($this->url->link('extension/module', 'token='.$this->session->data['token'], 'SSL'));
			}
        }
		
		if(!empty($this->request->get['success']))
		{
			$this->data['success'] = $this->language->get('text_success');
		}
		else
		{
			$this->data['success'] = '';				
        	$this->data['token'] = $this->session->data['token'];
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_common_title'] = $this->language->get('text_common_title');
		$this->data['text_add_signature'] = $this->language->get('text_add_signature');
		$this->data['text_sender'] = $this->language->get('text_sender');
		$this->data['text_signature'] = $this->language->get('text_signature');

        $this->data['text_expiring_title'] = $this->language->get('text_expiring_title');
        $this->data['text_expiring_days'] = $this->language->get('text_expiring_days');
        $this->data['text_expiring_status_to'] = $this->language->get('text_expiring_status_to');
        $this->data['text_expiring_status_from'] = $this->language->get('text_expiring_status_from');
        $this->data['text_expiring_comment'] = $this->language->get('text_expiring_comment');
        $this->data['text_expiring_change'] = $this->language->get('text_expiring_change');
        $this->data['text_expiring_notify'] = $this->language->get('text_expiring_notify');
        $this->data['text_expiring_subject'] = $this->language->get('text_expiring_subject');
        $this->data['text_expiring_message'] = $this->language->get('text_expiring_message');
        
        $this->data['text_expired_title'] = $this->language->get('text_expired_title');
        $this->data['text_expired_days'] = $this->language->get('text_expired_days');
        $this->data['text_expired_status_to'] = $this->language->get('text_expired_status_to');
        $this->data['text_expired_status_from'] = $this->language->get('text_expired_status_from');
        $this->data['text_expired_comment'] = $this->language->get('text_expired_comment');
        $this->data['text_expired_notify'] = $this->language->get('text_expired_notify');
        $this->data['text_expired_subject'] = $this->language->get('text_expired_subject');
		$this->data['text_expired_message'] = $this->language->get('text_expired_message');
		
        $this->data['text_remind_title'] = $this->language->get('text_remind_title');
        $this->data['text_remind_days'] = $this->language->get('text_remind_days');
        $this->data['text_remind_status'] = $this->language->get('text_remind_status');
        $this->data['text_remind_notify'] = $this->language->get('text_remind_notify');
        $this->data['text_remind_subject'] = $this->language->get('text_remind_subject');
		$this->data['text_remind_message'] = $this->language->get('text_remind_message');
		
        $this->data['text_follow_title'] = $this->language->get('text_follow_title');
        $this->data['text_follow_days'] = $this->language->get('text_follow_days');
        $this->data['text_follow_status'] = $this->language->get('text_follow_status');
        $this->data['text_follow_comment'] = $this->language->get('text_follow_comment');
        $this->data['text_follow_notify'] = $this->language->get('text_follow_notify');
        $this->data['text_follow_subject'] = $this->language->get('text_follow_subject');
        $this->data['text_follow_message'] = $this->language->get('text_follow_message');

        $this->data['text_delayed_title'] = $this->language->get('text_delayed_title');
        $this->data['text_delayed_days'] = $this->language->get('text_delayed_days');
        $this->data['text_delayed_status_to'] = $this->language->get('text_delayed_status_to');
        $this->data['text_delayed_status_from'] = $this->language->get('text_delayed_status_from');
        $this->data['text_delayed_comment'] = $this->language->get('text_delayed_comment');
        $this->data['text_delayed_change'] = $this->language->get('text_delayed_change');
        $this->data['text_delayed_notify'] = $this->language->get('text_delayed_notify');
        $this->data['text_delayed_subject'] = $this->language->get('text_delayed_subject');
        $this->data['text_delayed_message'] = $this->language->get('text_delayed_message');

        $this->data['text_notice_title'] = $this->language->get('text_notice_title');
        $this->data['text_notice_days'] = $this->language->get('text_notice_days');
        $this->data['text_notice_status_to'] = $this->language->get('text_notice_status_to');
        $this->data['text_notice_status_from'] = $this->language->get('text_notice_status_from');
        $this->data['text_notice_comment'] = $this->language->get('text_notice_comment');
        $this->data['text_notice_recurring'] = $this->language->get('text_notice_recurring');
        $this->data['text_notice_change'] = $this->language->get('text_notice_change');
        $this->data['text_notice_notify'] = $this->language->get('text_notice_notify');
        $this->data['text_notice_subject'] = $this->language->get('text_notice_subject');
        $this->data['text_notice_message'] = $this->language->get('text_notice_message');
        
        $this->data['text_choose_status'] = $this->language->get('text_choose_status');
        
        $this->data['button_save'] = $this->language->get('button_save');
        $this->data['button_apply'] = $this->language->get('button_apply');
        $this->data['button_cancel'] = $this->language->get('button_cancel');
        $this->data['button_add'] = $this->language->get('button_add');

        $this->data['action'] = $this->url->link('module/reminders', 'token='.$this->session->data['token'], 'SSL');
        $this->data['cancel'] = $this->url->link('extension/module', 'token='.$this->session->data['token'], 'SSL');

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href'      => $this->url->link('common/home', 'token='.$this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_module'),
            'href'      => $this->url->link('extension/module', 'token='.$this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('module/reminders', 'token='.$this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();

		$this->data['languages'] = $languages;

        if (isset($this->request->post['reminders_add_signature'])) {
            $this->data['reminders_add_signature'] = $this->request->post['reminders_add_signature'];
        } elseif ($this->config->get('reminders_add_signature')) {
            $this->data['reminders_add_signature'] = $this->config->get('reminders_add_signature');
        } else {
            $this->data['reminders_add_signature'] = 0;
        }

		foreach ($languages as $language) {
	        if (isset($this->request->post['reminders_sender_'.$language['language_id']])) {
    	        $this->data['reminders_sender_'.$language['language_id']] = $this->request->post['reminders_sender_'.$language['language_id']];
        	} elseif ($this->config->get('reminders_sender_'.$language['language_id'])) {
	            $this->data['reminders_sender_'.$language['language_id']] = $this->config->get('reminders_sender_'.$language['language_id']);
    	    } else {
        	    $this->data['reminders_sender_'.$language['language_id']] = '';
	        }

	        if (isset($this->request->post['reminders_signature_'.$language['language_id']])) {
    	        $this->data['reminders_signature_'.$language['language_id']] = $this->request->post['reminders_signature_'.$language['language_id']];
        	} elseif ($this->config->get('reminders_signature_'.$language['language_id'])) {
	            $this->data['reminders_signature_'.$language['language_id']] = $this->config->get('reminders_signature_'.$language['language_id']);
    	    } else {
        	    $this->data['reminders_signature_'.$language['language_id']] = '';
	        }	        
	    }	

        if (isset($this->request->post['expiring_days'])) {
            $this->data['expiring_days'] = $this->request->post['expiring_days'];
        } elseif ($this->config->get('expiring_days')) { 
            $this->data['expiring_days'] = $this->config->get('expiring_days');
        } else {
            $this->data['expiring_days'] = 0;
        }

        if (isset($this->request->post['expiring_status_from'])) {
            $this->data['expiring_status_from'] = $this->request->post['expiring_status_from'];
        } elseif ($this->config->get('expiring_status_from')) {
            $this->data['expiring_status_from'] = $this->config->get('expiring_status_from');
        } else {
            $this->data['expiring_status_from'] = 0;
        }

        if (isset($this->request->post['expiring_status_to'])) {
            $this->data['expiring_status_to'] = $this->request->post['expiring_status_to'];
        } elseif ($this->config->get('expiring_status_to')) {
            $this->data['expiring_status_to'] = $this->config->get('expiring_status_to');
        } else {
            $this->data['expiring_status_to'] = 0;
        }

        if (isset($this->request->post['expiring_change'])) {
            $this->data['expiring_change'] = $this->request->post['expiring_change'];
        } elseif ($this->config->get('expiring_change')) {
            $this->data['expiring_change'] = $this->config->get('expiring_change');
        } else {
            $this->data['expiring_change'] = 0;
        }

        if (isset($this->request->post['expiring_notify'])) {
            $this->data['expiring_notify'] = $this->request->post['expiring_notify'];
        } elseif ($this->config->get('expiring_notify')) {
            $this->data['expiring_notify'] = $this->config->get('expiring_notify');
        } else {
            $this->data['expiring_notify'] = 0;
        }

		foreach ($languages as $language) {
	        if (isset($this->request->post['expiring_comment_'.$language['language_id']])) {
    	        $this->data['expiring_comment_'.$language['language_id']] = $this->request->post['expiring_comment_'.$language['language_id']];
        	} elseif ($this->config->get('expiring_comment_'.$language['language_id'])) {
	            $this->data['expiring_comment_'.$language['language_id']] = $this->config->get('expiring_comment_'.$language['language_id']);
    	    } else {
        	    $this->data['expiring_comment_'.$language['language_id']] = '';
	        }			
	
	        if (isset($this->request->post['expiring_subject_'.$language['language_id']])) {
    	        $this->data['expiring_subject_'.$language['language_id']] = $this->request->post['expiring_subject_'.$language['language_id']];
	        } elseif ($this->config->get('expiring_subject_'.$language['language_id'])) {
    	        $this->data['expiring_subject_'.$language['language_id']] = $this->config->get('expiring_subject_'.$language['language_id']);
        	} else {
	            $this->data['expiring_subject_'.$language['language_id']] = '';
    	    }

	        if (isset($this->request->post['expiring_message_'.$language['language_id']])) {
    	        $this->data['expiring_message_'.$language['language_id']] = $this->request->post['expiring_message_'.$language['language_id']];
	        } elseif ($this->config->get('expiring_message_'.$language['language_id'])) {
    	        $this->data['expiring_message_'.$language['language_id']] = $this->config->get('expiring_message_'.$language['language_id']);
        	} else {
	            $this->data['expiring_message_'.$language['language_id']] = '';
    	    }    	    
		}
		
        if (isset($this->request->post['expired_days'])) {
            $this->data['expired_days'] = $this->request->post['expired_days'];
        } elseif ($this->config->get('expired_days')) { 
            $this->data['expired_days'] = $this->config->get('expired_days');
        } else {
            $this->data['expired_days'] = 0;
        }

        if (isset($this->request->post['expired_status_from'])) {
            $this->data['expired_status_from'] = $this->request->post['expired_status_from'];
        } elseif ($this->config->get('expired_status_from')) {
            $this->data['expired_status_from'] = $this->config->get('expired_status_from');
        } else {
            $this->data['expired_status_from'] = 0;
        }

        if (isset($this->request->post['expired_status_to'])) {
            $this->data['expired_status_to'] = $this->request->post['expired_status_to'];
        } elseif ($this->config->get('expired_status_to')) {
            $this->data['expired_status_to'] = $this->config->get('expired_status_to');
        } else {
            $this->data['expired_status_to'] = 0;
        }

        if (isset($this->request->post['expired_notify'])) {
            $this->data['expired_notify'] = $this->request->post['expired_notify'];
        } elseif ($this->config->get('expired_notify')) {
            $this->data['expired_notify'] = $this->config->get('expired_notify');
        } else {
            $this->data['expired_notify'] = 0;
        }

		foreach ($languages as $language) {
	        if (isset($this->request->post['expired_comment_'.$language['language_id']])) {
    	        $this->data['expired_comment_'.$language['language_id']] = $this->request->post['expired_comment_'.$language['language_id']];
        	} elseif ($this->config->get('expired_comment_'.$language['language_id'])) {
	            $this->data['expired_comment_'.$language['language_id']] = $this->config->get('expired_comment_'.$language['language_id']);
    	    } else {
        	    $this->data['expired_comment_'.$language['language_id']] = '';
	        }			
	
	        if (isset($this->request->post['expired_subject_'.$language['language_id']])) {
    	        $this->data['expired_subject_'.$language['language_id']] = $this->request->post['expired_subject_'.$language['language_id']];
	        } elseif ($this->config->get('expired_subject_'.$language['language_id'])) {
    	        $this->data['expired_subject_'.$language['language_id']] = $this->config->get('expired_subject_'.$language['language_id']);
        	} else {
	            $this->data['expired_subject_'.$language['language_id']] = '';
    	    }

	        if (isset($this->request->post['expired_message_'.$language['language_id']])) {
    	        $this->data['expired_message_'.$language['language_id']] = $this->request->post['expired_message_'.$language['language_id']];
	        } elseif ($this->config->get('expired_message_'.$language['language_id'])) {
    	        $this->data['expired_message_'.$language['language_id']] = $this->config->get('expired_message_'.$language['language_id']);
        	} else {
	            $this->data['expired_message_'.$language['language_id']] = '';
    	    }    	    
		}       
        
        if (isset($this->request->post['remind_days'])) {
            $this->data['remind_days'] = $this->request->post['remind_days'];
        } elseif ($this->config->get('remind_days')) { 
            $this->data['remind_days'] = $this->config->get('remind_days');
        } else {
            $this->data['remind_days'] = 0;
        }

        if (isset($this->request->post['remind_status'])) {
            $this->data['remind_status'] = $this->request->post['remind_status'];
        } elseif ($this->config->get('remind_status')) {
            $this->data['remind_status'] = $this->config->get('remind_status');
        } else {
            $this->data['remind_status'] = 0;
        }

        if (isset($this->request->post['remind_notify'])) {
            $this->data['remind_notify'] = $this->request->post['remind_notify'];
        } elseif ($this->config->get('remind_notify')) {
            $this->data['remind_notify'] = $this->config->get('remind_notify');
        } else {
            $this->data['remind_notify'] = 0;
        }
        
		foreach ($languages as $language) {
	        if (isset($this->request->post['remind_comment_'.$language['language_id']])) {
    	        $this->data['remind_comment_'.$language['language_id']] = $this->request->post['remind_comment_'.$language['language_id']];
        	} elseif ($this->config->get('remind_comment_'.$language['language_id'])) {
	            $this->data['remind_comment_'.$language['language_id']] = $this->config->get('remind_comment_'.$language['language_id']);
    	    } else {
        	    $this->data['remind_comment_'.$language['language_id']] = '';
	        }			
	
	        if (isset($this->request->post['remind_subject_'.$language['language_id']])) {
    	        $this->data['remind_subject_'.$language['language_id']] = $this->request->post['remind_subject_'.$language['language_id']];
	        } elseif ($this->config->get('remind_subject_'.$language['language_id'])) {
    	        $this->data['remind_subject_'.$language['language_id']] = $this->config->get('remind_subject_'.$language['language_id']);
        	} else {
	            $this->data['remind_subject_'.$language['language_id']] = '';
    	    }

	        if (isset($this->request->post['remind_message_'.$language['language_id']])) {
    	        $this->data['remind_message_'.$language['language_id']] = $this->request->post['remind_message_'.$language['language_id']];
	        } elseif ($this->config->get('remind_message_'.$language['language_id'])) {
    	        $this->data['remind_message_'.$language['language_id']] = $this->config->get('remind_message_'.$language['language_id']);
        	} else {
	            $this->data['remind_message_'.$language['language_id']] = '';
    	    }    	    
		}  
       
        if (isset($this->request->post['follow_days'])) {
            $this->data['follow_days'] = $this->request->post['follow_days'];
        } elseif ($this->config->get('follow_days')) { 
            $this->data['follow_days'] = $this->config->get('follow_days');
        } else {
            $this->data['follow_days'] = 0;
        }

        if (isset($this->request->post['follow_status'])) {
            $this->data['follow_status'] = $this->request->post['follow_status'];
        } elseif ($this->config->get('follow_status')) {
            $this->data['follow_status'] = $this->config->get('follow_status');
        } else {
            $this->data['follow_status'] = 0;
        }
        
        if (isset($this->request->post['follow_notify'])) {
            $this->data['follow_notify'] = $this->request->post['follow_notify'];
        } elseif ($this->config->get('follow_notify')) {
            $this->data['follow_notify'] = $this->config->get('follow_notify');
        } else {
            $this->data['follow_notify'] = 0;
        }
        
		foreach ($languages as $language) {
	        if (isset($this->request->post['follow_comment_'.$language['language_id']])) {
    	        $this->data['follow_comment_'.$language['language_id']] = $this->request->post['follow_comment_'.$language['language_id']];
        	} elseif ($this->config->get('follow_comment_'.$language['language_id'])) {
	            $this->data['follow_comment_'.$language['language_id']] = $this->config->get('follow_comment_'.$language['language_id']);
    	    } else {
        	    $this->data['follow_comment_'.$language['language_id']] = '';
	        }			
	
	        if (isset($this->request->post['follow_subject_'.$language['language_id']])) {
    	        $this->data['follow_subject_'.$language['language_id']] = $this->request->post['follow_subject_'.$language['language_id']];
	        } elseif ($this->config->get('follow_subject_'.$language['language_id'])) {
    	        $this->data['follow_subject_'.$language['language_id']] = $this->config->get('follow_subject_'.$language['language_id']);
        	} else {
	            $this->data['follow_subject_'.$language['language_id']] = '';
    	    }

	        if (isset($this->request->post['follow_message_'.$language['language_id']])) {
    	        $this->data['follow_message_'.$language['language_id']] = $this->request->post['follow_message_'.$language['language_id']];
	        } elseif ($this->config->get('follow_message_'.$language['language_id'])) {
    	        $this->data['follow_message_'.$language['language_id']] = $this->config->get('follow_message_'.$language['language_id']);
        	} else {
	            $this->data['follow_message_'.$language['language_id']] = '';
    	    }    	    
		}  

        if (isset($this->request->post['delayed_days'])) {
            $this->data['delayed_days'] = $this->request->post['delayed_days'];
        } elseif ($this->config->get('delayed_days')) { 
            $this->data['delayed_days'] = $this->config->get('delayed_days');
        } else {
            $this->data['delayed_days'] = 0;
        }

        if (isset($this->request->post['delayed_status_from'])) {
            $this->data['delayed_status_from'] = $this->request->post['delayed_status_from'];
        } elseif ($this->config->get('delayed_status_from')) {
            $this->data['delayed_status_from'] = $this->config->get('delayed_status_from');
        } else {
            $this->data['delayed_status_from'] = 0;
        }

        if (isset($this->request->post['delayed_status_to'])) {
            $this->data['delayed_status_to'] = $this->request->post['delayed_status_to'];
        } elseif ($this->config->get('delayed_status_to')) {
            $this->data['delayed_status_to'] = $this->config->get('delayed_status_to');
        } else {
            $this->data['delayed_status_to'] = 0;
        }
          
        if (isset($this->request->post['delayed_change'])) {
            $this->data['delayed_change'] = $this->request->post['delayed_change'];
        } elseif ($this->config->get('delayed_change')) {
            $this->data['delayed_change'] = $this->config->get('delayed_change');
        } else {
            $this->data['delayed_change'] = 0;
        }
       
        if (isset($this->request->post['delayed_notify'])) {
            $this->data['delayed_notify'] = $this->request->post['delayed_notify'];
        } elseif ($this->config->get('delayed_notify')) {
            $this->data['delayed_notify'] = $this->config->get('delayed_notify');
        } else {
            $this->data['delayed_notify'] = 0;
        }

		foreach ($languages as $language) {
	        if (isset($this->request->post['delayed_comment_'.$language['language_id']])) {
    	        $this->data['delayed_comment_'.$language['language_id']] = $this->request->post['delayed_comment_'.$language['language_id']];
        	} elseif ($this->config->get('delayed_comment_'.$language['language_id'])) {
	            $this->data['delayed_comment_'.$language['language_id']] = $this->config->get('delayed_comment_'.$language['language_id']);
    	    } else {
        	    $this->data['delayed_comment_'.$language['language_id']] = '';
	        }			
	
	        if (isset($this->request->post['delayed_subject_'.$language['language_id']])) {
    	        $this->data['delayed_subject_'.$language['language_id']] = $this->request->post['delayed_subject_'.$language['language_id']];
	        } elseif ($this->config->get('delayed_subject_'.$language['language_id'])) {
    	        $this->data['delayed_subject_'.$language['language_id']] = $this->config->get('delayed_subject_'.$language['language_id']);
        	} else {
	            $this->data['delayed_subject_'.$language['language_id']] = '';
    	    }

	        if (isset($this->request->post['delayed_message_'.$language['language_id']])) {
    	        $this->data['delayed_message_'.$language['language_id']] = $this->request->post['delayed_message_'.$language['language_id']];
	        } elseif ($this->config->get('delayed_message_'.$language['language_id'])) {
    	        $this->data['delayed_message_'.$language['language_id']] = $this->config->get('delayed_message_'.$language['language_id']);
        	} else {
	            $this->data['delayed_message_'.$language['language_id']] = '';
    	    }    	    
		}         

        if (isset($this->request->post['reminders_custom'])) {
           	$this->data['reminders_custom'] = $this->request->post['reminders_custom'];
        } elseif ($this->config->get('reminders_custom')) { 
           	$this->data['reminders_custom'] = $this->config->get('reminders_custom');
        } else {
           	$this->data['reminders_custom'] = 1;
        }

        for ($i = 1; $i <= $this->data['reminders_custom']; $i++)
        {
        	if (isset($this->request->post['notice_days_'.$i])) {
            	$this->data['notice_days_'.$i] = $this->request->post['notice_days_'.$i];
        	} elseif ($this->config->get('notice_days_'.$i)) { 
            	$this->data['notice_days_'.$i] = $this->config->get('notice_days_'.$i);
        	} else {
            	$this->data['notice_days_'.$i] = 0;
        	}

        	if (isset($this->request->post['notice_status_from_'.$i])) {
            	$this->data['notice_status_from_'.$i] = $this->request->post['notice_status_from_'.$i];
        	} elseif ($this->config->get('notice_status_from_'.$i)) {
	            $this->data['notice_status_from_'.$i] = $this->config->get('notice_status_from_'.$i);
    	    } else {
        	    $this->data['notice_status_from_'.$i] = '';
        	}

        	if (isset($this->request->post['notice_status_to_'.$i])) {
	            $this->data['notice_status_to_'.$i] = $this->request->post['notice_status_to_'.$i];
    	    } elseif ($this->config->get('notice_status_to_'.$i)) {
        	    $this->data['notice_status_to_'.$i] = $this->config->get('notice_status_to_'.$i);
        	} else {
	            $this->data['notice_status_to_'.$i] = '';
    	    }
        
        	if (isset($this->request->post['notice_recurring_'.$i])) {
            	$this->data['notice_recurring_'.$i] = $this->request->post['notice_recurring_'.$i];
        	} elseif ($this->config->get('notice_recurring_'.$i)) {
            	$this->data['notice_recurring_'.$i] = $this->config->get('notice_recurring_'.$i);
        	} else {
            	$this->data['notice_recurring_'.$i] = 0;
        	}
                
        	if (isset($this->request->post['notice_change_'.$i])) {
            	$this->data['notice_change_'.$i] = $this->request->post['notice_change_'.$i];
        	} elseif ($this->config->get('notice_change_'.$i)) {
            	$this->data['notice_change_'.$i] = $this->config->get('notice_change_'.$i);
        	} else {
            	$this->data['notice_change_'.$i] = 0;
        	}
        
        	if (isset($this->request->post['notice_notify_'.$i])) {
            	$this->data['notice_notify_'.$i] = $this->request->post['notice_notify_'.$i];
        	} elseif ($this->config->get('notice_notify_'.$i)) {
            	$this->data['notice_notify_'.$i] = $this->config->get('notice_notify_'.$i);
        	} else {
            	$this->data['notice_notify_'.$i] = 0;
        	}
		
			foreach ($languages as $language) {
	        	if (isset($this->request->post['notice_notify_'.$i.'_'.$language['language_id']])) {
    	        	$this->data['notice_comment_'.$i.'_'.$language['language_id']] = $this->request->post['notice_comment_'.$i.'_'.$language['language_id']];
        		} elseif ($this->config->get('notice_comment_'.$i.'_'.$language['language_id'])) {
	            	$this->data['notice_comment_'.$i.'_'.$language['language_id']] = $this->config->get('notice_comment_'.$i.'_'.$language['language_id']);
    	    	} else {
	        	    $this->data['notice_comment_'.$i.'_'.$language['language_id']] = '';
		        }			
	
	    	    if (isset($this->request->post['notice_subject_'.$i.'_'.$language['language_id']])) {
    	    	    $this->data['notice_subject_'.$i.'_'.$language['language_id']] = $this->request->post['notice_subject_'.$i.'_'.$language['language_id']];
		        } elseif ($this->config->get('notice_subject_'.$i.'_'.$language['language_id'])) {
    		        $this->data['notice_subject_'.$i.'_'.$language['language_id']] = $this->config->get('notice_subject_'.$i.'_'.$language['language_id']);
        		} else {
	        	    $this->data['notice_subject_'.$i.'_'.$language['language_id']] = '';
	    	    }

		        if (isset($this->request->post['notice_message_'.$i.'_'.$language['language_id']])) {
    		        $this->data['notice_message_'.$i.'_'.$language['language_id']] = $this->request->post['notice_message_'.$i.'_'.$language['language_id']];
	        	} elseif ($this->config->get('notice_message_'.$i.'_'.$language['language_id'])) {
	    	        $this->data['notice_message_'.$i.'_'.$language['language_id']] = $this->config->get('notice_message_'.$i.'_'.$language['language_id']);
    	    	} else {
	    	        $this->data['notice_message_'.$i.'_'.$language['language_id']] = '';
    	    	}    	    
			}    
        }
                
        $this->load->model('localisation/order_status');
        $this->data['statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->load->model('design/layout');
   
        $this->data['layouts'] = $this->model_design_layout->getLayouts();
				
		$this->template = 'module/reminders.tpl';

        $this->children = array(
            'common/header',
            'common/footer',
        );
				
        $this->response->setOutput($this->render());
    }
	
    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'module/reminders')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (isset($this->request->post['expiring_days']) && is_numeric($this->request->post['expiring_days'])) {
            if ( $this->request->post['expiring_days'] < 0 || $this->request->post['expiring_days'] > 30) {
                $this->error['warning'] = $this->language->get('error_out_of_range');
            }
        } else {
           $this->error['warning'] = $this->language->get('error_bad_value');
        }

		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();

		foreach ($languages as $language) {
        	if (isset($this->request->post['expiring_comment_'.$language['language_id']]) && strlen($this->request->post['expiring_comment_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_comment');
        	}

        	if (isset($this->request->post['expiring_subject'.$language['language_id']]) && strlen($this->request->post['expiring_subject'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_subject');
        	} 
        }

		$this->request->post['expiring_change'] = (empty($this->request->post['expiring_change']) ? 0 : 1 );
        $this->request->post['expiring_notify'] = (empty($this->request->post['expiring_notify']) ? 0 : 1 );

        if (isset($this->request->post['expired_days']) && is_numeric($this->request->post['expired_days']) ) {
            if ( $this->request->post['expired_days'] < 0 || $this->request->post['expired_days'] > 30) {
                $this->error['warning'] = $this->language->get('error_out_of_range');
            }
        } else {
           $this->error['warning'] = $this->language->get('error_bad_value');
        }

		foreach ($languages as $language) {
        	if (isset($this->request->post['expired_comment_'.$language['language_id']]) && strlen($this->request->post['expired_comment_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_comment');
        	}
        
        	if (isset($this->request->post['expired_subject_'.$language['language_id']]) && strlen($this->request->post['expired_subject_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_subject');
        	} 
        }

		$this->request->post['expired_change'] = (empty($this->request->post['expired_change']) ? 0 : 1 );
        $this->request->post['expired_notify'] = (empty($this->request->post['expired_notify']) ? 0 : 1 );

        if (isset($this->request->post['remind_days']) && is_numeric($this->request->post['remind_days']) ) {
            if ( $this->request->post['remind_days'] < 0 || $this->request->post['remind_days'] > 30) {
                $this->error['warning'] = $this->language->get('error_out_of_range');
            }
        } else {
           $this->error['warning'] = $this->language->get('error_bad_value');
        }

		foreach ($languages as $language) {
        	if (isset($this->request->post['remind_subject_'.$language['language_id']]) && strlen($this->request->post['remind_subject_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_subject');
        	} 
        }

        $this->request->post['remind_notify'] = (empty($this->request->post['remind_notify']) ? 0 : 1 );

        if (isset($this->request->post['follow_days']) && is_numeric($this->request->post['follow_days']) ) {
            if ( $this->request->post['follow_days'] < 0 || $this->request->post['follow_days'] > 30) {
                $this->error['warning'] = $this->language->get('error_out_of_range');
            }
        } else {
           $this->error['warning'] = $this->language->get('error_bad_value');
        }

		foreach ($languages as $language) {
        	if (isset($this->request->post['follow_subject_'.$language['language_id']]) && strlen($this->request->post['follow_subject_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_subject');
        	} 
        }

        $this->request->post['follow_notify'] = (empty($this->request->post['follow_notify']) ? 0 : 1 );

        if (isset($this->request->post['delayed_days']) && is_numeric($this->request->post['delayed_days'])) {
            if ( $this->request->post['delayed_days'] < 0 || $this->request->post['delayed_days'] > 30) {
                $this->error['warning'] = $this->language->get('error_out_of_range');
            }
        } else {
           $this->error['warning'] = $this->language->get('error_bad_value');
        }

		foreach ($languages as $language) {
        	if (isset($this->request->post['delayed_comment_'.$language['language_id']]) && strlen($this->request->post['delayed_comment_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_comment');
        	}

        	if (isset($this->request->post['delayed_subject_'.$language['language_id']]) && strlen($this->request->post['delayed_subject_'.$language['language_id']]) > 250) {
            	$this->error['warning'] = $this->language->get('error_long_subject');
        	} 
        }

		$this->request->post['delayed_change'] = (empty($this->request->post['delayed_change']) ? 0 : 1 );
        $this->request->post['delayed_notify'] = (empty($this->request->post['delayed_notify']) ? 0 : 1 );

        if (isset($this->request->post['reminders_custom'])) {
           	$custom = $this->request->post['reminders_custom'];
        } else {
           	$custom = $this->data['reminders_custom'];
        }

        for ($i = 1; $i <= $custom; $i++)
        {	
	        if (isset($this->request->post['notice_days_'.$i]) && is_numeric($this->request->post['notice_days_'.$i]) ) {
    	        if ( $this->request->post['notice_days_'.$i] < 0 || $this->request->post['notice_days_'.$i] > 30) {
        	        $this->error['warning'] = $this->language->get('error_out_of_range');
            	}
	        } else {
    	       $this->error['warning'] = $this->language->get('error_bad_value');
        	}
		
			foreach ($languages as $language) {
	        	if (isset($this->request->post['notice_comment_'.$i.'_'.$language['language_id']]) && strlen($this->request->post['notice_comment_'.$i.'_'.$language['language_id']]) > 250) {
    	        	$this->error['warning'] = $this->language->get('error_long_comment');
        		}
        
	        	if (isset($this->request->post['notice_subject_'.$i.'_'.$language['language_id']]) && strlen($this->request->post['notice_subject_'.$i.'_'.$language['language_id']]) > 250) {
    	        	$this->error['warning'] = $this->language->get('error_long_subject');
        		} 
        	}

			$this->request->post['notice_recurring_'.$i] = (empty($this->request->post['notice_recurring_'.$i]) ? 0 : 1 );
			$this->request->post['notice_change_'.$i] = (empty($this->request->post['notice_change_'.$i]) ? 0 : 1 );
        	$this->request->post['notice_notify_'.$i] = (empty($this->request->post['notice_notify_'.$i]) ? 0 : 1 );
		}
		                
        if (!$this->error) {
            return true;
        } else {
            return false;
        }	
    }
}

?>