<?php
class ModelCatalogSpecialManager extends Model {
		
	const DISCOUNT_TYPE_PERCENTAGE = 0;
	const DISCOUNT_TYPE_FIXED_DISCOUNT = 1;
	const DISCOUNT_TYPE_FIXED_PRICE = 2;
		
	public function addProductSpecial($data) {
		$product_special_ids = array();
		
		if (isset($data['special_manager_category'])) {
			$product_ids = $data['special_manager_category'];
		}
    if (isset($data['special_manager_manufacturer'])) {
			$product_ids = $data['special_manager_manufacturer'];
		}
		if (isset($data['special_manager_product'])) {
			$product_ids = $data['special_manager_product'];
		}
		
		foreach ($product_ids as $product_id) {			
			$this->load->model('catalog/product');
			
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			$index = $data['discount_type'];
			
			if ($index == self::DISCOUNT_TYPE_FIXED_DISCOUNT) {
				$price = $product_info['price'] - $data['discount'];	
			} else if ($index == self::DISCOUNT_TYPE_FIXED_PRICE) {
				$price = $data['discount'];
			} else {
				$price = (1-($data['discount']/100)) * $product_info['price'];
			}
			
			$price = number_format($price, 2, '.', '');
			
			$price = ($price > 0) ? $price : 0;	
			
			$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product_id . "', customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', price = '" . (float)$price . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "'");
			
			$product_special_ids[] = $this->db->getLastId();
		}
				
		$this->cache->delete('product');
		
		return $product_special_ids;
	}
	
	public function editProductSpecial($product_special_id, $data) {
		$price = ($data['new_price'] > 0) ? $data['new_price'] : 0;				
		$this->db->query("UPDATE " . DB_PREFIX . "product_special SET customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', price = '" . (float)$price . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "' WHERE product_special_id = '" . (int)$product_special_id . "'");
				
		$this->cache->delete('product');
	}
		
	public function editProductSpecialDataTable($product_special_id, $data) {
		
		$return = $data['old_value'];
				
		if ($data['key'] == 'customer_group') {
			$result = $this->db->query("SELECT name FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$data['value'] . "'");
				
			$return = $result->row['name'];

			$sql = "UPDATE " . DB_PREFIX . "product_special SET customer_group_id = '" . (int)$data['value'] . "' WHERE product_special_id = '" . (int)$product_special_id . "'";	
		}
		
		if ($data['key'] == 'priority') {
			$sql = "UPDATE " . DB_PREFIX . "product_special SET priority = '" . (int)$data['value'] . "' WHERE product_special_id = '" . (int)$product_special_id . "'";
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'discount') {
			$sql = "UPDATE " . DB_PREFIX . "product_special SET price = '" . (float)$data['value'] . "' WHERE product_special_id = '" . (int)$product_special_id . "'";
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'date_start') {
			$sql = "UPDATE " . DB_PREFIX . "product_special SET date_start = '" . date($this->language->get('date_format_php'), strtotime($data['value'])) . "' WHERE product_special_id = '" . (int)$product_special_id . "'";
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		if ($data['key'] == 'date_end') {
			$sql = "UPDATE " . DB_PREFIX . "product_special SET date_end = '" . date($this->language->get('date_format_php'), strtotime($data['value'])) . "' WHERE product_special_id = '" . (int)$product_special_id . "'";
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		if ($sql) {
			$this->db->query($sql);
		}
		
		return $return;
	}
	
	public function deleteProductSpecial($product_special_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_special_id = '" . (int)$product_special_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_special_to_product_special WHERE product_special_id = '" . (int)$product_special_id . "'");
    $this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer_special_to_product_special WHERE product_special_id = '" . (int)$product_special_id . "'");
				
		$this->cache->delete('product');
	}
	
	public function getProductSpecial($product_special_id) {
		$query = $this->db->query("SELECT ps.*, p.price as original_price FROM " . DB_PREFIX . "product_special ps LEFT JOIN " . DB_PREFIX . "product p ON (ps.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (ps.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "customer_group cg ON (ps.customer_group_id = cg.customer_group_id) WHERE ps.product_special_id = '" . (int)$product_special_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
				
		return $query->row;
	}
	
	public function getProductSpecialsByCategorySpecial($category_special_id) {
		$query = $this->db->query("SELECT product_special_id FROM " . DB_PREFIX . "category_special_to_product_special WHERE category_special_id = '" . (int)$category_special_id . "'");
		
		return $query->rows;
	}

  public function getProductSpecialsByManufacturerSpecial($manufacturer_special_id) {
		$query = $this->db->query("SELECT product_special_id FROM " . DB_PREFIX . "manufacturer_special_to_product_special WHERE manufacturer_special_id = '" . (int)$manufacturer_special_id . "'");

		return $query->rows;
	}
	
	public function getProductSpecials($data = array()) {
		if ($data) {
			$sql = "SELECT DISTINCT ps.*, pd.*, cg.name as cg_name FROM " . DB_PREFIX . "product_special ps LEFT JOIN " . DB_PREFIX . "product_description pd ON (ps.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cg ON (ps.customer_group_id = cg.customer_group_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'"; 
						
			if (isset($data['filters']) && count($data['filters']) > 1) {
				$sql .= " AND (";
				foreach ($data['filters'] as $filter) {
					$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
				}	
				$sql = substr_replace($sql, "", -3);
				$sql .= ")";
			}

			$sort_data = $data['sort_columns'];
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY ps.priority, ps.price";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
		
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
		
			$product_data = array();
			
			foreach ($query->rows as $result) {
								
				$product_data[] = array(
					'product_special_id' => $result['product_special_id'],
					'product_id' => $result['product_id'],
					'name' => $result['name'],
					'customer_group' => $result['cg_name'],
					'priority' => $result['priority'],
					'discount' => $result['price'],
					'date_start' => $result['date_start'],
					'date_end' => $result['date_end']
				);
			}
			
			return $product_data;
		} 
	}
		
	public function getTotalProductSpecials($data = array()) {
		$sql = "SELECT COUNT(DISTINCT ps.product_special_id) AS total FROM " . DB_PREFIX . "product_special ps LEFT JOIN " . DB_PREFIX . "product_description pd ON (ps.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "customer_group cg ON (ps.customer_group_id = cg.customer_group_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		if (isset($data['filters']) && count($data['filters']) > 1) {
			$sql .= " AND (";
			foreach ($data['filters'] as $filter) {
				$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
			}	
			$sql = substr_replace($sql, "", -3);
			$sql .= ")";
		}

		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}

	public function addCategorySpecial($data) {
		foreach ($data['special_manager_category'] as $category_id) {					
			$this->load->model('catalog/product');
			
			$products = $this->model_catalog_product->getProductsByCategoryId($category_id);
			
			$myData = $data;
			
			$myData['special_manager_category'] = array();
			
			foreach ($products as $product) {
				$myData['special_manager_category'][] = $product['product_id'];
			}
			
			$product_special_ids = $this->addProductSpecial($myData);
					
			$this->db->query("INSERT INTO " . DB_PREFIX . "category_special SET category_id = '" . (int)$category_id . "', customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', discount = '" . (float)$data['discount'] . "', discount_type = '" . (int)$data['discount_type'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "'");
			
			$category_special_id = $this->db->getLastId();
			
			foreach ($product_special_ids as $product_special_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "category_special_to_product_special SET category_special_id = '" . (int)$category_special_id . "', product_special_id = '" . (int)$product_special_id . "'");
			}
		}
	}
		
	public function editCategorySpecial($category_special_id, $data) {
		$category_special_info = $this->getCategorySpecial($category_special_id);
		
		$this->load->model('catalog/product');
			
		$products = $this->model_catalog_product->getProductsByCategoryId($category_special_info['category_id']);
		
		$myData = $data;
		
		$myData['special_manager_category'] = array();
		
		foreach ($products as $product) {
			$myData['special_manager_category'][] = $product['product_id'];
		}
							
		$product_specials = $this->getProductSpecialsByCategorySpecial($category_special_id);
				
		foreach ($product_specials as $product_special) {
			$this->deleteProductSpecial($product_special['product_special_id']);						
		}
		
		$product_special_ids = $this->addProductSpecial($myData);	
		
		$this->db->query("UPDATE " . DB_PREFIX . "category_special SET customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', discount = '" . (float)$data['discount'] . "', discount_type = '" . (int)$data['discount_type'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "' WHERE category_special_id = '" . (int)$category_special_id . "'");
				
		foreach ($product_special_ids as $product_special_id) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "category_special_to_product_special SET category_special_id = '" . (int)$category_special_id . "', product_special_id = '" . (int)$product_special_id . "'");
		}
	}
		
	public function editCategorySpecialDataTable($category_special_id, $data) {
		$return = $data['old_value'];
		
		$category_special = $this->getCategorySpecial($category_special_id);
				
		$myData = $category_special;	
						
		if ($data['key'] == 'customer_group') {
			$result = $this->db->query("SELECT name FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$data['value'] . "'");
				
			$return = $result->row['name'];

			$myData['customer_group_id'] = $data['value'];
		}
		
		if ($data['key'] == 'priority') {
			$myData['priority'] = $data['value'];
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'discount') {
			$myData['discount'] = $data['value'];
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'discount_type') {			
			$this->load->language('catalog/special_manager');
			
			if ($data['value'] == self::DISCOUNT_TYPE_PERCENTAGE) {
				$return = $this->language->get('text_percentage');
			}
			if ($data['value'] == self::DISCOUNT_TYPE_FIXED_DISCOUNT) {
				$return = $this->language->get('text_fixed_discount');
			}
			if ($data['value'] == self::DISCOUNT_TYPE_FIXED_PRICE) {
				$return = $this->language->get('text_fixed_price');
			}

			$myData['discount_type'] = $data['value'];	
		}
		
		if ($data['key'] == 'date_start') {
			$myData['date_start'] = $data['value'];
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		if ($data['key'] == 'date_end') {
			$myData['date_end'] = $data['value'];
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		$this->editCategorySpecial($category_special_id, $myData);
		
		return $return;
	}
	
	public function deleteCategorySpecial($category_special_id) {
		
		$product_specials = $this->getProductSpecialsByCategorySpecial($category_special_id);
		
		foreach ($product_specials as $product_special) {
			$this->deleteProductSpecial($product_special['product_special_id']);						
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_special WHERE category_special_id = '" . (int)$category_special_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_special_to_product_special WHERE category_special_id = '" . (int)$category_special_id . "'");
	}
	
	public function getCategorySpecial($category_special_id) {
		$query = $this->db->query("SELECT cs.* FROM " . DB_PREFIX . "category_special cs LEFT JOIN " . DB_PREFIX . "category_description cd ON (cs.category_id = cd.category_id) LEFT JOIN " . DB_PREFIX . "customer_group cg ON (cs.customer_group_id = cg.customer_group_id) WHERE cs.category_special_id = '" . (int)$category_special_id . "' AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
				
		return $query->row;
	}
	
	public function getCategorySpecials($data = array()) {
		if ($data) {
			$sql = "SELECT DISTINCT cs.*, cd.*, cg.name as cg_name FROM " . DB_PREFIX . "category_special cs LEFT JOIN " . DB_PREFIX . "category_description cd ON (cs.category_id = cd.category_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cg ON (cs.customer_group_id = cg.customer_group_id) WHERE cd.language_id = '" . (int)$this->config->get('config_language_id') . "'"; 
						
			if (isset($data['filters']) && count($data['filters']) > 1) {
				$sql .= " AND (";
				foreach ($data['filters'] as $filter) {
					$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
				}	
				$sql = substr_replace($sql, "", -3);
				$sql .= ")";
			}
			
			$sort_data = $data['sort_columns'];
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY cs.priority, cs.discount";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
		
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
		
			$category_data = array();
			
			foreach ($query->rows as $result) {				
				$category_data[] = array(
					'category_special_id' => $result['category_special_id'],
					'name' => $result['name'],
					'customer_group' => $result['cg_name'],
					'priority' => $result['priority'],
					'discount' => $result['discount'],
					'discount_type' => $result['discount_type'],
					'date_start' => $result['date_start'],
					'date_end' => $result['date_end']
				);
			}
			
			return $category_data;
		} 
	}
	
	public function getTotalCategorySpecials($data = array()) {
		$sql = "SELECT COUNT(DISTINCT cs.category_special_id) AS total FROM " . DB_PREFIX . "category_special cs LEFT JOIN " . DB_PREFIX . "category_description cd ON (cs.category_id = cd.category_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cg ON (cs.customer_group_id = cg.customer_group_id) WHERE cd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		if (isset($data['filters']) && count($data['filters']) > 1) {
			$sql .= " AND (";
			foreach ($data['filters'] as $filter) {
				$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
			}	
			$sql = substr_replace($sql, "", -3);
			$sql .= ")";
		}

		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
  
  public function addManufacturerSpecial($data) {
		foreach ($data['special_manager_manufacturer'] as $manufacturer_id) {					
			$this->load->model('catalog/product');
			
			$products = $this->model_catalog_product->getProductsByManufacturerId($manufacturer_id);
			
			$myData = $data;
			
			$myData['special_manager_manufacturer'] = array();
			
			foreach ($products as $product) {
				$myData['special_manager_manufacturer'][] = $product['product_id'];
			}
			
			$product_special_ids = $this->addProductSpecial($myData);
					
			$this->db->query("INSERT INTO " . DB_PREFIX . "manufacturer_special SET manufacturer_id = '" . (int)$manufacturer_id . "', customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', discount = '" . (float)$data['discount'] . "', discount_type = '" . (int)$data['discount_type'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "'");
			
			$manufacturer_special_id = $this->db->getLastId();
			
			foreach ($product_special_ids as $product_special_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "manufacturer_special_to_product_special SET manufacturer_special_id = '" . (int)$manufacturer_special_id . "', product_special_id = '" . (int)$product_special_id . "'");
			}
		}
	}
		
	public function editManufacturerSpecial($manufacturer_special_id, $data) {
		$manufacturer_special_info = $this->getManufacturerSpecial($manufacturer_special_id);
		
		$this->load->model('catalog/product');
			
		$products = $this->model_catalog_product->getProductsByManufacturerId($manufacturer_special_info['manufacturer_id']);
		
		$myData = $data;
		
		$myData['special_manager_manufacturer'] = array();
		
		foreach ($products as $product) {
			$myData['special_manager_manufacturer'][] = $product['product_id'];
		}
							
		$product_specials = $this->getProductSpecialsByManufacturerSpecial($manufacturer_special_id);
				
		foreach ($product_specials as $product_special) {
			$this->deleteProductSpecial($product_special['product_special_id']);						
		}
		
		$product_special_ids = $this->addProductSpecial($myData);	
		
		$this->db->query("UPDATE " . DB_PREFIX . "manufacturer_special SET customer_group_id = '" . (int)$data['customer_group_id'] . "', priority = '" . (int)$data['priority'] . "', discount = '" . (float)$data['discount'] . "', discount_type = '" . (int)$data['discount_type'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "' WHERE manufacturer_special_id = '" . (int)$manufacturer_special_id . "'");
				
		foreach ($product_special_ids as $product_special_id) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "manufacturer_special_to_product_special SET manufacturer_special_id = '" . (int)$manufacturer_special_id . "', product_special_id = '" . (int)$product_special_id . "'");
		}
	}
		
	public function editManufacturerSpecialDataTable($manufacturer_special_id, $data) {
		$return = $data['old_value'];
		
		$manufacturer_special = $this->getManufacturerSpecial($manufacturer_special_id);
				
		$myData = $manufacturer_special;	
						
		if ($data['key'] == 'customer_group') {
			$result = $this->db->query("SELECT name FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$data['value'] . "'");
				
			$return = $result->row['name'];

			$myData['customer_group_id'] = $data['value'];
		}
		
		if ($data['key'] == 'priority') {
			$myData['priority'] = $data['value'];
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'discount') {
			$myData['discount'] = $data['value'];
			$return = $data['value'];	
		}
		
		if ($data['key'] == 'discount_type') {			
			$this->load->language('catalog/special_manager');
			
			if ($data['value'] == self::DISCOUNT_TYPE_PERCENTAGE) {
				$return = $this->language->get('text_percentage');
			}
			if ($data['value'] == self::DISCOUNT_TYPE_FIXED_DISCOUNT) {
				$return = $this->language->get('text_fixed_discount');
			}
			if ($data['value'] == self::DISCOUNT_TYPE_FIXED_PRICE) {
				$return = $this->language->get('text_fixed_price');
			}

			$myData['discount_type'] = $data['value'];	
		}
		
		if ($data['key'] == 'date_start') {
			$myData['date_start'] = $data['value'];
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		if ($data['key'] == 'date_end') {
			$myData['date_end'] = $data['value'];
			$return = date($this->language->get('date_format_php'), strtotime($data['value']));	
		}
		
		$this->editManufacturerSpecial($manufacturer_special_id, $myData);
		
		return $return;
	}
	
	public function deleteManufacturerSpecial($manufacturer_special_id) {
		
		$product_specials = $this->getProductSpecialsByManufacturerSpecial($manufacturer_special_id);
		
		foreach ($product_specials as $product_special) {
			$this->deleteProductSpecial($product_special['product_special_id']);						
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer_special WHERE manufacturer_special_id = '" . (int)$manufacturer_special_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer_special_to_product_special WHERE manufacturer_special_id = '" . (int)$manufacturer_special_id . "'");
	}
	
	public function getManufacturerSpecial($manufacturer_special_id) {
		$query = $this->db->query("SELECT cs.* FROM " . DB_PREFIX . "manufacturer_special cs LEFT JOIN " . DB_PREFIX . "customer_group cg ON (cs.customer_group_id = cg.customer_group_id) WHERE cs.manufacturer_special_id = '" . (int)$manufacturer_special_id . "'");
				
		return $query->row;
	}
	
	public function getManufacturerSpecials($data = array()) {
		if ($data) {
			$sql = "SELECT DISTINCT cs.*, m.name, cg.name as cg_name FROM " . DB_PREFIX . "manufacturer_special cs LEFT JOIN " . DB_PREFIX . "manufacturer m ON (cs.manufacturer_id = m.manufacturer_id) LEFT JOIN " . DB_PREFIX . "customer_group_description cg ON (cs.customer_group_id = cg.customer_group_id) WHERE 1 = 1";
						
			if (isset($data['filters']) && count($data['filters']) > 1) {
				$sql .= " AND (";
				foreach ($data['filters'] as $filter) {
					$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
				}	
				$sql = substr_replace($sql, "", -3);
				$sql .= ")";
			}
			
			$sort_data = $data['sort_columns'];
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY cs.priority, cs.discount";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
		
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	

			$query = $this->db->query($sql);
		
			$manufacturer_data = array();
			
			foreach ($query->rows as $result) {				
				$manufacturer_data[] = array(
					'manufacturer_special_id' => $result['manufacturer_special_id'],
					'name' => $result['name'],
					'customer_group' => $result['cg_name'],
					'priority' => $result['priority'],
					'discount' => $result['discount'],
					'discount_type' => $result['discount_type'],
					'date_start' => $result['date_start'],
					'date_end' => $result['date_end']
				);
			}
			
			return $manufacturer_data;
		} 
	}
	
	public function getTotalManufacturerSpecials($data = array()) {
		$sql = "SELECT COUNT(DISTINCT cs.manufacturer_special_id) AS total FROM " . DB_PREFIX . "manufacturer_special cs LEFT JOIN " . DB_PREFIX . "manufacturer m ON (cs.manufacturer_id = m.manufacturer_id) LEFT JOIN " . DB_PREFIX . "customer_group cg ON (cs.customer_group_id = cg.customer_group_id) WHERE 1=1";
		
		if (isset($data['filters']) && count($data['filters']) > 1) {
			$sql .= " AND (";
			foreach ($data['filters'] as $filter) {
				$sql .= 'UPPER(' . $filter['name'] . ") LIKE UPPER('%" . $this->db->escape($filter['keyword']) . "%') OR ";
			}	
			$sql = substr_replace($sql, "", -3);
			$sql .= ")";
		}

		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
}
?>