<?php
class ModelDesignBannerFour extends Model {
	public function addBannerFour($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "banner_four SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "'");

		$banner_four_id = $this->db->getLastId();

		if (isset($data['banner_four_image'])) {
			foreach ($data['banner_four_image'] as $banner_four_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_four_image SET banner_four_id = '" . (int)$banner_four_id . "', link = '" .  $this->db->escape($banner_four_image['link']) . "', heading = '" .  $this->db->escape($banner_four_image['heading']) . "', image = '" .  $this->db->escape($banner_four_image['image']) . "'");

				$banner_four_image_id = $this->db->getLastId();

				foreach ($banner_four_image['banner_four_image_description'] as $language_id => $banner_four_image_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_four_image_description SET banner_four_image_id = '" . (int)$banner_four_image_id . "', language_id = '" . (int)$language_id . "', banner_four_id = '" . (int)$banner_four_id . "', title = '" .  $this->db->escape($banner_four_image_description['title']) . "'");
				}
			}
		}
	}

	public function editBannerFour($banner_four_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "banner_four SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "' WHERE banner_four_id = '" . (int)$banner_four_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_four_image WHERE banner_four_id = '" . (int)$banner_four_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_four_image_description WHERE banner_four_id = '" . (int)$banner_four_id . "'");

		if (isset($data['banner_four_image'])) {
			foreach ($data['banner_four_image'] as $banner_four_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_four_image SET banner_four_id = '" . (int)$banner_four_id . "', link = '" .  $this->db->escape($banner_four_image['link']) . "', heading = '" .  $this->db->escape($banner_four_image['heading']) . "', image = '" .  $this->db->escape($banner_four_image['image']) . "'");

				$banner_four_image_id = $this->db->getLastId();

				foreach ($banner_four_image['banner_four_image_description'] as $language_id => $banner_four_image_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_four_image_description SET banner_four_image_id = '" . (int)$banner_four_image_id . "', language_id = '" . (int)$language_id . "', banner_four_id = '" . (int)$banner_four_id . "', title = '" .  $this->db->escape($banner_four_image_description['title']) . "'");
				}
			}
		}
	}

	public function deleteBannerFour($banner_four_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_four WHERE banner_four_id = '" . (int)$banner_four_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_four_image WHERE banner_four_id = '" . (int)$banner_four_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_four_image_description WHERE banner_four_id = '" . (int)$banner_four_id . "'");
	}

	public function getBannerFour($banner_four_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "banner_four WHERE banner_four_id = '" . (int)$banner_four_id . "'");

		return $query->row;
	}

	public function getBannerFours($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "banner_four";

		$sort_data = array(
			'name',
			'status'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getBannerFourImages($banner_four_id) {
		$banner_four_image_data = array();

		$banner_four_image_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_four_image WHERE banner_four_id = '" . (int)$banner_four_id . "' ORDER BY image ASC");

		foreach ($banner_four_image_query->rows as $banner_four_image) {
			$banner_four_image_description_data = array();

			$banner_four_image_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_four_image_description WHERE banner_four_image_id = '" . (int)$banner_four_image['banner_four_image_id'] . "' AND banner_four_id = '" . (int)$banner_four_id . "'");

			foreach ($banner_four_image_description_query->rows as $banner_four_image_description) {
				$banner_four_image_description_data[$banner_four_image_description['language_id']] = array('title' => $banner_four_image_description['title']);
			}

			$banner_four_image_data[] = array(
				'banner_four_image_description' => $banner_four_image_description_data,
				'link'                     => $banner_four_image['link'],
				'heading'                     => $banner_four_image['heading'],
				'image'                    => $banner_four_image['image']
			);
		}

		return $banner_four_image_data;
	}

	public function getTotalBannerFours() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "banner_four");

		return $query->row['total'];
	}
}
?>