<?php
class ModelDesignBannerWide extends Model {
	public function addBannerWide($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "banner_wide SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "'");

		$banner_wide_id = $this->db->getLastId();

		if (isset($data['banner_wide_image'])) {
			foreach ($data['banner_wide_image'] as $banner_wide_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_wide_image SET banner_wide_id = '" . (int)$banner_wide_id . "', link = '" .  $this->db->escape($banner_wide_image['link']) . "', heading = '" .  $this->db->escape($banner_wide_image['heading']) . "', image = '" .  $this->db->escape($banner_wide_image['image']) . "'");

				$banner_wide_image_id = $this->db->getLastId();

				foreach ($banner_wide_image['banner_wide_image_description'] as $language_id => $banner_wide_image_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_wide_image_description SET banner_wide_image_id = '" . (int)$banner_wide_image_id . "', language_id = '" . (int)$language_id . "', banner_wide_id = '" . (int)$banner_wide_id . "', title = '" .  $this->db->escape($banner_wide_image_description['title']) . "'");
				}
			}
		}
	}

	public function editBannerWide($banner_wide_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "banner_wide SET name = '" . $this->db->escape($data['name']) . "', status = '" . (int)$data['status'] . "' WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_wide_image WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_wide_image_description WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");

		if (isset($data['banner_wide_image'])) {
			foreach ($data['banner_wide_image'] as $banner_wide_image) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "banner_wide_image SET banner_wide_id = '" . (int)$banner_wide_id . "', link = '" .  $this->db->escape($banner_wide_image['link']) . "', heading = '" .  $this->db->escape($banner_wide_image['heading']) . "', image = '" .  $this->db->escape($banner_wide_image['image']) . "'");

				$banner_wide_image_id = $this->db->getLastId();

				foreach ($banner_wide_image['banner_wide_image_description'] as $language_id => $banner_wide_image_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "banner_wide_image_description SET banner_wide_image_id = '" . (int)$banner_wide_image_id . "', language_id = '" . (int)$language_id . "', banner_wide_id = '" . (int)$banner_wide_id . "', title = '" .  $this->db->escape($banner_wide_image_description['title']) . "'");
				}
			}
		}
	}

	public function deleteBannerWide($banner_wide_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_wide WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_wide_image WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "banner_wide_image_description WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");
	}

	public function getBannerWide($banner_wide_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "banner_wide WHERE banner_wide_id = '" . (int)$banner_wide_id . "'");

		return $query->row;
	}

	public function getBannerWides($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "banner_wide";

		$sort_data = array(
			'name',
			'status'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getBannerWideImages($banner_wide_id) {
		$banner_wide_image_data = array();

		$banner_wide_image_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_wide_image WHERE banner_wide_id = '" . (int)$banner_wide_id . "' ORDER BY image ASC");

		foreach ($banner_wide_image_query->rows as $banner_wide_image) {
			$banner_wide_image_description_data = array();

			$banner_wide_image_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "banner_wide_image_description WHERE banner_wide_image_id = '" . (int)$banner_wide_image['banner_wide_image_id'] . "' AND banner_wide_id = '" . (int)$banner_wide_id . "'");

			foreach ($banner_wide_image_description_query->rows as $banner_wide_image_description) {
				$banner_wide_image_description_data[$banner_wide_image_description['language_id']] = array('title' => $banner_wide_image_description['title']);
			}

			$banner_wide_image_data[] = array(
				'banner_wide_image_description' => $banner_wide_image_description_data,
				'link'                     => $banner_wide_image['link'],
				'heading'                     => $banner_wide_image['heading'],
				'image'                    => $banner_wide_image['image']
			);
		}

		return $banner_wide_image_data;
	}

	public function getTotalBannerWides() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "banner_wide");

		return $query->row['total'];
	}
}
?>