<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/product.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons"><a onclick="$('#form').submit();" class="button"><span><?php echo $button_save; ?></span></a><a onclick="location = '<?php echo $cancel; ?>';" class="button"><span><?php echo $button_cancel; ?></span></a></div>
    </div>
    <div class="content">
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
        <table class="form">
          <tr>
            <td><span class="required">*</span> <?php echo $manufacturerEntry_manufacturers; ?></td>
            <td>
              <?php if ($update) { ?>
              <?php echo $manufacturer_name; ?>
              <input type="hidden" name="special_manager_manufacturer" value="<?php echo $special_manager_manufacturer; ?>" />
              <?php } else { ?>
                <div class="filter_scrollbox filter_manufacturer">
            <?php $class = 'odd'; ?>
            <?php foreach ($manufacturers as $manufacturer) { ?>
            <?php $class = ($class == 'even' ? 'odd' : 'even'); ?>
            <div class="<?php echo $class; ?>"><label>
              <?php if (in_array($manufacturer['manufacturer_id'], $special_manager_manufacturer)) { ?>
              <input type="checkbox" class="filter_manufacturer_checkbox" name="special_manager_manufacturer[]" value="<?php echo $manufacturer['manufacturer_id']; ?>" checked="checked" />
              <?php echo addslashes($manufacturer['name']); ?>
              <?php } else { ?>
              <input type="checkbox" class="filter_manufacturer_checkbox" name="special_manager_manufacturer[]" value="<?php echo $manufacturer['manufacturer_id']; ?>" />
              <?php echo addslashes($manufacturer['name']); ?></label>
              <?php } ?>
            </div>
            <?php } ?>
          </div>
          <span><a onclick="$('.filter_manufacturer :checkbox').attr('checked', 'checked');"><?php echo $text_select_all; ?></a> / <a onclick="$('.filter_manufacturer :checkbox').attr('checked', '');"><?php echo $text_select_none; ?></a></span>
          <?php if ($error_manufacturers) { ?>
                <span class="error"><?php echo $error_manufacturers; ?></span>
                <?php } ?>
              <?php } ?>
            </td>
          </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $manufacturerEntry_customer_group; ?></td>
            <td><select name="customer_group_id">
                <?php foreach ($customer_groups as $customer_group) { ?>
                <?php if ($customer_group['customer_group_id'] == $customer_group_id) { ?>
                <option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
                <?php } else { ?>
                <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
                <?php } ?>
                <?php } ?>
              </select></td>
        </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $manufacturerEntry_priority; ?></td>
            <td><input type="text" name="priority" value="<?php echo $priority; ?>" size="1" />
              <?php if ($error_priority) { ?>
              <span class="error"><?php echo $error_priority; ?></span>
              <?php } ?></td>
          </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $manufacturerEntry_discount_type; ?></td>
            <td><select name="discount_type" id="discount_type">
                <?php if ($discount_type == '1') { ?>
                <option value="0"><?php echo $text_percentage; ?></option>
                <option value="1" selected="selected"><?php echo $text_fixed_discount; ?></option>
                <option value="2"><?php echo $text_fixed_price; ?></option>
                <?php } elseif ($discount_type == '2') { ?>
                <option value="0"><?php echo $text_percentage; ?></option>
                <option value="1"><?php echo $text_fixed_discount; ?></option>
                <option value="2" selected="selected"><?php echo $text_fixed_price; ?></option>
                <?php } else { ?>
                <option value="0" selected="selected"><?php echo $text_percentage; ?></option>
                <option value="1"><?php echo $text_fixed_discount; ?></option>
                <option value="2"><?php echo $text_fixed_price; ?></option>
                <?php } ?>
              </select></td>
          </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $manufacturerEntry_discount; ?></td>
            <td><input type="text" name="discount" value="<?php echo $discount; ?>" id="discount" />
              <?php if ($error_discount) { ?>
              <span class="error"><?php echo $error_discount; ?></span>
              <?php } ?></td>
          </tr>
          <tr>
            <td><?php echo $manufacturerEntry_date_start; ?></td>
            <td><input type="text" name="date_start" value="<?php echo $date_start; ?>" class="date" /></td>
          </tr>
          <tr>
            <td><?php echo $manufacturerEntry_date_end; ?></td>
            <td><input type="text" name="date_end" value="<?php echo $date_end; ?>" class="date" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<script type="text/javascript"><!--
$(document).ready(function() {
	$('.date').datepicker({dateFormat: 'yy-mm-dd'});
});
//--></script>
<?php echo $footer; ?>