<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/product.png" alt="" /> <?php echo $heading_title; ?></h1>
    <div class="buttons"><a onclick="$('#form').submit();" class="button"><span><?php echo $button_save; ?></span></a><a onclick="location = '<?php echo $cancel; ?>';" class="button"><span><?php echo $button_cancel; ?></span></a></div>
  </div>
  <div class="content">
    <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
      <table class="form">
        <tr>
          <td><span class="required">*</span> <?php echo $productEntry_products; ?></td>
          <td>
          	<?php if ($update) { ?>
          	<?php echo $product_name; ?>
          	<input type="hidden" name="special_manager_product[]" value="<?php echo $special_manager_product; ?>" />
            <?php } else { ?>
            <table>
              <tr>
                <td style="padding: 0;" colspan="3"><select id="category" style="margin-bottom: 5px;" onchange="getProducts();">
                    <?php foreach ($categories as $category) { ?>
                    <option value="<?php echo $category['category_id']; ?>"><?php echo $category['name']; ?></option>
                    <?php } ?>
                  </select></td>
              </tr>
              <tr>
                <td style="padding: 0;"><select multiple="multiple" id="product" size="10" style="width: 200px;">
                  </select></td>
                <td style="vertical-align: middle;"><input type="button" value="--&gt;" onclick="addProduct();" />
                  <br />
                  <input type="button" value="&lt;--" onclick="removeProduct();" /></td>
                <td style="padding: 0;"><select multiple="multiple" id="special_manager" size="10" style="width: 200px;">
                  </select>
                  <?php if ($error_products) { ?>
                  <span class="error"><?php echo $error_products; ?></span>
            	  <?php } ?></td>
              </tr>
            </table>
            <div id="special_manager_product">
              <?php
              	if (strpos($special_manager_product,",")) { 
              		$special_manager_products = explode(",",$special_manager_product);
              	} else {
              		$special_manager_products = array($special_manager_product);
              	} 
              ?>
              <?php foreach ($special_manager_products as $product_id) { ?>
              <input type="hidden" name="special_manager_product[]" value="<?php echo $product_id; ?>" />
              <?php } ?>
            </div>
            <?php } ?>
          </td>
        </tr>
        <tr>
          <td><span class="required">*</span> <?php echo $productEntry_customer_group; ?></td>
          <td><select name="customer_group_id">
              <?php foreach ($customer_groups as $customer_group) { ?>
              <?php if ($customer_group['customer_group_id'] == $customer_group_id) { ?>
              <option value="<?php echo $customer_group['customer_group_id']; ?>" selected="selected"><?php echo $customer_group['name']; ?></option>
              <?php } else { ?>
              <option value="<?php echo $customer_group['customer_group_id']; ?>"><?php echo $customer_group['name']; ?></option>
              <?php } ?>
              <?php } ?>
            </select></td>
	    </tr>
        <tr>
          <td><span class="required">*</span> <?php echo $productEntry_priority; ?></td>
          <td><input type="text" name="priority" value="<?php echo $priority; ?>" size="1" />
          	<?php if ($error_priority) { ?>
            <span class="error"><?php echo $error_priority; ?></span>
            <?php } ?></td>
        </tr>
        <?php if ($update) { ?>
        <tr>
          <td><?php echo $productEntry_price; ?></td>
          <td><span style="text-decoration: line-through;"><?php echo $price; ?></span> <span style="color: #F00;"><?php echo $special; ?></span> (<?php echo $text_discount;?>)</td>
        </tr>
        <tr>
          <td><?php echo $productEntry_price_new; ?></td>
          <td><span style="color: #F00;" id="price"><?php echo $special_value; ?></span>
          	<input type="hidden" name="new_price" value="<?php echo $special_value; ?>" id="new_price" />
          </td>
        </tr>
        <?php } ?>
        <tr>
          <td><span class="required">*</span> <?php echo $productEntry_discount_type; ?></td>
          <td><select name="discount_type" id="discount_type">
              <?php if ($discount_type == '1') { ?>
              <option value="0"><?php echo $text_percentage; ?></option>
              <option value="1" selected="selected"><?php echo $text_fixed_discount; ?></option>
              <option value="2"><?php echo $text_fixed_price; ?></option>
              <?php } elseif ($discount_type == '2') { ?>
              <option value="0"><?php echo $text_percentage; ?></option>
              <option value="1"><?php echo $text_fixed_discount; ?></option>
              <option value="2" selected="selected"><?php echo $text_fixed_price; ?></option>
              <?php } else { ?>
              <option value="0" selected="selected"><?php echo $text_percentage; ?></option>
              <option value="1"><?php echo $text_fixed_discount; ?></option>
              <option value="2"><?php echo $text_fixed_price; ?></option>
              <?php } ?>
            </select></td>
        </tr>
        <tr>
          <td><span class="required">*</span> <?php echo $productEntry_discount; ?></td>
          <td><input type="text" name="discount" value="<?php echo $discount; ?>" id="discount" />
            <?php if ($error_discount) { ?>
            <span class="error"><?php echo $error_discount; ?></span>
            <?php } ?></td>
        </tr>
        <tr>
          <td><?php echo $productEntry_date_start; ?></td>
          <td><input type="text" name="date_start" value="<?php echo $date_start; ?>" class="date" /></td>
        </tr>
        <tr>
          <td><?php echo $productEntry_date_end; ?></td>
          <td><input type="text" name="date_end" value="<?php echo $date_end; ?>" class="date" /></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<script type="text/javascript"><!--
$(document).ready(function() {
	$('.date').datepicker({dateFormat: 'yy-mm-dd'});
});
//--></script>
<script type="text/javascript"><!--
$(document).ready(function() {	
	var price = '<?php echo $price_value;?>';

	function updatePrice() {
		var index = $('#discount_type').attr("selectedIndex");
		if (index == "1") {
			var value = price - $('#discount').val();
		} else if (index == "2") {
			var value = $('#discount').val();
		} else {
			var value = (1-($('#discount').val() / 100))*price;
		}
		value = Number(value).toFixed(2);
		$('#price').html(value);
		$('#new_price').val(value);
	}
	
	$('#discount').keyup(updatePrice);

	$('#discount_type').change(updatePrice);
	
});
//--></script>
<script type="text/javascript"><!--
function addProduct() {
	$('#product :selected').each(function() {
		$(this).remove();
		
		$('#special_manager option[value=\'' + $(this).attr('value') + '\']').remove();
		
		$('#special_manager').append('<option value="' + $(this).attr('value') + '">' + $(this).text() + '</option>');
		
		$('#special_manager_product input[value=\'' + $(this).attr('value') + '\']').remove();
		
		$('#special_manager_product').append('<input type="hidden" name="special_manager_product[]" value="' + $(this).attr('value') + '" />');
	});
}

function removeProduct() {
	$('#special_manager :selected').each(function() {
		$(this).remove();
		
		$('#special_manager_product input[value=\'' + $(this).attr('value') + '\']').remove();
	});
}

function getProducts() {
	$('#product option').remove();
	
	$.ajax({
		url: 'index.php?route=catalog/special_manager/category&token=<?php echo $token; ?>&category_id=' + $('#category').attr('value'),
		dataType: 'json',
		success: function(data) {
			for (i = 0; i < data.length; i++) {
	 			$('#product').append('<option value="' + data[i]['product_id'] + '">' + data[i]['name'] + '</option>');
			}
		}
	});
}

function getProduct() {
	$('#special_manager option').remove();
	
	$.ajax({
		url: 'index.php?route=catalog/special_manager/product&token=<?php echo $token; ?>',
		type: 'POST',
		dataType: 'json',
		data: $('#special_manager_product input'),
		success: function(data) {
			$('#special_manager_product input').remove();
			
			for (i = 0; i < data.length; i++) {
	 			$('#special_manager').append('<option value="' + data[i]['product_id'] + '">' + data[i]['name'] + '</option>');
				
				$('#special_manager_product').append('<input type="hidden" name="special_manager_product[]" value="' + data[i]['product_id'] + '" />');
			} 
		}
	});
}

getProducts();
getProduct();
//--></script>
<?php echo $footer; ?>