<?php echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="<?php echo $direction; ?>" lang="<?php echo $language; ?>" xml:lang="<?php echo $language; ?>">
<head>
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<link rel="stylesheet" type="text/css" href="view/stylesheet/label.css" />
</head>
<body>
	<?php foreach ($orders as $order) { ?>
		<div style="page-break-after: always;">
		
			<?php $weighttot = 0; ?>
			<?php foreach ($order['product'] as $product) { ?>
				<?php 
					$prodweight= ($product['weight']*$product['quantity']); 
					$weighttot= ($weighttot + $prodweight); 		
				?>
			<?php } ?>
			<?php $weighttot=	$this->weight->format($weighttot, $this->config->get('config_weight_class_id')); ;?>
			
			<table class="label">
				<thead>
					<tr>
						<td width="49%">
							From
						</td>
						<td class="spacer" width="2%"></td>
						<td width="49%">To</td>
							</tr>
				</thead>
				<tbody>
					<tr>
						<td class="upper">
							<?php echo $order['payment_address']; ?>
						</td>
						<td class="spacer">&nbsp;</td>
						<td class="upper"><?php echo $order['shipping_address']; ?><br />
						<?php echo $order['comment'] ;?></td>
					</tr>
					<tr>
				  		<td class="detail" width="49%">
					  		<table width="100%">
					  			<tr>
					  				<td width="50%"><strong>Phone:</strong><br /><?php echo $order['telephone']; ?></td>
					  				<td width="50%"><strong>Email:</strong><br /><?php echo $order['email']; ?></td>
					  			</tr>
					  			
					  		</table>
				  		</td>
				  		<td class="spacer" width="2%">&nbsp;</td>
				  		<td class="detail"  width="49%">
					  		<table width="100%">
					  			<tr>
					  				<td width="50%">
					  					<strong>Shipping:</strong><br />
					  					<?php echo $order['shipping_method']; ?>
					  				</td>
					  				<td class="last" width="50%"><strong>Weight:</strong><br /><?php echo $weighttot; ?></td>
					  			</tr>
					  		</table>
				  		</td>
				  	</tr>
				</tbody>
			</table>
			
			<small>Print and use the above design as shipping label</small>
			<br />

			<table class="store">
				<tbody>
					<tr>
						<td width="50%">
							<table>
								<tbody>
									<tr>
										<td colspan="2"><h1>Packing Slip</h1></td>
									</tr>
									<tr>
										<td><strong><?php echo $text_date_added; ?></strong></td>
										<td><?php echo $order['date_added']; ?></td>
									</tr>
									<?php if ($order['invoice_no']) { ?>
										<tr>
											<td><strong><?php echo $text_invoice_no; ?></strong></td>
											<td><?php echo $order['invoice_no']; ?></td>
										</tr>
									<?php } ?>
									<tr>
										<td><strong><?php echo $text_order_id; ?></strong></td>
										<td><?php echo $order['order_id']; ?></td>
									</tr>
									<tr>
										<td><strong><?php echo $text_payment_method; ?></strong></td>
										<td class="no-image"><?php echo $order['payment_method']; ?></td>
									</tr>
									<?php if ($order['shipping_method']) { ?>
										<tr>
											<td><strong><?php echo $text_shipping_method; ?></strong></td>
											<td><?php echo $order['shipping_method']; ?></td>
										</tr>
									<?php } ?>
								</tbody>
							</table>
						</td>
						<td width="50%" align="right" >
							&nbsp;
						</td>
					</tr>
				</tbody>
			</table>
			
			<table class="address">
				<thead>
					<tr>
						<td width="50%"><b>From</b></td>
						<td width="50%"><b>Ship To</span></b></td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td class="upper">
							<?php echo $order['payment_address']; ?>
						</td>
						<td class="upper"><?php echo $order['shipping_address']; ?></td>
					</tr>
				</tbody>
			</table>
				
			<table class="product">
				<thead>
					<tr>
						<td><?php echo $column_product; ?></td>
						<td><?php echo $column_model; ?></td>
						<td align="right"><?php echo $column_quantity; ?></td>
						<td width="20%" align="right"><?php echo $column_weight; ?></td>
						<td width="20%" align="right"><?php echo $column_weighttotal; ?></td>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($order['product'] as $product) { ?>
						<?php 
							$prodweight= ($product['weight']*$product['quantity']);
							$prodweight= $this->weight->format($prodweight,$this->config->get('config_weight_class_id'), $this->language->get('decimal_point'), $this->language->get('thousand_point'));
						?>
						<tr>
							<td><?php echo $product['name']; ?>
								<?php foreach ($product['option'] as $option) { ?><br />
									&nbsp;<small> - <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
								<?php } ?>
							</td>
							<td><?php echo $product['model']; ?></td>
							<td align="right"><?php echo $product['quantity']; ?></td>
							<td align="right">
								<?php echo $product['weight'] ?>
							</td>
							<td align="right">	
								<?php echo $prodweight; ?>
							</td>
						</tr>
					<?php } ?>
					<?php foreach ($order['voucher'] as $voucher) { ?>
						<tr>
							<td><?php echo $voucher['description']; ?></td>
							<td colspan="3"></td>
							<td align="right"><?php echo $voucher['amount']; ?></td>
						</tr>		
					<?php } ?>
					<tr>
						<td colspan="5" class="right">
							<h3><?php echo $text_weightgrandtotal ?>:&nbsp;&nbsp;&nbsp;<?php echo $weighttot ?></h3>
						</td>
					</tr>
				</tbody>
			</table>
			
			<table class="footer">
				<tr>
					<td>

							<?php if($invoice_note) {?>
								<?php echo $invoice_note; ?>
							<?php } else { ?>
								<p>"Thank you for shopping with us... Hope to see you soon..."</p>
							<?php } ?>

					</td>
				</tr>
			</table>
	
		</div>
	<?php } ?>
</body>
</html>