<?php
class ControllerCommonFooter extends Controller {
	protected function index() {
		$this->language->load('common/footer');

		$this->data['text_information'] = $this->language->get('text_information');
		$this->data['text_service'] = $this->language->get('text_service');
		$this->data['text_extra'] = $this->language->get('text_extra');
		$this->data['text_contact'] = $this->language->get('text_contact');
		$this->data['text_return'] = $this->language->get('text_return');
    	$this->data['text_sitemap'] = $this->language->get('text_sitemap');
		$this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
		$this->data['text_voucher'] = $this->language->get('text_voucher');
		$this->data['text_affiliate'] = $this->language->get('text_affiliate');
		$this->data['text_special'] = $this->language->get('text_special');
		$this->data['text_account'] = $this->language->get('text_account');
		$this->data['text_order'] = $this->language->get('text_order');
		$this->data['text_wishlist'] = $this->language->get('text_wishlist');
		$this->data['text_newsletter'] = $this->language->get('text_newsletter');
		$this->data['text_news_update'] = $this->language->get('text_news_update');
		$this->data['text_connect'] = $this->language->get('text_connect');

		$this->load->model('catalog/information');

		$this->data['informations'] = array();

		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$this->data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
    	}

		$this->data['contact'] = $this->url->link('information/contact');
		$this->data['return'] = $this->url->link('account/return/insert', '', 'SSL');
    	$this->data['sitemap'] = $this->url->link('information/sitemap');
		$this->data['manufacturer'] = $this->url->link('product/manufacturer');
		$this->data['voucher'] = $this->url->link('account/voucher', '', 'SSL');
		$this->data['affiliate'] = $this->url->link('affiliate/account', '', 'SSL');
		$this->data['special'] = $this->url->link('product/special');
		$this->data['account'] = $this->url->link('account/account', '', 'SSL');
		$this->data['order'] = $this->url->link('account/order', '', 'SSL');
		$this->data['wishlist'] = $this->url->link('account/wishlist', '', 'SSL');
		$this->data['newsletter'] = $this->url->link('account/newsletter', '', 'SSL');
		//Bukatoko
		$this->data['phone']           	= $this->config->get('config_telephone');
		$this->data['name'] = $this->config->get('config_name');
		$this->data['facebook'] = $this->config->get('config_facebook');
		$this->data['twitter'] = $this->config->get('config_twitter');
		$this->data['pinterest'] = $this->config->get('config_pinterest');
		$this->data['instagram'] = $this->config->get('config_instagram');
		$this->data['googleplus'] = $this->config->get('config_googleplus');

		$this->data['text_blog'] = $this->language->get('text_blog');
		$this->data['text_about_us'] = $this->language->get('text_about_us');
		$this->data['text_faqs'] = $this->language->get('text_faqs');
		$this->data['text_gift_cards'] = $this->language->get('text_gift_cards');
		$this->data['text_bukatoko'] = $this->language->get('text_bukatoko');

		$this->data['about_us']                 = $this->url->link('information/information&information_id=4');

		$this->data['gift_cards']                 = $this->url->link('account/voucher', '', 'SSL');
		$this->data['faqs']                       = $this->url->link('information/information&information_id=9');
		$this->data['blog']                       = $this->url->link('blog/category/home');
		$this->data['config_display_brand_footer']       = $this->config->get('config_display_brand_footer');
		// End

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = HTTPS_IMAGE;
		} else {
			$server = HTTP_IMAGE;
		}
		if ($this->config->get('config_bank_1') && file_exists(DIR_IMAGE . $this->config->get('config_bank_1'))) {
			$this->data['bank_1'] = $server . $this->config->get('config_bank_1');
		} else {
			$this->data['bank_1'] = '';
		}
		if ($this->config->get('config_bank_2') && file_exists(DIR_IMAGE . $this->config->get('config_bank_2'))) {
			$this->data['bank_2'] = $server . $this->config->get('config_bank_2');
		} else {
			$this->data['bank_2'] = '';
		}
		if ($this->config->get('config_bank_3') && file_exists(DIR_IMAGE . $this->config->get('config_bank_3'))) {
			$this->data['bank_3'] = $server . $this->config->get('config_bank_3');
		} else {
			$this->data['bank_3'] = '';
		}
		if ($this->config->get('config_bank_4') && file_exists(DIR_IMAGE . $this->config->get('config_bank_4'))) {
			$this->data['bank_4'] = $server . $this->config->get('config_bank_4');
		} else {
			$this->data['bank_4'] = '';
		}
		if ($this->config->get('config_bank_5') && file_exists(DIR_IMAGE . $this->config->get('config_bank_5'))) {
			$this->data['bank_5'] = $server . $this->config->get('config_bank_5');
		} else {
			$this->data['bank_5'] = '';
		}


		$this->data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('config_name'), date('Y', time()));

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/footer.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/footer.tpl';
		} else {
			$this->template = 'default/template/common/footer.tpl';
		}

		$this->render();
	}
}
?>