<?php
class ControllerCommonHeader extends Controller {
	protected function index() {
		$this->data['title'] = $this->document->getTitle();

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$this->data['base'] = $this->config->get('config_ssl');
		} else {
			$this->data['base'] = $this->config->get('config_url');
		}

		$this->data['description']        = $this->document->getDescription();
		$this->data['keywords']           = $this->document->getKeywords();
		$this->data['links']              = $this->document->getLinks();
		$this->data['styles']             = $this->document->getStyles();
		$this->data['scripts']            = $this->document->getScripts();
		$this->data['lang']               = $this->language->get('code');
		$this->data['direction']          = $this->language->get('direction');
		$this->data['google_analytics']   = html_entity_decode($this->config->get('config_google_analytics'), ENT_QUOTES, 'UTF-8');



		// Whos Online
		if ($this->config->get('config_customer_online')) {
			$this->load->model('tool/online');

			if (isset($this->request->server['REMOTE_ADDR'])) {
				$ip = $this->request->server['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
				$url = 'http://' . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
			} else {
				$url = '';
			}

			if (isset($this->request->server['HTTP_REFERER'])) {
				$referer = $this->request->server['HTTP_REFERER'];
			} else {
				$referer = '';
			}

			$this->model_tool_online->whosonline($ip, $this->customer->getId(), $url, $referer);
		}

		$this->language->load('common/header');

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = HTTPS_IMAGE;
		} else {
			$server = HTTP_IMAGE;
		}

		if ($this->config->get('config_icon') && file_exists(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->data['icon'] = $server . $this->config->get('config_icon');
		} else {
			$this->data['icon'] = '';
		}

		$this->data['name'] = $this->config->get('config_name');

		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
			$this->data['logo'] = $server . $this->config->get('config_logo');
		} else {
			$this->data['logo'] = '';
		}

		$this->data['text_home']                      = $this->language->get('text_home');
		$this->data['text_wishlist']              = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		$this->data['text_shopping_cart']         = $this->language->get('text_shopping_cart');
		$this->data['text_cart']         = $this->language->get('text_cart');
    	$this->data['text_search']             = $this->language->get('text_search');
		$this->data['text_welcome']               = sprintf($this->language->get('text_welcome'), $this->url->link('account/login', '', 'SSL'), $this->url->link('account/register', '', 'SSL'));
		$this->data['text_logged']                = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', 'SSL'), $this->customer->getFirstName(), $this->url->link('account/logout', '', 'SSL'));
		$this->data['text_account']               = $this->language->get('text_account');
    $this->data['text_checkout']            = $this->language->get('text_checkout');
    $this->data['text_login']               = $this->language->get('text_login');
    $this->data['text_register']            = $this->language->get('text_register');

    	//Bukatoko
    	$this->data['text_livechat']           = $this->language->get('text_livechat');
    	$this->data['phone']                   = $this->config->get('config_telephone');
    	$this->data['blackberry']              = $this->config->get('config_blackberry');
    	$this->data['email']              = $this->config->get('config_email');
		$this->data['text_yahoo_1']               = $this->config->get('config_yahoo_1');
		$this->data['text_yahoo_2']               = $this->config->get('config_yahoo_2');
		$this->data['text_yahoo_3']               = $this->config->get('config_yahoo_3');
		$this->data['text_new_arrivals']          = $this->language->get('text_new_arrivals');
		$this->data['text_sale']                  = $this->language->get('text_sale');
		$this->data['text_payment_confirmation']  = $this->language->get('text_payment_confirmation');
		$this->data['text_call']                  = $this->language->get('text_call');
		$this->data['text_how_to_order']          = $this->language->get('text_how_to_order');
		$this->data['text_blog']                  = $this->language->get('text_blog');
		$this->data['blog']                       = $this->url->link('blog/category/home');

		$this->data['login']                      = $this->url->link('account/login', '', 'SSL');
		$this->data['register']                   = $this->url->link('account/register', '', 'SSL');
		$this->data['home']                       = $this->url->link('common/home');
		$this->data['wishlist']                   = $this->url->link('account/wishlist', '', 'SSL');
		$this->data['logged']                     = $this->customer->isLogged();
		$this->data['account']                    = $this->url->link('account/account', '', 'SSL');
		$this->data['shopping_cart']              = $this->url->link('checkout/cart');
		$this->data['checkout']                   = $this->url->link('checkout/simplecheckout', '', 'SSL');
		$this->data['new_arrivals']               = $this->url->link('product/new_arrivals');
		$this->data['sale']                       = $this->url->link('product/special');
		$this->data['how_to_order']               = $this->url->link('information/information&information_id=7');
		$this->data['payment_confirmation']       = $this->url->link('information/payment_confirmation');
		$this->data['text_manufacturer']          = $this->language->get('text_manufacturer');
		$this->data['manufacturer']               = $this->url->link('product/manufacturer');
		
		
		// Themes
		if ($this->config->get('config_themes_bg_img') && file_exists(DIR_IMAGE . $this->config->get('config_themes_bg_img'))) {
			$this->data['themes_bg_img'] = $server . $this->config->get('config_themes_bg_img');
		} else {
			$this->data['themes_bg_img'] = '';
		}
		$this->data['themes_bg_position_x']       = $this->config->get('config_themes_bg_positon_x');
		$this->data['themes_bg_position_y']       = $this->config->get('config_themes_bg_positon_y');
		$this->data['themes_bg_repeat']       = $this->config->get('config_themes_bg_repeat');
		$this->data['themes_bg_color']       = $this->config->get('config_themes_bg_color');
		$this->data['themes_content_bg_color']       = $this->config->get('config_content_bg_color');

		$this->data['config_display_home']       = $this->config->get('config_display_home');
		$this->data['config_display_new_arrivals']       = $this->config->get('config_display_new_arrivals');
		$this->data['config_display_brand']       = $this->config->get('config_display_brand');
		$this->data['config_display_brand_footer']       = $this->config->get('config_display_brand_footer');

		if (isset($this->request->get['filter_name'])) {
			$this->data['filter_name'] = $this->request->get['filter_name'];
		} else {
			$this->data['filter_name'] = '';
		}

$current_path = $this->request->get;
if (empty($current_path) || $current_path['route'] == 'common/home') {
  $body_class = 'home';
}
else {
  $body_class = explode('/', str_replace('product/', '', $current_path['route']));
  unset($current_path['route']);
  if (isset($current_path['_route_'])) {
    $body_class = array_merge($body_class, explode('/', str_replace('-', '_', $current_path['_route_'])));
    unset($current_path['_route_']);
  }
  foreach ($current_path as $key => $value) {
    $body_class[] = $key . "_" . $value;
  }
  $body_class = 'page_' . implode(" page_", array_unique($body_class));
}
$body_class .= ' lang_' . $this->language->get('code');
$this->data['body_class'] = $body_class;


		// Menu
		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->data['categories'] = array();

		// 18 Dec 12 at 21:55
		$this->data['specials'] = $this->model_catalog_product->getProductSpecials(0);

		$categories = $this->model_catalog_category->getCategories(0);

		foreach ($categories as $category) {
			if ($category['top']) {
				$children_data = array();

				$children = $this->model_catalog_category->getCategories($category['category_id']);

				foreach ($children as $child) {
					$data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);

					$product_total = $this->model_catalog_product->getTotalProducts($data);

					$children_data[] = array(
						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $product_total . ')' : ''),
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])
					);
				}

				// Level 1
				$this->data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])
				);
			}
		}

		$this->children = array(
			'module/language',
			'module/currency',
			'module/cart',
			'common/column_left',
			'common/banner_top'
		);

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/header.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/header.tpl';
		} else {
			$this->template = 'default/template/common/header.tpl';
		}

    	$this->render();
	}
}
?>