<?php
//==============================================================================
// MailChimp Integration v154.3
//
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
//==============================================================================

class ControllerModuleMailchimpIntegration extends Controller {
	private $type = 'module';
	private $name = 'mailchimp_integration';
	private $module;

	protected function index($module = '') {
		$v14x = $this->data['v14x'] = (!defined('VERSION') || VERSION < 1.5);
		$v150 = $this->data['v150'] = (defined('VERSION') && strpos(VERSION, '1.5.0') === 0);
		$settings = $this->data['settings'] = ($v14x || $v150) ? unserialize($this->config->get($this->name . '_data')) : $this->config->get($this->name . '_data');

		if (empty($settings['status']) || empty($settings['apikey']) || empty($settings['listid'])) return;

		$type = $this->data['type'] = $this->type;
		$name = $this->data['name'] = $this->name;

		$this->data['text_facebook']       = $this->config->get('config_facebook');
		$this->data['text_twitter']       = $this->config->get('config_twitter');
		$this->data['text_pinterest']       = $this->config->get('config_pinterest');

		$this->module = $module;
		$this->data = array_merge($this->data, $this->load->language($this->type . '/' . $this->name));

		$this->data['position'] = $this->getModuleSetting('position');
		$this->data['name_field'] = $this->getModuleSetting('name_field');

		$template = (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/' . $this->type . '/' . $this->name . '.tpl')) ? $this->config->get('config_template') : 'default';
		$this->template = $template . '/template/' . $this->type . '/' . $this->name . '.tpl';
		$this->id = $this->name;
		$this->render();
	}

	private function getModuleSetting($setting) {
		if (!defined('VERSION') || VERSION < 1.5) {
			$value = $this->config->get($this->name . '_' . $setting);
		} elseif (strpos(VERSION, '1.5.0') === 0) {
			$value = $this->config->get($this->name . '_' . $this->module . '_' . $setting);
		} else {
			$value = (!empty($this->module[$setting])) ? $this->module[$setting] : false;
		}
		return (is_string($value) && strpos($value, 'a:') === 0) ? unserialize($value) : $value;
	}

	private function makeURL($route, $args = '', $connection = 'NONSSL', $rewrite = true) {
		if (!defined('VERSION') || VERSION < 1.5 || !$rewrite) {
			$url = ($connection == 'NONSSL') ? HTTP_SERVER : HTTPS_SERVER;
			$url .= 'index.php?route=' . $route;
			$url .= ($args) ? '&' . ltrim($args, '&') : '';
			if ($rewrite) {
				$this->load->model('tool/seo_url');
				$url = $this->model_tool_seo_url->rewrite($url);
			}
			return $url;
		} else {
			return $this->url->link($route, $args, $connection);
		}
	}

	public function subscribe() {
		$firstlast = explode(' ', $this->request->post['name'], 2);
		$data = array(
			'newsletter'	=> 1,
			'email'			=> $this->request->post['email'],
			'firstname'		=> $firstlast[0],
			'lastname'		=> isset($firstlast[1]) ? $firstlast[1] : ''
		);
		$this->load->model('module/mailchimp_integration');
		echo $this->model_module_mailchimp_integration->send($data);
	}

	public function webhook() {
		if (!isset($this->request->post['type']) || !isset($this->request->post['data']) || !isset($this->request->get['code'])) return;

		$v14x = $this->data['v14x'] = (!defined('VERSION') || VERSION < 1.5);
		$v150 = $this->data['v150'] = (defined('VERSION') && strpos(VERSION, '1.5.0') === 0);
		$settings = ($v14x || $v150) ? unserialize($this->config->get($this->name . '_data')) : $this->config->get($this->name . '_data');

		$type = $this->request->post['type'];
		$data = $this->request->post['data'];
		$webhooks = $settings['webhooks'];

		if ($this->request->get['code'] != $settings['urlcode']) {
			if ($settings['logerrors']) {
				$this->log->write(strtoupper($this->name) . ' WEBHOOK ERROR: webhook URL code ' . $this->request->get['code'] . ' does not match the extension code ' . $settings['urlcode'] . ' for action "' . $type . '" for e-mail address ' . $data['email']);
			}
			return;
		}

		if ($data['list_id'] != $settings['listid']) {
			if ($settings['logerrors']) {
				$this->log->write(strtoupper($this->name) . ' WEBHOOK ERROR: webhook List ID ' . $data['list_id'] . ' does not match the extension List ID ' . $settings['listid'] . ' for action "' . $type . '" for e-mail address ' . $data['email']);
			}
			return;
		}

		$success = false;
		$data_fname = (!empty($data['merges'][$settings['fname']])) ? $data['merges'][$settings['fname']] : '';
		$data_lname = (!empty($data['merges'][$settings['lname']])) ? $data['merges'][$settings['lname']] : '';
		$data_phone = (!empty($data['merges'][$settings['phone']])) ? $data['merges'][$settings['phone']] : '';
		$data_address = (!empty($data['merges'][$settings['address']])) ? $data['merges'][$settings['address']] : '';
		$data_address['country'] = (!empty($data_address['country'])) ? $data_address['country'] : 0;
		$data_address['state'] = (!empty($data_address['state'])) ? $data_address['state'] : 0;

		if ($type == 'subscribe' && $webhooks['subscribe']) {
			if ($settings['autocreate']) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE email = '" . $this->db->escape($data['email']) . "'");
				if (!$query->num_rows) {
					$sql = "INSERT INTO " . DB_PREFIX . "customer SET";
					$sql .= " status = '0',";
					$sql .= " approved = '1',";
					$sql .= " newsletter = '1',";
					$sql .= " customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "',";
					$sql .= " email = '" . $this->db->escape($data['email']) . "',";
					$sql .= " firstname = '" . $this->db->escape($data_fname) . "',";
					$sql .= " lastname = '" . $this->db->escape($data_lname) . "',";
					$sql .= " telephone = '" . $this->db->escape($data_phone) . "',";
					$sql .= " ip = '" . $this->db->escape($data['ip_opt']) . "',";
					$sql .= " password = '" . $this->db->escape(md5(rand())) . "',";
					$sql .= " date_added = NOW()";
					$this->db->query($sql);

					$customer_id = $this->db->getLastId();
					$country = $this->db->query("SELECT * FROM " . DB_PREFIX . "country WHERE iso_code_2 = '" . $this->db->escape($data_address['country']) . "'");
					$zone = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE (`name` = '" . $this->db->escape($data_address['state']) . "' OR `code` = '" . $this->db->escape($data_address['state']) . "') AND country_id = '" . $this->db->escape($country->row['country_id']) . "'");

					$sql = "INSERT INTO " . DB_PREFIX . "address SET";
					$sql .= " customer_id = '" . (int)$customer_id . "',";
					$sql .= " firstname = '" . $this->db->escape($data_fname) . "',";
					$sql .= " lastname = '" . $this->db->escape($data_lname) . "',";
					$sql .= " address_1 = '" . $this->db->escape($data_address['addr1']) . "',";
					$sql .= " address_2 = '" . $this->db->escape($data_address['addr2']) . "',";
					$sql .= " city = '" . $this->db->escape($data_address['city']) . "',";
					$sql .= " zone_id = '" . (empty($zone) ? 0 : $this->db->escape($zone->row['zone_id'])) . "',";
					$sql .= " postcode = '" . $this->db->escape($data_address['zip']) . "',";
					$sql .= " country_id = '" . (empty($country) ? 0 : $this->db->escape($country->row['country_id'])) . "'";
					$this->db->query($sql);

					$address_id = $this->db->getLastId();
					$this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int)$address_id . "' WHERE customer_id = '" . (int)$customer_id . "'");

					if ($settings['logerrors']) {
						$this->log->write(strtoupper($this->name) . ' CUSTOMER CREATED: ' . $data_fname . ' ' . $data_lname . ' (' . $data['email'] . ')');
					}
				}
			}
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET newsletter = '1' WHERE email = '" . $this->db->escape($data['email']) . "'");
			$success = true;
		} elseif (($type == 'unsubscribe' && $webhooks['unsubscribe']) || ($type == 'cleaned' && $webhooks['cleaned'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET newsletter = '0' WHERE email = '" . $this->db->escape($data['email']) . "'");
			$success = true;
		} elseif ($type == 'profile' && $webhooks['profile']) {
			$customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE email = '" . $this->db->escape($data['email']) . "'");
			if (empty($customer->row['address_id'])) {
				$this->log->write('not updating address_id ' . $customer->row['address_id']);
				return;
			}
			if ($data_fname) {
				$this->db->query("UPDATE " . DB_PREFIX . "customer SET firstname = '" . $this->db->escape($data_fname) . "' WHERE email = '" . $this->db->escape($data['email']) . "'");
				$this->db->query("UPDATE " . DB_PREFIX . "address SET firstname = '" . $this->db->escape($data_fname) . "' WHERE address_id = '" . $this->db->escape($customer->row['address_id']) . "'");
			}
			if ($data_lname) {
				$this->db->query("UPDATE " . DB_PREFIX . "customer SET lastname = '" . $this->db->escape($data_lname) . "' WHERE email = '" . $this->db->escape($data['email']) . "'");
				$this->db->query("UPDATE " . DB_PREFIX . "address SET lastname = '" . $this->db->escape($data_lname) . "' WHERE address_id = '" . $this->db->escape($customer->row['address_id']) . "'");
			}
			if ($data_address) {
				$country = $this->db->query("SELECT * FROM " . DB_PREFIX . "country WHERE iso_code_2 = '" . $this->db->escape($data_address['country']) . "'");
				$zone = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE (`name` = '" . $this->db->escape($data_address['state']) . "' OR `code` = '" . $this->db->escape($data_address['state']) . "') AND country_id = '" . $this->db->escape($country->row['country_id']) . "'");

				$sql = "UPDATE " . DB_PREFIX . "address SET";
				$sql .= " address_1 = '" . $this->db->escape($data_address['addr1']) . "',";
				$sql .= " address_2 = '" . $this->db->escape($data_address['addr2']) . "',";
				$sql .= " city = '" . $this->db->escape($data_address['city']) . "',";
				$sql .= " zone_id = '" . (empty($zone) ? 0 : $this->db->escape($zone->row['zone_id'])) . "',";
				$sql .= " postcode = '" . $this->db->escape($data_address['zip']) . "',";
				$sql .= " country_id = '" . (empty($country) ? 0 : $this->db->escape($country->row['country_id'])) . "'";
				$sql .= " WHERE address_id = '" . $this->db->escape($customer->row['address_id']) . "'";

				$this->db->query($sql);
			}
			if ($data_phone) {
				$this->db->query("UPDATE " . DB_PREFIX . "customer SET telephone = '" . $this->db->escape($data_phone) . "' WHERE email = '" . $this->db->escape($data['email']) . "'");
			}
			$success = true;
		} elseif ($type == 'upemail' && $webhooks['profile']) {
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET email = '" . $this->db->escape($data['new_email']) . "' WHERE email = '" . $this->db->escape($data['old_email']) . "'");
		}

		if ($settings['logerrors'] && $success) {
			$this->log->write(strtoupper($this->name) . ' WEBHOOK SUCCESS: ' . $type . ' ' . $data['email'] . ' (List ID ' . $data['list_id'] . ')');
		}
	}
}
?>