//@codekit-prepend "jquery.min.js";
//@codekit-append "jquery.flexslider-min.js";

$(document).ready(function() {

  // bind change event to select
  $('#iphone-menu select').bind('change', function () {
    var url = $(this).val(); // get selected value
    if (url) { // require a URL
      window.location = url; // redirect
    }
    return false;
  });

  $('.flexslider').flexslider({
    controlNav: false,
    directionNav: false,
    animation: "slide",
    easing: "swing",
    direction: "vertical",
    pauseOnHover: true,
  });
  $('.front-flexslider').flexslider({
    controlNav: true,
    directionNav: false,
    animation: "slide",
    easing: "swing",
    direction: "horizontal",
    pauseOnHover: true,
  });

	$('#banner<?php echo $module; ?> img').css('display', 'none');
	$('#banner<?php echo $module; ?> a').css('display', 'none');
	$('#banner<?php echo $module; ?> img:first-child').css('display', 'block');
  var banner = function() {
  	$('#banner<?php echo $module; ?>').cycle({
  		before: function(current, next) {
  			$(next).parent().height($(next).outerHeight());
  		}
  	});
  }
  setTimeout(banner, 2000);



  /* Slideshow */
  $('.carousel').carousel('cycle')
  /* Featured */
  $('#left-sidebar #module-featured .module-content > div').vTicker({
		interval: 5000,
		animation: 'fade',
		mousePause: false,
		items: 2,
		//height: 218
	});
  /* Latest */
  $('#left-sidebar #module-latest .module-content > div').vTicker({
		interval: 5000,
		animation: 'fade',
		mousePause: false,
		items: 2,
		//height: 218
	});
  /* Best Seller */
	$('#left-sidebar #module-bestseller .module-content > div').vTicker({
		interval: 5000,
		animation: 'fade',
		mousePause: false,
		items: 2,
		//height: 218
	});

	/* Live Chat */
	$('#yahoo').hover(function() {
		$('#list-yahoo').slideToggle();
		return false;
	});
	$('#list-yahoo').hover(function() {
		$(this).show();
	});

	/* Option Images */
	$('.option-images img ').bind('click', function() {
		$('.option-images li').removeClass('option-select');
		$(this).parent().parent().parent().addClass('option-select');
		//return false;
	});

	/* Side Nav */
	$('.pilih.accord .accords').slideDown();
	$('#side-menu li').removeClass('up');
	$('a.drop-accord').bind('click', function() {
		$('.accords').not('.pilih.accord .accords').slideUp();
		$(this).siblings('.accords').slideDown();
		$(this).parent().addClass('up');
		return false;
	});

	/* Product Filter */
	$('#sorting .drop-menu').hover(function() {
		$(this).addClass('active');
	},function() {
		$(this).removeClass('active');
	});

	/* Search */
	$('.button-search').bind('click', function() {
		url = $('base').attr('href') + 'index.php?route=product/search';

		var filter_name = $('input[name=\'filter_name\']').attr('value');

		if (filter_name) {
			url += '&filter_name=' + encodeURIComponent(filter_name);
		}

		location = url;
	});

	$('#header-slot input[name=\'filter_name\']').bind('keydown', function(e) {
		if (e.keyCode == 13) {
			url = $('base').attr('href') + 'index.php?route=product/search';

			var filter_name = $('input[name=\'filter_name\']').attr('value');

			if (filter_name) {
				url += '&filter_name=' + encodeURIComponent(filter_name);
			}

			location = url;
		}
	});


	//$('#cart .content').hide();
	//$('#cart .heading').click(function () {
	//	$(this).toggleClass('active');
	//	$('#cart .content').slideToggle();
	//	return false;
	//});

	//$('#cart').hover(function () {
	//	$(this).toggleClass('active');
	//	return false;
	//});


	/* Ajax Cart */
   $('#cart').live('click', function() {
      $(this).addClass('active');

      $(this).load('index.php?route=module/cart #cart > *');

      $(this).live('mouseleave', function() {
         $(this).removeClass('active');
      });
   });

	/* Mega Menu */
	$('#menu ul > li > a + div').each(function(index, element) {
		// IE6 & IE7 Fixes
		if ($.browser.msie && ($.browser.version == 7 || $.browser.version == 6)) {
			var category = $(element).find('a');
			var columns = $(element).find('ul').length;

			$(element).css('width', (columns * 143) + 'px');
			$(element).find('ul').css('float', 'left');
		}

		var menu = $('#menu').offset();
		var dropdown = $(this).parent().offset();

		i = (dropdown.left + $(this).outerWidth()) - (menu.left + $('#menu').outerWidth());

		if (i > 0) {
			$(this).css('margin-left', '-' + (i + 5) + 'px');
		}
	});

	// IE6 & IE7 Fixes
	if ($.browser.msie) {
		if ($.browser.version <= 6) {
			$('#column-left + #column-right + #content, #column-left + #content').css('margin-left', '195px');

			$('#column-right + #content').css('margin-right', '195px');

			$('.box-category ul li a.active + ul').css('display', 'block');
		}

		if ($.browser.version <= 7) {
			$('#menu > ul > li').bind('mouseover', function() {
				$(this).addClass('active');
			});

			$('#menu > ul > li').bind('mouseout', function() {
				$(this).removeClass('active');
			});
		}
	}

	$('.success i, .warning i, .attention i, .information i').live('click', function() {
		$(this).parent().fadeOut('slow', function() {
			$(this).remove();
		});
	});
});

function getURLVar(urlVarName) {
	var urlHalves = String(document.location).toLowerCase().split('?');
	var urlVarValue = '';

	if (urlHalves[1]) {
		var urlVars = urlHalves[1].split('&');

		for (var i = 0; i <= (urlVars.length); i++) {
			if (urlVars[i]) {
				var urlVarPair = urlVars[i].split('=');

				if (urlVarPair[0] && urlVarPair[0] == urlVarName.toLowerCase()) {
					urlVarValue = urlVarPair[1];
				}
			}
		}
	}

	return urlVarValue;
}

function addToCart(product_id, quantity) {
	quantity = typeof(quantity) != 'undefined' ? quantity : 1;

	$.ajax({
		url: 'index.php?route=checkout/cart/add',
		type: 'post',
		data: 'product_id=' + product_id + '&quantity=' + quantity,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information, .error').remove();

			if (json['redirect']) {
				location = json['redirect'];
			}

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#cart-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}
function addToWishList(product_id) {
	$.ajax({
		url: 'index.php?route=account/wishlist/add',
		type: 'post',
		data: 'product_id=' + product_id,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information').remove();

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#wishlist-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}

function addToCompare(product_id) {
	$.ajax({
		url: 'index.php?route=product/compare/add',
		type: 'post',
		data: 'product_id=' + product_id,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information').remove();

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#compare-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}