//@codekit-prepend "jquery-1.7.1.min.js";
//@codekit-prepend "jquery-ui-1.8.16.custom.min.js";
//@codekit-append "jquery-ui-timepicker-addon.js";
//@codekit-append "jquery.flexslider-min.js";
//@codekit-append "jquery.colorbox-min.js";
//@codekit-append "ajaxupload.js";
//@codekit-append "cloud-zoom.1.0.2.min.js";

$(document).ready(function() {

	// Module Category Accordion Style
	$('#module-category.module ul > li i').addClass('icon-down-open-mini');
	$('#module-category.module ul > li > ul').slideUp();
	$('#module-category.module ul > li span').click(function(){
		$(this).parent().siblings('li').children('ul').slideUp();
		$(this).parent().siblings('li').children('span').children('i').removeClass('icon-up-open-mini').addClass('icon-down-open-mini');
		$(this).siblings('ul').slideDown();
		$(this).children('i').removeClass('icon-down-open-mini').addClass('icon-up-open-mini');
	});

	if($('#module-category.module a').hasClass('active')){
		$('#module-category.module li.opened ul').slideDown();
		$('#module-category.module li.opened').children().children('i').removeClass('icon-down-open-mini').addClass('icon-up-open-mini');
	};

	$(".colorbox").colorbox({
		width:"75%",
	});

	$('#product-comment #comment-form').slideUp();
	$('#product-comment a#write-button').click(function() {

	$('#product-comment #comment-form').slideToggle();
	})

	$('#iphone-menu select').bind('change', function () {
    var url = $(this).val(); // get selected value
    if (url) { // require a URL
      window.location = url; // redirect
    }
    return false;
  });

  $('#blog-category.box select').bind('change', function () {
    var url = $(this).val(); // get selected value
    if (url) { // require a URL
      window.location = url; // redirect
    }
    return false;
  });

	/* flexslider */
	$('.front-flexslider').flexslider({
    controlNav: true,
    directionNav: false,
    animation: "slide",
    easing: "swing",
    direction: "horizontal",
    pauseOnHover: true,
  });
  $('.flexslider').flexslider({
    animation: "slide",
    controlNav: false,
    directionNav: true,
  });
  $('.flexslider-fade').flexslider({
    animation: "fade",
    easing: "swing",
    controlNav: true,
    directionNav: true,
  });
  $('.flexslider-vertical').flexslider({
    controlNav: true,
    directionNav: false,
    animation: "slide",
    easing: "swing",
    direction: "vertical",
    pauseOnHover: true,
    slideshowSpeed: 10000,
    animationSpeed: 1000,
  });
  $('.flexslider-horizontal').flexslider({
    controlNav: false,
    directionNav: false,
    animation: "slide",
    easing: "swing",
    pauseOnHover: true,
    slideshowSpeed: 10000,
    animationSpeed: 1000,
  });


	/* Live Chat */
	$('#yahoo').hover(function() {
		$('#list-yahoo').slideToggle();
		return false;
	});
	$('#list-yahoo').hover(function() {
		$(this).show();
	});

	/* Option Images */
	$('.option-images img ').bind('click', function() {
		$('.option-images li').removeClass('option-select');
		$(this).parent().parent().parent().addClass('option-select');
		//return false;
	});

	/* Side Nav */
	$('.pilih.accord .accords').slideDown();
	$('#side-menu li').removeClass('up');
	$('a.drop-accord').bind('click', function() {
		$('.accords').not('.pilih.accord .accords').slideUp();
		$(this).siblings('.accords').slideDown();
		$(this).parent().addClass('up');
		return false;
	});

	/* Product Filter */
	$('#sorting .drop-menu').hover(function() {
		$(this).addClass('active');
	},function() {
		$(this).removeClass('active');
	});

	/* Search */
	$('.button-search').bind('click', function() {
		url = $('base').attr('href') + 'index.php?route=product/search';

		var filter_name = $('input[name=\'filter_name\']').attr('value');

		if (filter_name) {
			url += '&filter_name=' + encodeURIComponent(filter_name);
		}

		location = url;
	});

	$('#header-slot input[name=\'filter_name\']').bind('keydown', function(e) {
		if (e.keyCode == 13) {
			url = $('base').attr('href') + 'index.php?route=product/search';

			var filter_name = $('input[name=\'filter_name\']').attr('value');

			if (filter_name) {
				url += '&filter_name=' + encodeURIComponent(filter_name);
			}

			location = url;
		}
	});

	/* Ajax Cart */
  $('#cart').live('click', function() {
	      $(this).addClass('active');

	      $(this).load('index.php?route=module/cart #cart > *');

	      $(this).live('mouseleave', function() {
	         $(this).removeClass('active');
	      });
	   });

	$('.success i, .warning i, .attention i, .information i').live('click', function() {
		$(this).parent().fadeOut('slow', function() {
			$(this).remove();
		});
	});
});

function getURLVar(urlVarName) {
	var urlHalves = String(document.location).toLowerCase().split('?');
	var urlVarValue = '';

	if (urlHalves[1]) {
		var urlVars = urlHalves[1].split('&');

		for (var i = 0; i <= (urlVars.length); i++) {
			if (urlVars[i]) {
				var urlVarPair = urlVars[i].split('=');

				if (urlVarPair[0] && urlVarPair[0] == urlVarName.toLowerCase()) {
					urlVarValue = urlVarPair[1];
				}
			}
		}
	}

	return urlVarValue;
}
function addToCart(product_id, quantity) {
	quantity = typeof(quantity) != 'undefined' ? quantity : 1;

	$.ajax({
		url: 'index.php?route=checkout/cart/add',
		type: 'post',
		data: 'product_id=' + product_id + '&quantity=' + quantity,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information, .error').remove();

			if (json['redirect']) {
				location = json['redirect'];
			}

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#cart-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}
function addToWishList(product_id) {
	$.ajax({
		url: 'index.php?route=account/wishlist/add',
		type: 'post',
		data: 'product_id=' + product_id,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information').remove();

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#wishlist-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}
function addToCompare(product_id) {
	$.ajax({
		url: 'index.php?route=product/compare/add',
		type: 'post',
		data: 'product_id=' + product_id,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information').remove();

			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<i class="icon-cancel-circled close"></div>');

				$('.success').fadeIn('slow');

				$('#compare-total').html(json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}
		}
	});
}