<?php echo $header; ?>

<!-- /CONTENT SLOT -->
<div id="account-page" class="content-slot">
	<div class="bt-container">

		<!-- /Notification -->
		<div id="notification"></div>

		<div class="bt-row">

			<!-- /Left Sidebar -->
			<div id="left-sidebar">
				<?php echo $column_left; ?>
			</div>

<!-- /Content -->
<div id="content">

	<div class="bt-row">
		<!-- /Breadcrumb -->
		<div id="breadcrumb">
			<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
			<?php } ?>
		</div>
	</div>

	<!-- /Page Header -->
	<div id="page-header">

			<div id="page-title">
				<h1><?php echo $heading_title; ?></h1>
			</div>

	</div>

<div id="order-info">

	<h4 class="sub-page"><?php echo $text_order_detail; ?></h4>
	<div class="bt-row">
		<div class="col-1">
			<?php if ($invoice_no) { ?>
					<small><?php echo $text_invoice_no; ?></small> <?php echo $invoice_no; ?><br />
				<?php } ?>

				<small><?php echo $text_order_id; ?></small> #<?php echo $order_id; ?>
		</div>
		<div class="col-2">
				<small><?php echo $text_date_added; ?></small> <?php echo $date_added; ?>
		</div>
		<div class="col-3">
			<?php if ($payment_method) { ?>
					<small><?php echo $text_payment_method; ?></small> <?php echo $payment_method; ?><br />
				<?php } ?>
	  </div>
	  <div class="col-4">
				<?php if ($shipping_method) { ?>
					<small><?php echo $text_shipping_method; ?></small> <?php echo $shipping_method; ?>
				<?php } ?>
		</div>
	</div>

	<div class="line"></div>

	<div class="bt-row">
		<div class="left">
			<small><?php echo $text_payment_address; ?></small>
			<?php echo $payment_address; ?>
		</div>
		<div class="right">
			<?php if ($shipping_address) { ?>
				<small><?php echo $text_shipping_address; ?></small>
			<?php } ?>
			<?php if ($shipping_address) { ?>
				<?php echo $shipping_address; ?>
			<?php } ?>
		</div>
	</div>

</div>

<br />
<table class="table-order">
	<thead>
		<tr>
			<td class="left-cell"><?php echo $column_name; ?></td>
			<td class="left-cell model"><?php echo $column_model; ?></td>
			<td class="center-cell qty"><?php echo $column_quantity; ?></td>
			<td class="right-cell"><?php echo $column_price; ?></td>
			<td class="right-cell"><?php echo $column_total; ?></td>
			<?php if ($products) { ?>
				<td style="width: 1px;"></td>
			<?php } ?>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($products as $product) { ?>
			<tr>
				<td class="left-cell"><?php echo $product['name']; ?>
					<?php foreach ($product['option'] as $option) { ?>
						<br />
						&nbsp;<small> - <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
					<?php } ?>
				</td>
				<td class="left-cell model"><?php echo $product['model']; ?></td>
				<td class="center-cell qty"><?php echo $product['quantity']; ?></td>
				<td class="right-cell price"><?php echo $product['price']; ?></td>
				<td class="right-cell price"><?php echo $product['total']; ?></td>
				<td class="right-cell action"><a href="<?php echo $product['return']; ?>"><i class="icon-back"></i><span>Return</span></a></td>
			</tr>
		<?php } ?>
		<?php foreach ($vouchers as $voucher) { ?>
			<tr>
				<td class="left-cell voucher"><?php echo $voucher['description']; ?></td>
				<td class="left-cell voucher model"></td>
				<td class="center-cell voucher qty">1</td>
				<td class="right-cell voucher"><?php echo $voucher['amount']; ?></td>
				<td class="right-cell voucher"><?php echo $voucher['amount']; ?></td>
				<?php if ($products) { ?>
					<td></td>
				<?php } ?>
			</tr>
		<?php } ?>
	</tbody>
	<tfoot>
		<?php foreach ($totals as $total) { ?>
			<tr>
				<td colspan="4" class="right-cell"><?php echo $total['title']; ?>:</td>
				<td class="right-cell price"><strong><?php echo $total['text']; ?></strong></td>
				<?php if ($products) { ?>
					<td></td>
				<?php } ?>
			</tr>
		<?php } ?>
	</tfoot>
</table>

<?php if ($comment) { ?>
	<div id="order-comment">
		<strong><?php echo $text_comment; ?></strong><br />
		<?php echo $comment; ?>
	</div>
<?php } ?>

<?php if ($histories) { ?>
	<br />
	<h4 class="sub-page"><?php echo $text_history; ?></h4>
	<table id="order-history">
		<thead>
			<tr>
				<td class="left-cell"><?php echo $column_date_added; ?></td>
				<td class="left-cell"><?php echo $column_status; ?></td>
				<td class="left-cell"><?php echo $column_comment; ?></td>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($histories as $history) { ?>
				<tr>
					<td class="left-cell"><?php echo $history['date_added']; ?></td>
					<td class="left-cell"><?php echo $history['status']; ?></td>
					<td class="left-cell"><?php echo $history['comment']; ?></td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
<?php } ?>

<div class="buttons">
	<a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a>
</div>

	<?php echo $content_bottom; ?>

</div><!-- /End #content -->

		</div><!-- /.bt-row -->
	</div><!-- /.bt-container -->
</div><!-- /#content-slot -->


<?php echo $footer; ?>