<?php echo $header; ?>

<!-- /Content -->
<div id="content">

	<?php if ($error_warning) { ?>
		<div class="warning"><?php echo $error_warning; ?></div>
	<?php } ?>

	<?php echo $content_top; ?>

	<!-- /Breadcrumb -->
	<div id="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
			<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
		<?php } ?>
	</div>

	<!-- /Page Header -->
	<div id="page-header">
		<h1><i class="icon-edit"></i> <?php echo $heading_title; ?></h1>
	</div>

	<div id="registration">

		<div id="register-form">
			<div class="bt-row">

				<div class="left">
					<p><?php echo $text_account_already; ?></p>
					<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
						<legend><?php echo $text_your_details; ?></legend>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_firstname; ?>
							</div>
							<div class="controls">
								<input type="text" name="firstname" value="<?php echo $firstname; ?>" />
										<?php if ($error_firstname) { ?>
											<span class="error"><?php echo $error_firstname; ?></span>
										<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_lastname; ?>
							</div>
							<div class="controls">
								<input type="text" name="lastname" value="<?php echo $lastname; ?>" />
										<?php if ($error_lastname) { ?>
											<span class="error"><?php echo $error_lastname; ?></span>
										<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_email; ?>
							</div>
							<div class="controls">
								<input type="text" name="email" value="<?php echo $email; ?>" />
										<?php if ($error_email) { ?>
											<span class="error"><?php echo $error_email; ?></span>
										<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_telephone; ?>
							</div>
							<div class="controls">
								<input type="text" name="telephone" value="<?php echo $telephone; ?>" />
										<?php if ($error_telephone) { ?>
											<span class="error"><?php echo $error_telephone; ?></span>
										<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<?php echo $entry_fax; ?>
							</div>
							<div class="controls">
								<input type="text" name="fax" value="<?php echo $fax; ?>" />
							</div>
						</div>




						<br />
						<legend><?php echo $text_your_address; ?></legend>

						<div class="control-group">
							<div class="control-label">
								<?php echo $entry_company; ?>
							</div>
							<div class="controls">
								<input type="text" name="company" value="<?php echo $company; ?>" />
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_address_1; ?>
							</div>
							<div class="controls">
								<input type="text" name="address_1" value="<?php echo $address_1; ?>" />
								<?php if ($error_address_1) { ?>
									<span class="error"><?php echo $error_address_1; ?></span>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<?php echo $entry_address_2; ?>
							</div>
							<div class="controls">
								<input type="text" name="address_2" value="<?php echo $address_2; ?>" />
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_city; ?>
							</div>
							<div class="controls">
								<input type="text" name="city" value="<?php echo $city; ?>" />
								<?php if ($error_city) { ?>
									<span class="error"><?php echo $error_city; ?></span>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span id="postcode-required" class="required">*</span> <?php echo $entry_postcode; ?>
							</div>
							<div class="controls">
								<input type="text" name="postcode" value="<?php echo $postcode; ?>" />
								<?php if ($error_postcode) { ?>
									<span class="error"><?php echo $error_postcode; ?></span>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_country; ?>
							</div>
							<div class="controls">
								<select name="country_id">
									<option value=""><?php echo $text_select; ?></option>
									<?php foreach ($countries as $country) { ?>
										<?php if ($country['country_id'] == $country_id) { ?>
											<option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
										<?php } else { ?>
											<option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
										<?php } ?>
									<?php } ?>
								</select>
								<?php if ($error_country) { ?>
									<span class="error"><?php echo $error_country; ?></span>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_zone; ?>
							</div>
							<div class="controls">
								<select name="zone_id">
								</select>
								<?php if ($error_zone) { ?>
									<span class="error"><?php echo $error_zone; ?></span>
								<?php } ?>
							</div>
						</div>
						<br />
						<legend><?php echo $text_your_password; ?></legend>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_password; ?>
							</div>
							<div class="controls">
								<input type="password" name="password" value="<?php echo $password; ?>" />
								<?php if ($error_password) { ?>
									<span class="error"><?php echo $error_password; ?></span>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="control-label">
								<span class="required">*</span> <?php echo $entry_confirm; ?>
							</div>
							<div class="controls">
								<input type="password" name="confirm" value="<?php echo $confirm; ?>" />
								<?php if ($error_confirm) { ?>
									<span class="error"><?php echo $error_confirm; ?></span>
								<?php } ?>
							</div>
						</div>
						<br />
						<legend><?php echo $text_newsletter; ?></legend>

						<div class="control-group">
							<div class="control-label">
								<?php echo $entry_newsletter; ?>
							</div>
							<div class="controls">
								<?php if ($newsletter) { ?>
									<label class="radio inline"><input type="radio" name="newsletter" value="1" checked="checked" /><?php echo $text_yes; ?></label>
									<label class="radio inline"><input type="radio" name="newsletter" value="0" /><?php echo $text_no; ?></label>
								<?php } else { ?>
									<label class="radio inline"><input type="radio" name="newsletter" value="1" /><?php echo $text_yes; ?></label>
									<label class="radio inline"><input type="radio" name="newsletter" value="0" checked="checked" /><?php echo $text_no; ?></label>
								<?php } ?>
							</div>
						</div>

						<div class="control-group">
							<div class="controls">
								<?php if ($text_agree) { ?>
									<label class="checkbox">
									<?php if ($agree) { ?>
										<input type="checkbox" name="agree" value="1" checked="checked" />
									<?php } else { ?>
										<input type="checkbox" name="agree" value="1" />
									<?php } ?>
									<?php echo $text_agree; ?></label>

								<?php } else { ?>

								<?php } ?>
							</div>
						</div>
						<div class="control-group">
							<div class="controls">
								<input type="submit" value="<?php echo $button_continue; ?>" class="btn btn-primary" />
							</div>
						</div>

					</form>
				</div>
				<div class="right">
					<?php echo $login_text ?><br />
					<strong>Need help?</strong>&nbsp;&nbsp; <i class="icon-phone"></i> <?php echo $phone; ?>
				</div>

			</div>
		</div>

	</div>

	<?php echo $content_bottom; ?>

</div><!-- /End #content -->

<!-- /Side Bar -->
<div id="side-bar">
	<?php echo $column_right; ?>
</div>

<script type="text/javascript"><!--
$('input[name=\'customer_group_id\']:checked').live('change', function() {
	var customer_group = [];

<?php foreach ($customer_groups as $customer_group) { ?>
	customer_group[<?php echo $customer_group['customer_group_id']; ?>] = [];
	customer_group[<?php echo $customer_group['customer_group_id']; ?>]['company_id_display'] = '<?php echo $customer_group['company_id_display']; ?>';
	customer_group[<?php echo $customer_group['customer_group_id']; ?>]['company_id_required'] = '<?php echo $customer_group['company_id_required']; ?>';
	customer_group[<?php echo $customer_group['customer_group_id']; ?>]['tax_id_display'] = '<?php echo $customer_group['tax_id_display']; ?>';
	customer_group[<?php echo $customer_group['customer_group_id']; ?>]['tax_id_required'] = '<?php echo $customer_group['tax_id_required']; ?>';
<?php } ?>

	if (customer_group[this.value]) {
		if (customer_group[this.value]['company_id_display'] == '1') {
			$('#company-id-display').show();
		} else {
			$('#company-id-display').hide();
		}

		if (customer_group[this.value]['company_id_required'] == '1') {
			$('#company-id-required').show();
		} else {
			$('#company-id-required').hide();
		}

		if (customer_group[this.value]['tax_id_display'] == '1') {
			$('#tax-id-display').show();
		} else {
			$('#tax-id-display').hide();
		}

		if (customer_group[this.value]['tax_id_required'] == '1') {
			$('#tax-id-required').show();
		} else {
			$('#tax-id-required').hide();
		}
	}
});

$('input[name=\'customer_group_id\']:checked').trigger('change');
//--></script>
<script type="text/javascript"><!--
$('select[name=\'country_id\']').bind('change', function() {
	$.ajax({
		url: 'index.php?route=account/register/country&country_id=' + this.value,
		dataType: 'json',
		beforeSend: function() {
			$('select[name=\'country_id\']').after('<span class="wait">&nbsp;<img src="catalog/view/theme/default/image/loading.gif" alt="" /></span>');
		},
		complete: function() {
			$('.wait').remove();
		},
		success: function(json) {
			if (json['postcode_required'] == '1') {
				$('#postcode-required').show();
			} else {
				$('#postcode-required').hide();
			}

			html = '<option value=""><?php echo $text_select; ?></option>';

			if (json['zone'] != '') {
				for (i = 0; i < json['zone'].length; i++) {
        			html += '<option value="' + json['zone'][i]['zone_id'] + '"';

					if (json['zone'][i]['zone_id'] == '<?php echo $zone_id; ?>') {
	      				html += ' selected="selected"';
	    			}

	    			html += '>' + json['zone'][i]['name'] + '</option>';
				}
			} else {
				html += '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
			}

			$('select[name=\'zone_id\']').html(html);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('select[name=\'country_id\']').trigger('change');
//--></script>
<script type="text/javascript"><!--
$('.colorbox').colorbox({
	width: 640,
	height: 480
});
//--></script>
<?php echo $footer; ?>