<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, user-scalable=no">
<base href="<?php echo $base; ?>" />
<title><?php echo $title; ?></title>

<?php if ($description) { ?><meta name="description" content="<?php echo $description; ?>" /><?php } ?>
<?php if ($keywords) { ?><meta name="keywords" content="<?php echo $keywords; ?>" /><?php } ?>

<meta property="og:title" content="<?php echo $title; ?>" />

<meta property="og:type" content="website" />
<meta property="fb:admins" content="100006533707003"/>
<?php if ($og_descr) { ?>
<meta property="og:description" content="<?php echo $og_descr; ?>" />
<?php } else { ?>
<meta property="og:description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($og_image) { ?>
<meta property="og:image" content="<?php echo $og_image; ?>" />
<?php } else { ?>
<meta property="og:image" content="<?php echo $logo; ?>" />
<?php } ?>

<?php 
$pageURL = "http" . ((!empty($_SERVER['HTTPS'])) ? "s" : "") . "://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];

;?>
<meta property="og:url" content="<?php echo $pageURL; ?>" />

<?php if ($icon) { ?><link rel="shortcut icon" type="image/png" href="<?php echo $icon; ?>" /><?php } ?>
<?php foreach ($links as $link) { ?><link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" /><?php } ?>

<link rel="stylesheet" type="text/css" media="all" href="<?php echo $base; ?>catalog/view/theme/default/stylesheet/stylesheet.css" />


<link href='http://fonts.googleapis.com/css?family=Source+Sans+Pro:400,600,700' rel='stylesheet' type='text/css'>



<link href="https://plus.google.com/<?php echo html_entity_decode($this->config->get('config_googleplus'), ENT_QUOTES, 'UTF-8') ;?>" rel="author" />

<script type="text/javascript" src="catalog/view/theme/default/js/common.bt.js"></script>

<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>

</head>
<body class="<?php echo $body_class; ?>">
<?php echo $google_analytics; ?>

<!-- /HEADER SLOT -->
<div id="header-slot">
	<div class="bt-container">

		<div class="bt-row">

			<div class="col-1">

				<!-- /Store Logo -->
				<div id="store-logo">
				  <?php list($width, $height) = getimagesize($logo); ;?>
					<a href="<?php echo $home; ?>"><img height="<?php echo $height ;?>" width="<?php echo $width ;?>" src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a>
				</div>

			</div><!-- /End col-1 -->

			<div class="col-2">

				<!-- /Header Info -->
				<div id="header-info">

					<!-- /Shopping Cart -->
					<div id="shopping-cart">
						<?php echo $cart; ?><a id="iphone-checkout" href="<?php echo $checkout; ?>">View Cart</a>
					</div>

					<!-- /Sub navigation -->
					<div id="sub-nav">
						<ul>
							<li class="logged-user">
								<?php if (!$logged) { ?>
									<?php echo $text_welcome; ?>
								<?php } else { ?>
									<?php echo $text_logged; ?>
								<?php } ?>
							</li>
							<?php if ($logged) { ?>
								<li><a href="<?php echo $account; ?>"><?php echo $text_account; ?></a></li>
							<?php } ?>
							<li>
								<a href="<?php echo $checkout; ?>"><?php echo $text_checkout; ?></a>
							</li>
						</ul>
					</div>

				</div>

				<div class="bt-row">
					<!-- /Search Box -->
					<div class="search-box">
						<div class="input-append">
						<?php if ($filter_name) { ?>
							<input id="appendedInputButton" size="106" type="text" name="filter_name" value="<?php echo $filter_name; ?>" />
						<?php } else { ?>
							<input id="appendedInputButton" size="10" type="text" name="filter_name" value="<?php echo $text_search; ?>" onclick="this.value = '';" onkeydown="this.style.color = '#000000';" />
						<?php } ?><a class="button-search add-on"><img src="/catalog/view/theme/default/image/icon-search.png" alt="icon-search" width="11" height="11" /></a>
						</div>

            <div id="cur-lang">
              <ul>
                <!-- /Currency -->
      					<?php if ($currency) { ?>
      						<li id="currency">
      							<?php echo $currency; ?>
      						</li>
      					<?php } ?>

      					<!-- /Language -->
      					<?php if ($language) { ?>
      						<li id="language">
      							<?php echo $language; ?>
      						</li>
      					<?php } ?>
      				</ul>
    				</div>

					</div>
				</div>

				<div id="iphone-box">



					<!-- /iPhone Menu -->
					<div id="iphone-menu">
						<select name="iphone-menu">

							<option value="">&Xi; Menu</option>
							<option value="<?php echo $home; ?>"><?php echo $text_home; ?></option>
							<option value="<?php echo $new_arrivals; ?>"><?php echo $text_new_arrivals; ?></option>
							<option value="">--------</option>
							
							<?php foreach ($categories as $category) { ?>

									<?php if ($category['children']) { ?>
										<optgroup label="<?php echo $category['name']; ?>">

													<?php for ($i = 0; $i < count($category['children']);) { ?>

															<?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
															<?php for (; $i < $j; $i++) { ?>
																<?php if (isset($category['children'][$i])) { ?>
																	<option value="<?php echo $category['children'][$i]['href']; ?>"><?php echo $category['children'][$i]['name']; ?></option>
																<?php } ?>
															<?php } ?>

													<?php } ?>


										</optgroup>
									<?php } else { ;?>
										
											<option value="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></option>
										

									<?php } ?>

							<?php } ?>
							<?php if($specials){?>
								<option value="<?php echo $sale; ?>"><?php echo $text_sale; ?></option>
							<?php } ?>

						</select>
					</div>

				</div>

			</div><!-- /End col-2 -->

		</div>

	</div>
</div><!-- /#header-slot -->

<!-- /TOP NAGIVATION -->
<div id="top-nav">
	<div class="bt-container">

		<div class="bt-row">

			<!-- /Main Menu -->
			<div id="main-menu">
				<ul>
				<li><a href="<?php echo $home; ?>"><i class="icon-home"></i></a></li>
				<li><a href="<?php echo $new_arrivals; ?>"><?php echo $text_new_arrivals; ?></a></li>
				<?php foreach ($categories as $category) { ?>

					<?php if ($category['category_id']==$category_id) { ?>
						<li class="active"><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
					<?php } else { ?>
						<li><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
					<?php } ?>

						<?php if ($category['children']) { ?>
							<div class="sub-menu">
								<?php if (($category['column'])==1) { ?>
									<div class="no-column">
										<?php for ($i = 0; $i < count($category['children']);) { ?>
											<ul>
												<?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
												<?php for (; $i < $j; $i++) { ?>
													<?php if (isset($category['children'][$i])) { ?>
														<li><a href="<?php echo $category['children'][$i]['href']; ?>"><span><?php echo $category['children'][$i]['name']; ?></span></a></li>
													<?php } ?>
												<?php } ?>
											</ul>
										<?php } ?>
									</div>
								<?php } else { ?>

									<?php
										$width = $category['column'] * 120;
										$left = ($category['column'] * 60);
									?>
									<div class="column">
										<ul style="width:<?php echo $width ;?>px">
									<?php for ($i = 0; $i < count($category['children']);) { ?>
										<li>
											<?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
											<ol>
											<?php for (; $i < $j; $i++) { ?>

												<?php if (isset($category['children'][$i])) { ?>
													<li><a href="<?php echo $category['children'][$i]['href']; ?>"><span><?php echo $category['children'][$i]['name']; ?></span></a></li>
												<?php } ?>

											<?php } ?>
											</ol>
										</li>
									<?php } ?>
										</ul>
									</div>
								<?php } ?>
							</div>

						<?php } ?>
					</li>
				<?php } ?>
				<?php if($specials){?><li id="sale"><a href="<?php echo $sale; ?>"><?php echo $text_sale; ?></a></li><?php } ?>
				
			</ul>
			</div>

		</div>


			<div class="line"></div>
			<div class="line double"></div>


	</div>
</div>