<?php if($products){?>
<div id="module-latest" class="module catalog">

	<div class="module-header">
		<h4><i class="icon-star"></i> <?php echo $heading_title; ?></h4>
	</div>
	<div class="module-content">
		<div>
		<ul class="product-catalog grid">
			<?php foreach ($products as $product) { ?>
				<li class="item">
					<div class="catalog-item">

						<div class="overlay">
							<?php if ($product['special']) { ?>
								<div class="catalog-label">
									&nbsp;
								</div>
							<?php } ?>

							<div class="catalog-rating">
							  <?php
							    $rat = $product['rating'];
							   for($i = 1; $i <= $rat; $i++) { ?>
							  						  <i class="icon-star"></i>
							  						<?php } ;?>
							</div>
						</div>

						<?php if ($product['thumb']) { ?>
							<div class="catalog-image">
								<a href="<?php echo $product['href']; ?>">
								  <img height="<?php echo $product['height']; ?>" width="<?php echo $product['width']; ?>" src="<?php echo $product['thumb']; ?>" title="<?php echo $product['name']; ?>" alt="<?php echo $product['name']; ?>" />
								</a>

							</div>
						<?php } ?>

						<div class="catalog-info">

							<div class="catalog-detail">
								<div class="catalog-name">
									<a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?>
										<?php if ($product['rating']) { ?><span><?php echo $product['rating']; ?><i class="icon-star"></i></span><?php } ?>
										</a>
								</div>

									<?php if ($product['price']) { ?>
										<div class="catalog-price">
											<div>
												<?php if (!$product['special']) { ?>
													<small class="no-line">&nbsp;</small>
													<span class="price-new"><?php echo $product['price']; ?></span>
												<?php } else { ?>
													<span class="special"><?php echo $product['special']; ?></span>
													<small><?php echo $product['price']; ?></small>
												<?php } ;?>

                      </div>
										</div>

									<?php } ;?>
									<div class="catalog-action">
										<?php if ($product['quantity'] > 0) { ;?>
											<a title="Add to bag" class="purchase-button" onclick="addToCart('<?php echo $product['product_id']; ?>');"><i class="icon-bag"></i><i class="icon-plus-circled"></i><span><?php echo $button_cart ?></span></a>
											<?php } else { ;?>
												<div class="out-of-stock"><span>OUT OF STOCK</span></div>
											<?php } ;?>
									</div>


							</div>

						</div>
						<div class="catalog-sharing" >
							<span onclick="addToWishList('<?php echo $product['product_id']; ?>');"><i class="icon-heart" title="Add to wishlist" ></i><em>Add to</em> wishlist</span>&nbsp;&nbsp;
							<span onclick="addToCompare('<?php echo $product['product_id']; ?>');"><i class="icon-docs" title="Add to compare" ></i><em>Add to</em> compare</span>
						</div>

					</div>
				</li>
			<?php } ?>
		</ul>
		</div>
	</div>
	<div class="module-footer">
		&nbsp;
	</div>
</div>
<?php } ?>