<?php echo $header; ?>

<?php if ($success) { ?>
	<div class="success"><?php echo $success; ?></div>
<?php } ?>

<!-- /CONTENT SLOT -->
<div id="compare-page" class="content-slot">
	<div class="bt-container">

		<!-- /Notification -->
		<div id="notification"></div>

		<div class="bt-row">

<!-- /Content -->
<div id="content">

	<div class="bt-row">
		<!-- /Breadcrumb -->
		<div id="breadcrumb">
			<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
			<?php } ?>
		</div>
	</div>

	<!-- /Page Header -->
	<div id="page-header">

			<div id="page-title">
				<h1><?php echo $heading_title; ?></h1>
			</div>

	</div>

	<?php if ($products) { ?>
		<div id="compare-container">
		<table class="compare-info">
<!--
			<thead>
				<tr>
					<td class="compare-product" colspan="<//?php echo count($products) + 1; ?>"><//?php echo $text_product; ?></td>
				</tr>
			</thead>
-->
			<tbody>
				<tr>
					<td><?php echo $text_name; ?></td>
					<?php foreach ($products as $product) { ?>
						<td class="name"><a href="<?php echo $products[$product['product_id']]['href']; ?>"><?php echo $products[$product['product_id']]['name']; ?></a></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_image; ?></td>
					<?php foreach ($products as $product) { ?>
						<td>
							<?php if ($products[$product['product_id']]['thumb']) { ?>
								<img src="<?php echo $products[$product['product_id']]['thumb']; ?>" alt="<?php echo $products[$product['product_id']]['name']; ?>" />
							<?php } ?>
						</td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_price; ?></td>
					<?php foreach ($products as $product) { ?>
						<td>
							<?php if ($products[$product['product_id']]['price']) { ?>
								<?php if (!$products[$product['product_id']]['special']) { ?>
									<?php echo $products[$product['product_id']]['price']; ?>
								<?php } else { ?>
									<span class="price-old"><?php echo $products[$product['product_id']]['price']; ?></span> <span class="price-new"><?php echo $products[$product['product_id']]['special']; ?></span>
								<?php } ?>
							<?php } ?>
						</td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_model; ?></td>
					<?php foreach ($products as $product) { ?>
						<td><?php echo $products[$product['product_id']]['model']; ?></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_manufacturer; ?></td>
					<?php foreach ($products as $product) { ?>
						<td><?php echo $products[$product['product_id']]['manufacturer']; ?></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_availability; ?></td>
					<?php foreach ($products as $product) { ?>
						<td><?php echo $products[$product['product_id']]['availability']; ?></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_rating; ?></td>
					<?php foreach ($products as $product) { ?>
						<td class="rating">
							<span><?php echo $products[$product['product_id']]['rating']; ?> <i class="icon-star"></i></span><br />
							<?php echo $products[$product['product_id']]['reviews']; ?>
						</td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_summary; ?></td>
					<?php foreach ($products as $product) { ?>
						<td class="description"><?php echo $products[$product['product_id']]['description']; ?></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_weight; ?></td>
					<?php foreach ($products as $product) { ?>
						<td><?php echo $products[$product['product_id']]['weight']; ?></td>
					<?php } ?>
				</tr>
				<tr>
					<td><?php echo $text_dimension; ?></td>
					<?php foreach ($products as $product) { ?>
						<td class="dimension"><?php echo $products[$product['product_id']]['length']; ?> x <?php echo $products[$product['product_id']]['width']; ?> x <?php echo $products[$product['product_id']]['height']; ?></td>
					<?php } ?>
				</tr>

			</tbody>

			<?php foreach ($attribute_groups as $attribute_group) { ?>
				<thead>
					<tr>
						<td class="compare-attribute" colspan="<?php echo count($products) + 1; ?>"><?php echo $attribute_group['name']; ?></td>
					</tr>
				</thead>
				<?php foreach ($attribute_group['attribute'] as $key => $attribute) { ?>
					<tbody>
						<tr>
							<td><?php echo $attribute['name']; ?></td>
							<?php foreach ($products as $product) { ?>
								<?php if (isset($products[$product['product_id']]['attribute'][$key])) { ?>
									<td><?php echo $products[$product['product_id']]['attribute'][$key]; ?></td>
								<?php } else { ?>
									<td></td>
								<?php } ?>
							<?php } ?>
						</tr>
					</tbody>
				<?php } ?>
			<?php } ?>

			<tfoot>
				<tr>
					<td class="compare-button"></td>
					<?php foreach ($products as $product) { ?>
						<td class="compare-button">
							<a onclick="addToCart('<?php echo $product['product_id']; ?>');"  class="btn btn-primary" ><i class="icon-bag"></i></a>
							<a href="<?php echo $product['remove']; ?>" class="btn btn-danger"><?php echo $button_remove; ?></a>
						</td>
					<?php } ?>
				</tr>
			</tfoot>
		</table>
		</div>

	<?php } else { ?>
		<?php echo $text_empty; ?><br /><br /><br />
	<?php } ?>

	<?php echo $content_bottom; ?>

</div><!-- /End #content -->

		</div><!-- /.bt-row -->
	</div><!-- /.bt-container -->
</div><!-- /#content-slot -->

<?php echo $footer; ?>