<?php echo $header; ?>

<!-- /CONTENT SLOT -->
<div id="category-page" class="content-slot">
	<div class="bt-container">

		<!-- /Notification -->
		<div id="notification"></div>

		<div class="bt-row">

			<!-- /Left Sidebar -->
			<div id="left-sidebar">
				<?php echo $column_left; ?>
			</div>

<!-- /Content -->
<div id="content">

	<?php echo $content_top; ?>

	<div class="bt-row">

		<!-- /Breadcrumb -->
		<div id="breadcrumb">
			<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
			<?php } ?>
		</div>

		<!-- /Compare -->
		<div id="compare">
			<a href="<?php echo $compare; ?>" id="compare-total"><i class="icon-docs"></i><?php echo $text_compare; ?></a>
		</div>

	</div>

	<!-- /Page Header -->
	<div id="page-header">

			<div id="page-title">
				<h1><?php echo $heading_title; ?></h1>
			</div>
		</div>


	<?php if ($products) { ?>

		<div id="page-filters">
			<div class="bt-row">
				<div class="paging" id="top">
					<?php echo $pagination; ?>
				</div>

				<!-- /Sorting -->
				<div id="sorting">

						<div id="display">
							<strong><?php echo $text_display ?></strong>
							<select onchange="location = this.value;">
                <?php foreach ($limits as $limits) { ?>
                <?php if ($limits['value'] == $limit) { ?>
                <option value="<?php echo $limits['href']; ?>" selected="selected"><?php echo $limits['text']; ?></option>
                <?php } else { ?>
                <option value="<?php echo $limits['href']; ?>"><?php echo $limits['text']; ?></option>
                <?php } ?>
                <?php } ?>
              </select>
						</div>
            <div id="sortby">
							<strong><?php echo $text_sort ?></strong>
							<select onchange="location = this.value;">
              <?php foreach ($sorts as $sorts) { ?>
              <?php if ($sorts['value'] == $sort . '-' . $order) { ?>
              <option value="<?php echo $sorts['href']; ?>" selected="selected"><?php echo $sorts['text']; ?></option>
              <?php } else { ?>
              <option value="<?php echo $sorts['href']; ?>"><?php echo $sorts['text']; ?></option>
              <?php } ?>
              <?php } ?>
            </select>
						</div>
						<div id="view">
							<i class="icon-layout"></i><a onclick="display('list');"><i class="icon-list"></i></a>
						</div>

				</div>
			</div>
		</div>

				<ul class="product-catalog grid">
			<?php foreach ($products as $product) { ?>
				<li class="item">
					<div class="catalog-item">

						<div class="overlay">
							<?php if ($product['special']) { ?>
								<div class="catalog-label">
									&nbsp;
								</div>
							<?php } ?>

							<div class="catalog-rating">
							  <?php
							    $rat = $product['rating'];
							   for($i = 1; $i <= $rat; $i++) { ?>
							  						  <i class="icon-star"></i>
							  						<?php } ;?>
							</div>
						</div>

						<?php if ($product['thumb']) { ?>
							<div class="catalog-image">
								<a href="<?php echo $product['href']; ?>"><img height="<?php echo $product['height']; ?>" width="<?php echo $product['width']; ?>" src="<?php echo $product['thumb']; ?>" title="<?php echo $product['name']; ?>" alt="<?php echo $product['name']; ?>" /></a>

							</div>
						<?php } ?>

						<div class="catalog-info">

							<div class="catalog-detail">
								<div class="catalog-name">
									<a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?>
										<?php if ($product['rating']) { ?><span><?php echo $product['rating']; ?><i class="icon-star"></i></span><?php } ?>
										</a>
										<p><?php echo $product['description']; ?></p>
								</div>

									<?php if ($product['price']) { ?>
										<div class="catalog-price">
											<div>
												<?php if (!$product['special']) { ?>
													<small class="no-line">&nbsp;</small>
													<span class="price-new"><?php echo $product['price']; ?></span>
												<?php } else { ?>
													<span class="special"><?php echo $product['special']; ?></span>
													<small><?php echo $product['price']; ?></small>
												<?php } ;?>

                      </div>
										</div>

									<?php } ;?>
									<div class="catalog-action">
										<?php if ($product['quantity'] > 0) { ;?>
											<a title="Add to bag" class="purchase-button" onclick="addToCart('<?php echo $product['product_id']; ?>');"><i class="icon-bag"></i><i class="icon-plus-circled"></i><span><?php echo $button_cart ?></span></a>
											<?php } else { ;?>
												<div class="out-of-stock"><span>OUT OF STOCK</span></div>
											<?php } ;?>
									</div>


							</div>

						</div>
						<div class="catalog-sharing" >
							<span onclick="addToWishList('<?php echo $product['product_id']; ?>');"><i class="icon-heart" title="Add to wishlist" ></i><em>Add to</em> wishlist</span>&nbsp;&nbsp;
							<span onclick="addToCompare('<?php echo $product['product_id']; ?>');"><i class="icon-docs" title="Add to compare" ></i><em>Add to</em> compare</span>
						</div>

					</div>
				</li>
			<?php } ?>
		</ul>
	<?php } ?>

	<!-- /Pagination -->
	<div class="paging">
		<div class="bt-row">
			<?php echo $pagination; ?>
		</div>
	</div>



</div><!-- /End #content -->


		</div><!-- /.bt-row -->
<?php echo $content_bottom; ?>
	</div><!-- /.bt-container -->
</div><!-- /#content-slot -->

<script type="text/javascript"><!--
function display(view) {
	if (view == 'list') {
		$('#content .product-catalog').attr('class', 'product-catalog list');		
		
		$('#view').html('<a onclick="display(\'grid\');"><i class="icon-layout"></i></a><i class="icon-list"></i>');
		
		$.cookie('display', 'list'); 
	} else {
		$('#content .product-catalog').attr('class', 'product-catalog grid');
		
					
		$('#view').html('<i class="icon-layout"></i><a onclick="display(\'list\');"><i class="icon-list"></i></a>');
		
		$.cookie('display', 'grid');
	}
}

view = $.cookie('display');

if (view) {
	display(view);
} else {
	display('grid');
}
//--></script> 
<?php echo $footer; ?>