<?php 
class ControllerCatalogSpecialManager extends Controller
{

  const DISCOUNT_TYPE_PERCENTAGE = 0;
  const DISCOUNT_TYPE_FIXED_DISCOUNT = 1;
  const DISCOUNT_TYPE_FIXED_PRICE = 2;

  private $error = array();

  private $categoryColumns = array(
    array('key' => 'selected', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '20px', 'edittype' => false),
    array('key' => 'id', 'name' => 'cs.category_special_id', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'name', 'name' => 'cd.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'customer_group', 'name' => 'cg.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => 'select'),
    array('key' => 'priority', 'name' => 'cs.priority', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'discount', 'name' => 'cs.discount', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'discount_type', 'name' => 'cs.discount_type', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'select'),
    array('key' => 'date_start', 'name' => 'cs.date_start', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'date_end', 'name' => 'cs.date_end', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'action', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '60px', 'edittype' => false)
  );

  private $manufacturerColumns = array(
    array('key' => 'selected', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '20px', 'edittype' => false),
    array('key' => 'id', 'name' => 'cs.category_special_id', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'name', 'name' => 'm.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'customer_group', 'name' => 'cg.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => 'select'),
    array('key' => 'priority', 'name' => 'cs.priority', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'discount', 'name' => 'cs.discount', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'discount_type', 'name' => 'cs.discount_type', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'select'),
    array('key' => 'date_start', 'name' => 'cs.date_start', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'date_end', 'name' => 'cs.date_end', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'action', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '60px', 'edittype' => false)
  );

  private $productColumns = array(
    array('key' => 'selected', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '20px', 'edittype' => false),
    array('key' => 'id', 'name' => 'ps.product_special_id', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'name', 'name' => 'pd.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => false),
    array('key' => 'customer_group', 'name' => 'cg.name', 'sortable' => true, 'searchable' => true, 'visible' => true, 'width' => false, 'edittype' => 'select'),
    array('key' => 'priority', 'name' => 'ps.priority', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'discount', 'name' => 'ps.price', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'date_start', 'name' => 'ps.date_start', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'date_end', 'name' => 'ps.date_end', 'sortable' => true, 'searchable' => false, 'visible' => true, 'width' => false, 'edittype' => 'input'),
    array('key' => 'action', 'name' => false, 'sortable' => false, 'searchable' => false, 'visible' => true, 'width' => '60px', 'edittype' => false)
  );

  public function index()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('heading_title'));

    $this->getList();
  }

  private function getList()
  {

    $this->data['breadcrumbs'] = array();

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('text_home'),
      'separator' => FALSE
    );

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('catalog/special_manager', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('heading_title'),
      'separator' => ' :: '
    );

    $this->data['iPipe'] = 5;
    $this->data['insert_product'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_product&token=' . $this->session->data['token'];
    $this->data['delete_product'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/delete_product&token=' . $this->session->data['token'];
    $this->data['insert_category'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_category&token=' . $this->session->data['token'];
    $this->data['delete_category'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/delete_category&token=' . $this->session->data['token'];
    $this->data['insert_manufacturer'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_manufacturer&token=' . $this->session->data['token'];
    $this->data['delete_manufacturer'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/delete_manufacturer&token=' . $this->session->data['token'];

    $this->data['heading_title'] = $this->language->get('heading_title');
    $this->data['product_heading_title'] = $this->language->get('product_heading_title');
    $this->data['category_heading_title'] = $this->language->get('category_heading_title');
    $this->data['manufacturer_heading_title'] = $this->language->get('manufacturer_heading_title');

    $this->data['text_no_results'] = $this->language->get('text_no_results');
    $this->data['text_select_all'] = $this->language->get('text_select_all');
    $this->data['text_select_none'] = $this->language->get('text_select_none');
    $this->data['text_none'] = $this->language->get('text_none');

    $this->data['text_indicator_saving'] = addslashes($this->language->get('text_indicator_saving'));
    $this->data['text_confirm_delete'] = $this->language->get('text_confirm_delete');
    $this->data['text_print_instructions'] = $this->language->get('text_print_instructions');

    $this->data['text_results_per_page'] = $this->language->get('text_results_per_page');
    $this->data['text_search'] = $this->language->get('text_search');
    $this->data['text_toggle_columns'] = $this->language->get('text_toggle_columns');
    $this->data['text_print_instructions'] = $this->language->get('text_print_instructions');

    $this->data['button_apply_filter'] = $this->language->get('button_apply_filter');

    $this->data['error_no_selection'] = $this->language->get('error_no_selection');

    $this->data['tables'] = array(
      array('key' => 'category'),
      array('key' => 'manufacturer'),
      array('key' => 'product')
    );

    foreach ($this->data['tables'] as $table)
    {
      foreach ($this->
      {$table['key'] . 'Columns'} as $column)
      {
        if ($column['key'] != 'selected')
        {
          $this->data[$table['key'] . 'Column_' . $column['key']] = $this->language->get($table['key'] . 'Column_' . $column['key']);
        }
      }
    }

    $this->data['button_insert'] = $this->language->get('button_insert');
    $this->data['button_delete'] = $this->language->get('button_delete');

    $this->data['token'] = $this->session->data['token'];

    if (isset($this->error['warning']))
    {
      $this->data['error_warning'] = $this->error['warning'];
    } else
    {
      $this->data['error_warning'] = '';
    }

    if (isset($this->session->data['success']))
    {
      $this->data['success'] = $this->session->data['success'];

      unset($this->session->data['success']);
    } else
    {
      $this->data['success'] = '';
    }

    $this->load->model('catalog/category');

    $this->data['categories'] = $this->model_catalog_category->getCategories(0);

    $this->load->model('catalog/manufacturer');

    $this->data['manufacturers'] = $this->model_catalog_manufacturer->getManufacturers();

    $this->load->model('sale/customer_group');

    $bVisible = array();
    $bSortable = array('0');
    $sWidth = array();

    foreach ($this->productColumns as $i => &$column)
    {
      if (!$column['visible'])
      {
        $bVisible[] = $i;
      }
      if (!$column['sortable'])
      {
        $bSortable[] = $i;
      }
      if ($column['width'] != false)
      {
        $sWidth[] = array('index' => $i, 'value' => $column['width']);
      }
      if ($column['key'] == 'action')
      {
        $actionIndex = $i;
      }
      if ($column['key'] == 'selected')
      {
        $selectedIndex = $i;
      }
      if ($column['key'] == 'id')
      {
        $idIndex = $i;
      }
      if ($column['key'] == 'customer_group')
      {
        $customer_groups = $this->model_sale_customer_group->getCustomerGroups();
        foreach ($customer_groups as $customer_group)
        {
          $column['options'][$customer_group['customer_group_id']] = $customer_group['name'];
        }
      }
    }

    foreach ($this->productColumns as &$column)
    {
      if (isset($column['options']))
      {
        $column['options'] = json_encode($column['options']);
      }
    }

    $this->data['bVisible_product'] = implode(',', $bVisible);
    $this->data['bSortable_product'] = implode(',', $bSortable);
    $this->data['sWidth_product'] = $sWidth;
    $this->data['actionIndex_product'] = $actionIndex;
    $this->data['selectedIndex_product'] = $selectedIndex;
    $this->data['idIndex_product'] = $idIndex;

    $bVisible = array();
    $bSortable = array('0');
    $sWidth = array();

    foreach ($this->categoryColumns as $i => &$column)
    {
      if (!$column['visible'])
      {
        $bVisible[] = $i;
      }
      if (!$column['sortable'])
      {
        $bSortable[] = $i;
      }
      if ($column['width'] != false)
      {
        $sWidth[] = array('index' => $i, 'value' => $column['width']);
      }
      if ($column['key'] == 'action')
      {
        $actionIndex = $i;
      }
      if ($column['key'] == 'selected')
      {
        $selectedIndex = $i;
      }
      if ($column['key'] == 'id')
      {
        $idIndex = $i;
      }
      if ($column['key'] == 'customer_group')
      {
        $customer_groups = $this->model_sale_customer_group->getCustomerGroups();
        foreach ($customer_groups as $customer_group)
        {
          $column['options'][$customer_group['customer_group_id']] = $customer_group['name'];
        }
      }
      if ($column['key'] == 'discount_type')
      {
        $column['options'][self::DISCOUNT_TYPE_PERCENTAGE] = $this->language->get('text_percentage');
        $column['options'][self::DISCOUNT_TYPE_FIXED_DISCOUNT] = $this->language->get('text_fixed_discount');
        $column['options'][self::DISCOUNT_TYPE_FIXED_PRICE] = $this->language->get('text_fixed_price');
      }
    }

    foreach ($this->categoryColumns as &$column)
    {
      if (isset($column['options']))
      {
        $column['options'] = json_encode($column['options']);
      }
    }

    $this->data['bVisible_category'] = implode(',', $bVisible);
    $this->data['bSortable_category'] = implode(',', $bSortable);
    $this->data['sWidth_category'] = $sWidth;
    $this->data['actionIndex_category'] = $actionIndex;
    $this->data['selectedIndex_category'] = $selectedIndex;
    $this->data['idIndex_category'] = $idIndex;

    $bVisible = array();
    $bSortable = array('0');
    $sWidth = array();
    
    foreach ($this->manufacturerColumns as $i => &$column)
    {
      if (!$column['visible'])
      {
        $bVisible[] = $i;
      }
      if (!$column['sortable'])
      {
        $bSortable[] = $i;
      }
      if ($column['width'] != false)
      {
        $sWidth[] = array('index' => $i, 'value' => $column['width']);
      }
      if ($column['key'] == 'action')
      {
        $actionIndex = $i;
      }
      if ($column['key'] == 'selected')
      {
        $selectedIndex = $i;
      }
      if ($column['key'] == 'id')
      {
        $idIndex = $i;
      }
      if ($column['key'] == 'customer_group')
      {
        $customer_groups = $this->model_sale_customer_group->getCustomerGroups();
        foreach ($customer_groups as $customer_group)
        {
          $column['options'][$customer_group['customer_group_id']] = $customer_group['name'];
        }
      }
      if ($column['key'] == 'discount_type')
      {
        $column['options'][self::DISCOUNT_TYPE_PERCENTAGE] = $this->language->get('text_percentage');
        $column['options'][self::DISCOUNT_TYPE_FIXED_DISCOUNT] = $this->language->get('text_fixed_discount');
        $column['options'][self::DISCOUNT_TYPE_FIXED_PRICE] = $this->language->get('text_fixed_price');
      }
    }

    foreach ($this->manufacturerColumns as &$column)
    {
      if (isset($column['options']))
      {
        $column['options'] = json_encode($column['options']);
      }
    }

    $this->data['bVisible_manufacturer'] = implode(',', $bVisible);
    $this->data['bSortable_manufacturer'] = implode(',', $bSortable);
    $this->data['sWidth_manufacturer'] = $sWidth;
    $this->data['actionIndex_manufacturer'] = $actionIndex;
    $this->data['selectedIndex_manufacturer'] = $selectedIndex;
    $this->data['idIndex_manufacturer'] = $idIndex;

    $this->data['productColumns'] = $this->productColumns;
    $this->data['categoryColumns'] = $this->categoryColumns;
    $this->data['manufacturerColumns'] = $this->manufacturerColumns;

    $this->document->addStyle('view/javascript/jquery/dataTables/css/dataTables.css');
    $this->document->addStyle('view/javascript/jquery/dataTables/css/TableTools.css');
    $this->document->addStyle('view/javascript/jquery/dataTables/css/TableTools.print.css', 'stylesheet', 'print');
    $this->document->addStyle('view/javascript/jquery/dataTables/css/ColVis.css');
    $this->document->addScript('view/javascript/jquery/dataTables/js/jquery.dataTables.min.js');
    $this->document->addScript('view/javascript/jquery/jquery.jeditable.min.js');
    $this->document->addScript('view/javascript/jquery/dataTables/js/TableTools.min.js');
    $this->document->addScript('view/javascript/jquery/dataTables/js/ColVis.min.js');

    $this->template = 'catalog/special_manager_list.tpl';
    $this->children = array(
      'common/header',
      'common/footer'
    );

    $this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  }

  public function insert_product()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('product_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_product())
    {
      $this->model_catalog_special_manager->addProductSpecial($this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_product();
  }

  public function update_product()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('product_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_product())
    {
      $this->model_catalog_special_manager->editProductSpecial($this->request->get['product_special_id'], $this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_product();
  }

  public function delete_product()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('product_heading_title'));

    $this->load->model('catalog/special_manager');

    if (isset($this->request->post['selected']))
    {
      foreach ($this->request->post['selected'] as $product_special_id)
      {
        $this->model_catalog_special_manager->deleteProductSpecial($product_special_id);
      }

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getList();
  }


  private function getForm_product()
  {
    $this->data['heading_title'] = $this->language->get('product_heading_title');

    $this->data['text_fixed_discount'] = $this->language->get('text_fixed_discount');
    $this->data['text_fixed_price'] = $this->language->get('text_fixed_price');
    $this->data['text_percentage'] = $this->language->get('text_percentage');

    $this->data['productEntry_products'] = $this->language->get('productEntry_products');
    $this->data['productEntry_customer_group'] = $this->language->get('productEntry_customer_group');
    $this->data['productEntry_priority'] = $this->language->get('productEntry_priority');
    $this->data['productEntry_discount'] = $this->language->get('productEntry_discount');
    $this->data['productEntry_discount_type'] = $this->language->get('productEntry_discount_type');
    $this->data['productEntry_price'] = $this->language->get('productEntry_price');
    $this->data['productEntry_price_new'] = $this->language->get('productEntry_price_new');
    $this->data['productEntry_date_start'] = $this->language->get('productEntry_date_start');
    $this->data['productEntry_date_end'] = $this->language->get('productEntry_date_end');

    $this->data['button_save'] = $this->language->get('button_save');
    $this->data['button_cancel'] = $this->language->get('button_cancel');

    if (isset($this->error['warning']))
    {
      $this->data['error_warning'] = $this->error['warning'];
    } else
    {
      $this->data['error_warning'] = '';
    }

    if (isset($this->error['products']))
    {
      $this->data['error_products'] = $this->error['products'];
    } else
    {
      $this->data['error_products'] = '';
    }

    if (isset($this->error['priority']))
    {
      $this->data['error_priority'] = $this->error['priority'];
    } else
    {
      $this->data['error_priority'] = '';
    }

    if (isset($this->error['discount']))
    {
      $this->data['error_discount'] = $this->error['discount'];
    } else
    {
      $this->data['error_discount'] = '';
    }

    $this->data['breadcrumbs'] = array();

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('text_home'),
      'separator' => FALSE
    );

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('catalog/special_manager', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('heading_title'),
      'separator' => ' :: '
    );

    if (!isset($this->request->get['product_special_id']))
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_product&token=' . $this->session->data['token'];
    } else
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_product&token=' . $this->session->data['token'] . '&product_special_id=' . $this->request->get['product_special_id'];
    }

    $this->data['cancel'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token'];

    $this->data['token'] = $this->session->data['token'];

    if (isset($this->request->get['product_special_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST'))
    {
      $product_special_info = $this->model_catalog_special_manager->getProductSpecial($this->request->get['product_special_id']);
    }

    if (isset($this->request->post['special_manager_product']))
    {
      $this->data['special_manager_product'] = implode(",", $this->request->post['special_manager_product']);
    } elseif (isset($product_special_info))
    {
      $this->data['special_manager_product'] = $product_special_info['product_id'];
    } else
    {
      $this->data['special_manager_product'] = '';
    }

    $this->load->model('catalog/category');

    $this->data['categories'] = $this->model_catalog_category->getCategories(0);

    if (isset($this->request->post['customer_group_id']))
    {
      $this->data['customer_group_id'] = $this->request->post['customer_group_id'];
    } elseif (isset($product_special_info))
    {
      $this->data['customer_group_id'] = $product_special_info['customer_group_id'];
    } else
    {
      $this->data['customer_group_id'] = '';
    }

    $this->load->model('sale/customer_group');

    $this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

    if (isset($this->request->post['priority']))
    {
      $this->data['priority'] = $this->request->post['priority'];
    } elseif (isset($product_special_info))
    {
      $this->data['priority'] = $product_special_info['priority'];
    } else
    {
      $this->data['priority'] = '';
    }

    if (!isset($this->request->get['product_special_id']))
    {
      $this->data['update'] = false;
    } else
    {
      $this->data['update'] = true;

      $this->load->model('catalog/product');

      $product_special = $this->model_catalog_special_manager->getProductSpecial($this->request->get['product_special_id']);

      $product_info = $this->model_catalog_product->getProduct($product_special['product_id']);

      $this->data['product_name'] = $product_info['name'];

      $this->data['price'] = $this->currency->format($product_special['original_price']);
      $this->data['special'] = $this->currency->format($product_special['price']);
      $this->data['price_value'] = $product_special['original_price'];
      $this->data['special_value'] = number_format($product_special['price'], 2);

      $diff_fixed = $this->currency->format($product_special['original_price'] - $product_special['price']);
      $diff_percentage = number_format(((1 - ($product_special['price'] / $product_special['original_price'])) * 100), 2) . '%';
      $this->data['text_discount'] = sprintf($this->language->get('text_discount'), $diff_fixed, $diff_percentage);
    }

    if (isset($this->request->post['discount']))
    {
      $this->data['discount'] = $this->request->post['discount'];
    } elseif (isset($product_special_info))
    {
      $this->data['discount'] = $product_special_info['price'];
    } else
    {
      $this->data['discount'] = '';
    }

    if (isset($this->request->post['discount_type']))
    {
      $this->data['discount_type'] = $this->request->post['discount_type'];
    } elseif (isset($product_special_info))
    {
      $this->data['discount_type'] = self::DISCOUNT_TYPE_FIXED_PRICE;
    } else
    {
      $this->data['discount_type'] = self::DISCOUNT_TYPE_PERCENTAGE;
    }

    if (isset($this->request->post['date_start']))
    {
      $this->data['date_start'] = $this->request->post['date_start'];
    } elseif (isset($product_special_info))
    {
      $this->data['date_start'] = $product_special_info['date_start'];
    } else
    {
      $this->data['date_start'] = '';
    }

    if (isset($this->request->post['date_end']))
    {
      $this->data['date_end'] = $this->request->post['date_end'];
    } elseif (isset($product_special_info))
    {
      $this->data['date_end'] = $product_special_info['date_end'];
    } else
    {
      $this->data['date_end'] = '';
    }

    $this->template = 'catalog/special_manager_form_product.tpl';
    $this->children = array(
      'common/header',
      'common/footer'
    );

    $this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  }

  public function getDataTable_product()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $start = $limit = '';
    if (isset($this->request->get['iDisplayStart']) && $this->request->get['iDisplayLength'] != '-1')
    {
      $start = $this->request->get['iDisplayStart'];
      $limit = $this->request->get['iDisplayLength'];
    }

    $sort = $order = '';
    if (isset($this->request->get['iSortCol_0']))
    {
      for ($i = 0; $i < intval($this->request->get['iSortingCols']); $i++)
      {
        if ($this->request->get['bSortable_' . intval($this->request->get['iSortCol_' . $i])] == "true")
        {
          if ($this->productColumns[intval($this->request->get['iSortCol_' . $i])]['sortable'])
          {
            $sort = $this->productColumns[intval($this->request->get['iSortCol_' . $i])]['name'];
            $order = strtoupper($this->request->get['sSortDir_' . $i]);
          }
        }
      }
    }

    $filters = array();
    if (isset($this->request->get['sSearch']) && $this->request->get['sSearch'] != "")
    {
      for ($i = 0; $i < count($this->productColumns); $i++)
      {
        if ($this->productColumns[$i]['searchable'])
        {
          $filters[] = array('name' => $this->productColumns[$i]['name'], 'keyword' => $this->request->get['sSearch']);
        }
      }
    }

    $products = array();

    $sort_columns = array();

    foreach ($this->productColumns as $column)
    {
      if ($column['sortable'])
      {
        $sort_columns[] = $column['name'];
      }
    }

    $data = array(
      'filters' => $filters,
      'sort' => $sort,
      'order' => $order,
      'start' => $start,
      'limit' => $limit,
      'sort_columns' => $sort_columns
    );

    $product_total = $this->model_catalog_special_manager->getTotalProductSpecials($data);

    $results = $this->model_catalog_special_manager->getProductSpecials($data);

    foreach ($results as $result)
    {
      $action = array();

      $action[] = array(
        'text' => $this->language->get('text_edit'),
        'href' => HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_product&token=' . $this->session->data['token'] . '&product_special_id=' . $result['product_special_id']
      );

      $products[] = array(
        $result['product_special_id'],
        $result['product_special_id'],
        $result['name'],
        $result['customer_group'],
        $result['priority'],
        $result['discount'],
        date($this->language->get('date_format_php'), strtotime($result['date_start'])),
        date($this->language->get('date_format_php'), strtotime($result['date_end'])),
        $action
      );
    }

    $output = array(
      'sEcho' => intval($this->request->get['sEcho']),
      'iTotalRecords' => $product_total,
      'iTotalDisplayRecords' => $product_total,
      'aaData' => $products
    );

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($output));
  }

  public function editDataTable_product()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $json = array();

    $json['timestamp'] = date($this->language->get('date_format_php'));

    $json['data'] = $this->request->post['old_value'];

    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $json['error'] = $this->language->get('error_permission');
    } else
    {
      if (isset($this->request->post['value']) && isset($this->request->post['row_id']) && isset($this->request->post['column']) && $this->validateDataTable_product())
      {

        $data = array(
          'key' => $this->productColumns[$this->request->post['column']]['key'],
          'value' => $this->request->post['value'],
          'old_value' => $this->request->post['old_value']
        );

        $json['data'] = $this->model_catalog_special_manager->editProductSpecialDataTable($this->request->post['row_id'], $data);

        $this->cache->delete('product');
      } else
      {
        $json['error'] = $this->error['warning'];
      }
    }

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($json));
  }

  private function validateDataTable_product()
  {
    if (!$this->user->hasPermission('modify', 'catalog/product'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    $column = $this->productColumns[$this->request->post['column']];
    $key = $column['key'];
    $value = $this->request->post['value'];

    if (($key == 'discount' || $key == 'priority') && !is_numeric($value))
    {
      $this->error['warning'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      if (!isset($this->error['warning']))
      {
        $this->error['warning'] = $this->language->get('error_required_data');
      }
      return FALSE;
    }
  }

  private function validateForm_product()
  {
    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    if (!isset($this->request->post['special_manager_product']) || !count($this->request->post['special_manager_product']))
    {
      $this->error['products'] = $this->language->get('error_products');
    }

    if (!is_numeric($this->request->post['priority']))
    {
      $this->error['priority'] = $this->language->get('error_not_numeric');
    }

    if (!is_numeric($this->request->post['discount']))
    {
      $this->error['discount'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      return FALSE;
    }
  }

  public function insert_category()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('category_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_category())
    {
      $this->model_catalog_special_manager->addCategorySpecial($this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_category();
  }

  public function update_category()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('category_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_category())
    {
      $this->model_catalog_special_manager->editCategorySpecial($this->request->get['category_special_id'], $this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_category();
  }

  public function delete_category()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('category_heading_title'));

    $this->load->model('catalog/special_manager');

    if (isset($this->request->post['selected']))
    {
      foreach ($this->request->post['selected'] as $category_special_id)
      {
        $this->model_catalog_special_manager->deleteCategorySpecial($category_special_id);
      }

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getList();
  }

  private function getForm_category()
  {
    $this->data['heading_title'] = $this->language->get('category_heading_title');

    $this->data['text_fixed_discount'] = $this->language->get('text_fixed_discount');
    $this->data['text_fixed_price'] = $this->language->get('text_fixed_price');
    $this->data['text_percentage'] = $this->language->get('text_percentage');
    $this->data['text_select_all'] = $this->language->get('text_select_all');
    $this->data['text_select_none'] = $this->language->get('text_select_none');

    $this->data['categoryEntry_categories'] = $this->language->get('categoryEntry_categories');
    $this->data['categoryEntry_customer_group'] = $this->language->get('categoryEntry_customer_group');
    $this->data['categoryEntry_priority'] = $this->language->get('categoryEntry_priority');
    $this->data['categoryEntry_discount'] = $this->language->get('categoryEntry_discount');
    $this->data['categoryEntry_discount_type'] = $this->language->get('categoryEntry_discount_type');
    $this->data['categoryEntry_price'] = $this->language->get('categoryEntry_price');
    $this->data['categoryEntry_price_new'] = $this->language->get('categoryEntry_price_new');
    $this->data['categoryEntry_date_start'] = $this->language->get('categoryEntry_date_start');
    $this->data['categoryEntry_date_end'] = $this->language->get('categoryEntry_date_end');

    $this->data['button_save'] = $this->language->get('button_save');
    $this->data['button_cancel'] = $this->language->get('button_cancel');

    if (isset($this->error['warning']))
    {
      $this->data['error_warning'] = $this->error['warning'];
    } else
    {
      $this->data['error_warning'] = '';
    }

    if (isset($this->error['categories']))
    {
      $this->data['error_categories'] = $this->error['categories'];
    } else
    {
      $this->data['error_categories'] = '';
    }

    if (isset($this->error['priority']))
    {
      $this->data['error_priority'] = $this->error['priority'];
    } else
    {
      $this->data['error_priority'] = '';
    }

    if (isset($this->error['discount']))
    {
      $this->data['error_discount'] = $this->error['discount'];
    } else
    {
      $this->data['error_discount'] = '';
    }

    $this->data['breadcrumbs'] = array();

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('text_home'),
      'separator' => FALSE
    );

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('catalog/special_manager', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('heading_title'),
      'separator' => ' :: '
    );

    if (!isset($this->request->get['category_special_id']))
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_category&token=' . $this->session->data['token'];
    } else
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_category&token=' . $this->session->data['token'] . '&category_special_id=' . $this->request->get['category_special_id'];
    }

    $this->data['cancel'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token'];

    $this->data['token'] = $this->session->data['token'];

    if (isset($this->request->get['category_special_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST'))
    {
      $category_special_info = $this->model_catalog_special_manager->getCategorySpecial($this->request->get['category_special_id']);
    }

    if (isset($this->request->post['special_manager_category']))
    {
      $this->data['special_manager_category'] = implode(",", $this->request->post['special_manager_category']);
    } elseif (isset($category_special_info))
    {
      $this->data['special_manager_category'] = $category_special_info['category_id'];
    } else
    {
      $this->data['special_manager_category'] = array();
    }

    $this->load->model('catalog/category');

    $this->data['categories'] = $this->model_catalog_category->getCategories(0);

    if (isset($this->request->post['customer_group_id']))
    {
      $this->data['customer_group_id'] = $this->request->post['customer_group_id'];
    } elseif (isset($category_special_info))
    {
      $this->data['customer_group_id'] = $category_special_info['customer_group_id'];
    } else
    {
      $this->data['customer_group_id'] = '';
    }

    $this->load->model('sale/customer_group');

    $this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

    if (isset($this->request->post['priority']))
    {
      $this->data['priority'] = $this->request->post['priority'];
    } elseif (isset($category_special_info))
    {
      $this->data['priority'] = $category_special_info['priority'];
    } else
    {
      $this->data['priority'] = '';
    }

    if (!isset($this->request->get['category_special_id']))
    {
      $this->data['update'] = false;
    } else
    {
      $this->data['update'] = true;

      $this->load->model('catalog/category');

      $category_special = $this->model_catalog_special_manager->getCategorySpecial($this->request->get['category_special_id']);

      $category_info = $this->model_catalog_category->getCategoryDescriptions($category_special['category_id']);

      $this->data['category_name'] = $category_info[$this->config->get('config_language_id')]['name'];
    }

    if (isset($this->request->post['discount']))
    {
      $this->data['discount'] = $this->request->post['discount'];
    } elseif (isset($category_special_info))
    {
      $this->data['discount'] = $category_special_info['discount'];
    } else
    {
      $this->data['discount'] = '';
    }

    if (isset($this->request->post['discount_type']))
    {
      $this->data['discount_type'] = $this->request->post['discount_type'];
    } elseif (isset($category_special_info))
    {
      $this->data['discount_type'] = $category_special_info['discount_type'];
    } else
    {
      $this->data['discount_type'] = self::DISCOUNT_TYPE_PERCENTAGE;
    }

    if (isset($this->request->post['date_start']))
    {
      $this->data['date_start'] = $this->request->post['date_start'];
    } elseif (isset($category_special_info))
    {
      $this->data['date_start'] = $category_special_info['date_start'];
    } else
    {
      $this->data['date_start'] = '';
    }

    if (isset($this->request->post['date_end']))
    {
      $this->data['date_end'] = $this->request->post['date_end'];
    } elseif (isset($category_special_info))
    {
      $this->data['date_end'] = $category_special_info['date_end'];
    } else
    {
      $this->data['date_end'] = '';
    }

    $this->document->addStyle('view/javascript/jquery/dataTables/css/dataTables.css');

    $this->template = 'catalog/special_manager_form_category.tpl';
    $this->children = array(
      'common/header',
      'common/footer'
    );

    $this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  }

  public function getDataTable_category()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $start = $limit = '';
    if (isset($this->request->get['iDisplayStart']) && $this->request->get['iDisplayLength'] != '-1')
    {
      $start = $this->request->get['iDisplayStart'];
      $limit = $this->request->get['iDisplayLength'];
    }

    $sort = $order = '';
    if (isset($this->request->get['iSortCol_0']))
    {
      for ($i = 0; $i < intval($this->request->get['iSortingCols']); $i++)
      {
        if ($this->request->get['bSortable_' . intval($this->request->get['iSortCol_' . $i])] == "true")
        {
          if ($this->categoryColumns[intval($this->request->get['iSortCol_' . $i])]['sortable'])
          {
            $sort = $this->categoryColumns[intval($this->request->get['iSortCol_' . $i])]['name'];
            $order = strtoupper($this->request->get['sSortDir_' . $i]);
          }
        }
      }
    }

    $filters = array();
    if (isset($this->request->get['sSearch']) && $this->request->get['sSearch'] != "")
    {
      for ($i = 0; $i < count($this->categoryColumns); $i++)
      {
        if ($this->categoryColumns[$i]['searchable'])
        {
          $filters[] = array('name' => $this->categoryColumns[$i]['name'], 'keyword' => $this->request->get['sSearch']);
        }
      }
    }

    $categories = array();

    $sort_columns = array();

    foreach ($this->categoryColumns as $column)
    {
      if ($column['sortable'])
      {
        $sort_columns[] = $column['name'];
      }
    }

    $data = array(
      'filters' => $filters,
      'sort' => $sort,
      'order' => $order,
      'start' => $start,
      'limit' => $limit,
      'sort_columns' => $sort_columns
    );

    $category_total = $this->model_catalog_special_manager->getTotalCategorySpecials($data);

    $results = $this->model_catalog_special_manager->getCategorySpecials($data);

    foreach ($results as $result)
    {
      $action = array();

      $action[] = array(
        'text' => $this->language->get('text_edit'),
        'href' => HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_category&token=' . $this->session->data['token'] . '&category_special_id=' . $result['category_special_id']
      );

      if ($result['discount_type'] == self::DISCOUNT_TYPE_PERCENTAGE)
      {
        $discount_type = $this->language->get('text_percentage');
      }
      if ($result['discount_type'] == self::DISCOUNT_TYPE_FIXED_DISCOUNT)
      {
        $discount_type = $this->language->get('text_fixed_discount');
      }
      if ($result['discount_type'] == self::DISCOUNT_TYPE_FIXED_PRICE)
      {
        $discount_type = $this->language->get('text_fixed_price');
      }

      $categories[] = array(
        $result['category_special_id'],
        $result['category_special_id'],
        $result['name'],
        $result['customer_group'],
        $result['priority'],
        $result['discount'],
        $discount_type,
        date($this->language->get('date_format_php'), strtotime($result['date_start'])),
        date($this->language->get('date_format_php'), strtotime($result['date_end'])),
        $action
      );
    }

    $output = array(
      'sEcho' => intval($this->request->get['sEcho']),
      'iTotalRecords' => $category_total,
      'iTotalDisplayRecords' => $category_total,
      'aaData' => $categories
    );

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($output));
  }

  public function editDataTable_category()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $json = array();

    $json['timestamp'] = date($this->language->get('date_format_php'));

    $json['data'] = $this->request->post['old_value'];

    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $json['error'] = $this->language->get('error_permission');
    } else
    {
      if (isset($this->request->post['value']) && isset($this->request->post['row_id']) && isset($this->request->post['column']) && $this->validateDataTable_category())
      {

        $data = array(
          'key' => $this->categoryColumns[$this->request->post['column']]['key'],
          'value' => $this->request->post['value'],
          'old_value' => $this->request->post['old_value']
        );

        $json['data'] = $this->model_catalog_special_manager->editCategorySpecialDataTable($this->request->post['row_id'], $data);

        $this->cache->delete('product');
      } else
      {
        $json['error'] = $this->error['warning'];
      }
    }

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($json));
  }

  private function validateDataTable_category()
  {
    if (!$this->user->hasPermission('modify', 'catalog/category'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    $column = $this->categoryColumns[$this->request->post['column']];
    $key = $column['key'];
    $value = $this->request->post['value'];

    if (($key == 'discount' || $key == 'priority') && !is_numeric($value))
    {
      $this->error['warning'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      if (!isset($this->error['warning']))
      {
        $this->error['warning'] = $this->language->get('error_required_data');
      }
      return FALSE;
    }
  }

  private function validateForm_category()
  {
    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    if (!isset($this->request->post['special_manager_category']) || !count($this->request->post['special_manager_category']))
    {
      $this->error['categories'] = $this->language->get('error_categories');
    }

    if (!is_numeric($this->request->post['priority']))
    {
      $this->error['priority'] = $this->language->get('error_not_numeric');
    }

    if (!is_numeric($this->request->post['discount']))
    {
      $this->error['discount'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      return FALSE;
    }
  }
  
  public function insert_manufacturer()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('manufacturer_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_manufacturer())
    {
      $this->model_catalog_special_manager->addManufacturerSpecial($this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_manufacturer();
  }

  public function update_manufacturer()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('manufacturer_heading_title'));

    $this->load->model('catalog/special_manager');

    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm_manufacturer())
    {
      $this->model_catalog_special_manager->editManufacturerSpecial($this->request->get['manufacturer_special_id'], $this->request->post);

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getForm_manufacturer();
  }

  public function delete_manufacturer()
  {
    $this->load->language('catalog/special_manager');

    $this->document->setTitle($this->language->get('manufacturer_heading_title'));

    $this->load->model('catalog/special_manager');

    if (isset($this->request->post['selected']))
    {
      foreach ($this->request->post['selected'] as $manufacturer_special_id)
      {
        $this->model_catalog_special_manager->deleteManufacturerSpecial($manufacturer_special_id);
      }

      $this->session->data['success'] = $this->language->get('text_success');

      $this->redirect(HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token']);
    }

    $this->getList();
  }

  private function getForm_manufacturer()
  {
    $this->data['heading_title'] = $this->language->get('manufacturer_heading_title');

    $this->data['text_fixed_discount'] = $this->language->get('text_fixed_discount');
    $this->data['text_fixed_price'] = $this->language->get('text_fixed_price');
    $this->data['text_percentage'] = $this->language->get('text_percentage');
    $this->data['text_select_all'] = $this->language->get('text_select_all');
    $this->data['text_select_none'] = $this->language->get('text_select_none');

    $this->data['manufacturerEntry_manufacturers'] = $this->language->get('manufacturerEntry_manufacturers');
    $this->data['manufacturerEntry_customer_group'] = $this->language->get('manufacturerEntry_customer_group');
    $this->data['manufacturerEntry_priority'] = $this->language->get('manufacturerEntry_priority');
    $this->data['manufacturerEntry_discount'] = $this->language->get('manufacturerEntry_discount');
    $this->data['manufacturerEntry_discount_type'] = $this->language->get('manufacturerEntry_discount_type');
    $this->data['manufacturerEntry_price'] = $this->language->get('manufacturerEntry_price');
    $this->data['manufacturerEntry_price_new'] = $this->language->get('manufacturerEntry_price_new');
    $this->data['manufacturerEntry_date_start'] = $this->language->get('manufacturerEntry_date_start');
    $this->data['manufacturerEntry_date_end'] = $this->language->get('manufacturerEntry_date_end');

    $this->data['button_save'] = $this->language->get('button_save');
    $this->data['button_cancel'] = $this->language->get('button_cancel');

    if (isset($this->error['warning']))
    {
      $this->data['error_warning'] = $this->error['warning'];
    } else
    {
      $this->data['error_warning'] = '';
    }

    if (isset($this->error['manufacturers']))
    {
      $this->data['error_manufacturers'] = $this->error['manufacturers'];
    } else
    {
      $this->data['error_manufacturers'] = '';
    }

    if (isset($this->error['priority']))
    {
      $this->data['error_priority'] = $this->error['priority'];
    } else
    {
      $this->data['error_priority'] = '';
    }

    if (isset($this->error['discount']))
    {
      $this->data['error_discount'] = $this->error['discount'];
    } else
    {
      $this->data['error_discount'] = '';
    }

    $this->data['breadcrumbs'] = array();

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('text_home'),
      'separator' => FALSE
    );

    $this->data['breadcrumbs'][] = array(
      'href' => $this->url->link('catalog/special_manager', 'token=' . $this->session->data['token'], 'SSL'),
      'text' => $this->language->get('heading_title'),
      'separator' => ' :: '
    );

    if (!isset($this->request->get['manufacturer_special_id']))
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/insert_manufacturer&token=' . $this->session->data['token'];
    } else
    {
      $this->data['action'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_manufacturer&token=' . $this->session->data['token'] . '&manufacturer_special_id=' . $this->request->get['manufacturer_special_id'];
    }

    $this->data['cancel'] = HTTPS_SERVER . 'index.php?route=catalog/special_manager&token=' . $this->session->data['token'];

    $this->data['token'] = $this->session->data['token'];

    if (isset($this->request->get['manufacturer_special_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST'))
    {
      $manufacturer_special_info = $this->model_catalog_special_manager->getManufacturerSpecial($this->request->get['manufacturer_special_id']);
    }

    if (isset($this->request->post['special_manager_manufacturer']))
    {
      $this->data['special_manager_manufacturer'] = implode(",", $this->request->post['special_manager_manufacturer']);
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['special_manager_manufacturer'] = $manufacturer_special_info['manufacturer_id'];
    } else
    {
      $this->data['special_manager_manufacturer'] = array();
    }

    $this->load->model('catalog/manufacturer');

    $this->data['manufacturers'] = $this->model_catalog_manufacturer->getManufacturers();

    if (isset($this->request->post['customer_group_id']))
    {
      $this->data['customer_group_id'] = $this->request->post['customer_group_id'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['customer_group_id'] = $manufacturer_special_info['customer_group_id'];
    } else
    {
      $this->data['customer_group_id'] = '';
    }

    $this->load->model('sale/customer_group');

    $this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

    if (isset($this->request->post['priority']))
    {
      $this->data['priority'] = $this->request->post['priority'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['priority'] = $manufacturer_special_info['priority'];
    } else
    {
      $this->data['priority'] = '';
    }

    if (!isset($this->request->get['manufacturer_special_id']))
    {
      $this->data['update'] = false;
    } else
    {
      $this->data['update'] = true;

      $this->load->model('catalog/manufacturer');

      $manufacturer_special = $this->model_catalog_special_manager->getManufacturerSpecial($this->request->get['manufacturer_special_id']);

      $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_special['manufacturer_id']);

      $this->data['manufacturer_name'] = $manufacturer_info['name'];
    }

    if (isset($this->request->post['discount']))
    {
      $this->data['discount'] = $this->request->post['discount'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['discount'] = $manufacturer_special_info['discount'];
    } else
    {
      $this->data['discount'] = '';
    }

    if (isset($this->request->post['discount_type']))
    {
      $this->data['discount_type'] = $this->request->post['discount_type'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['discount_type'] = $manufacturer_special_info['discount_type'];
    } else
    {
      $this->data['discount_type'] = self::DISCOUNT_TYPE_PERCENTAGE;
    }

    if (isset($this->request->post['date_start']))
    {
      $this->data['date_start'] = $this->request->post['date_start'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['date_start'] = $manufacturer_special_info['date_start'];
    } else
    {
      $this->data['date_start'] = '';
    }

    if (isset($this->request->post['date_end']))
    {
      $this->data['date_end'] = $this->request->post['date_end'];
    } elseif (isset($manufacturer_special_info))
    {
      $this->data['date_end'] = $manufacturer_special_info['date_end'];
    } else
    {
      $this->data['date_end'] = '';
    }

    $this->document->addStyle('view/javascript/jquery/dataTables/css/dataTables.css');

    $this->template = 'catalog/special_manager_form_manufacturer.tpl';
    $this->children = array(
      'common/header',
      'common/footer'
    );

    $this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  }

  public function getDataTable_manufacturer()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $start = $limit = '';
    if (isset($this->request->get['iDisplayStart']) && $this->request->get['iDisplayLength'] != '-1')
    {
      $start = $this->request->get['iDisplayStart'];
      $limit = $this->request->get['iDisplayLength'];
    }

    $sort = $order = '';
    if (isset($this->request->get['iSortCol_0']))
    {
      for ($i = 0; $i < intval($this->request->get['iSortingCols']); $i++)
      {
        if ($this->request->get['bSortable_' . intval($this->request->get['iSortCol_' . $i])] == "true")
        {
          if ($this->manufacturerColumns[intval($this->request->get['iSortCol_' . $i])]['sortable'])
          {
            $sort = $this->manufacturerColumns[intval($this->request->get['iSortCol_' . $i])]['name'];
            $order = strtoupper($this->request->get['sSortDir_' . $i]);
          }
        }
      }
    }

    $filters = array();
    if (isset($this->request->get['sSearch']) && $this->request->get['sSearch'] != "")
    {
      for ($i = 0; $i < count($this->manufacturerColumns); $i++)
      {
        if ($this->manufacturerColumns[$i]['searchable'])
        {
          $filters[] = array('name' => $this->manufacturerColumns[$i]['name'], 'keyword' => $this->request->get['sSearch']);
        }
      }
    }

    $manufacturers = array();

    $sort_columns = array();

    foreach ($this->manufacturerColumns as $column)
    {
      if ($column['sortable'])
      {
        $sort_columns[] = $column['name'];
      }
    }

    $data = array(
      'filters' => $filters,
      'sort' => $sort,
      'order' => $order,
      'start' => $start,
      'limit' => $limit,
      'sort_columns' => $sort_columns
    );

    $manufacturer_total = $this->model_catalog_special_manager->getTotalManufacturerSpecials($data);

    $results = $this->model_catalog_special_manager->getManufacturerSpecials($data);

    foreach ($results as $result)
    {
      $action = array();

      $action[] = array(
        'text' => $this->language->get('text_edit'),
        'href' => HTTPS_SERVER . 'index.php?route=catalog/special_manager/update_manufacturer&token=' . $this->session->data['token'] . '&manufacturer_special_id=' . $result['manufacturer_special_id']
      );

      if ($result['discount_type'] == self::DISCOUNT_TYPE_PERCENTAGE)
      {
        $discount_type = $this->language->get('text_percentage');
      }
      if ($result['discount_type'] == self::DISCOUNT_TYPE_FIXED_DISCOUNT)
      {
        $discount_type = $this->language->get('text_fixed_discount');
      }
      if ($result['discount_type'] == self::DISCOUNT_TYPE_FIXED_PRICE)
      {
        $discount_type = $this->language->get('text_fixed_price');
      }

      $manufacturers[] = array(
        $result['manufacturer_special_id'],
        $result['manufacturer_special_id'],
        $result['name'],
        $result['customer_group'],
        $result['priority'],
        $result['discount'],
        $discount_type,
        date($this->language->get('date_format_php'), strtotime($result['date_start'])),
        date($this->language->get('date_format_php'), strtotime($result['date_end'])),
        $action
      );
    }

    $output = array(
      'sEcho' => intval($this->request->get['sEcho']),
      'iTotalRecords' => $manufacturer_total,
      'iTotalDisplayRecords' => $manufacturer_total,
      'aaData' => $manufacturers
    );

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($output));
  }

  public function editDataTable_manufacturer()
  {

    $this->load->model('catalog/special_manager');
    $this->load->language('catalog/special_manager');

    $json = array();

    $json['timestamp'] = date($this->language->get('date_format_php'));

    $json['data'] = $this->request->post['old_value'];

    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $json['error'] = $this->language->get('error_permission');
    } else
    {
      if (isset($this->request->post['value']) && isset($this->request->post['row_id']) && isset($this->request->post['column']) && $this->validateDataTable_manufacturer())
      {

        $data = array(
          'key' => $this->manufacturerColumns[$this->request->post['column']]['key'],
          'value' => $this->request->post['value'],
          'old_value' => $this->request->post['old_value']
        );

        $json['data'] = $this->model_catalog_special_manager->editManufacturerSpecialDataTable($this->request->post['row_id'], $data);

        $this->cache->delete('product');
      } else
      {
        $json['error'] = $this->error['warning'];
      }
    }

    $this->data['token'] = $this->session->data['token'];


    $this->response->setOutput(json_encode($json));
  }

  private function validateDataTable_manufacturer()
  {
    if (!$this->user->hasPermission('modify', 'catalog/manufacturer'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    $column = $this->manufacturerColumns[$this->request->post['column']];
    $key = $column['key'];
    $value = $this->request->post['value'];

    if (($key == 'discount' || $key == 'priority') && !is_numeric($value))
    {
      $this->error['warning'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      if (!isset($this->error['warning']))
      {
        $this->error['warning'] = $this->language->get('error_required_data');
      }
      return FALSE;
    }
  }

  private function validateForm_manufacturer()
  {
    if (!$this->user->hasPermission('modify', 'catalog/special_manager'))
    {
      $this->error['warning'] = $this->language->get('error_permission');
    }

    if (!isset($this->request->post['special_manager_manufacturer']) || !count($this->request->post['special_manager_manufacturer']))
    {
      $this->error['manufacturers'] = $this->language->get('error_manufacturers');
    }

    if (!is_numeric($this->request->post['priority']))
    {
      $this->error['priority'] = $this->language->get('error_not_numeric');
    }

    if (!is_numeric($this->request->post['discount']))
    {
      $this->error['discount'] = $this->language->get('error_not_numeric');
    }

    if (!$this->error)
    {
      return TRUE;
    } else
    {
      return FALSE;
    }
  }

  public function category()
  {
    $this->load->model('catalog/product');

    if (isset($this->request->get['category_id']))
    {
      $category_id = $this->request->get['category_id'];
    } else
    {
      $category_id = 0;
    }

    $product_data = array();

    $results = $this->model_catalog_product->getProductsByCategoryId($category_id);

    foreach ($results as $result)
    {
      $product_data[] = array(
        'product_id' => $result['product_id'],
        'name' => $result['name'],
        'model' => $result['model']
      );
    }


    $this->response->setOutput(json_encode($product_data));
  }
  
  public function manufacturer()
  {
    $this->load->model('catalog/product');

    if (isset($this->request->get['manufacturer_id']))
    {
      $manufacturer_id = $this->request->get['manufacturer_id'];
    } else
    {
      $manufacturer_id = 0;
    }

    $product_data = array();

    $results = $this->model_catalog_product->getProductsByCategoryId($manufacturer_id);

    foreach ($results as $result)
    {
      $product_data[] = array(
        'product_id' => $result['product_id'],
        'name' => $result['name'],
        'model' => $result['model']
      );
    }


    $this->response->setOutput(json_encode($product_data));
  }

  public function product()
  {
    $this->load->model('catalog/product');

    if (isset($this->request->post['special_manager_product']))
    {
      $products = $this->request->post['special_manager_product'];
    } else
    {
      $products = array();
    }

    $product_data = array();

    foreach ($products as $product_id)
    {
      $product_info = $this->model_catalog_product->getProduct($product_id);

      if ($product_info)
      {
        $product_data[] = array(
          'product_id' => $product_info['product_id'],
          'name' => $product_info['name'],
          'model' => $product_info['model']
        );
      }
    }


    $this->response->setOutput(json_encode($product_data));
  }

}

?>